/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.StringReader;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportColumnsStmt;
import org.apache.doris.analysis.ImportWhereStmt;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.analysis.Separator;
import org.apache.doris.analysis.SqlParser;
import org.apache.doris.analysis.SqlScanner;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.SqlParserUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.task.LoadTaskInfo;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TStreamLoadPutRequest;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamLoadTask
implements LoadTaskInfo {
    private static final Logger LOG = LogManager.getLogger(StreamLoadTask.class);
    private TUniqueId id;
    private long txnId;
    private TFileType fileType;
    private TFileFormatType formatType;
    private boolean stripOuterArray;
    private boolean numAsString;
    private String jsonPaths;
    private String jsonRoot;
    private boolean fuzzyParse;
    private boolean readJsonByLine;
    private LoadTaskInfo.ImportColumnDescs columnExprDescs = new LoadTaskInfo.ImportColumnDescs();
    private Expr whereExpr;
    private Separator columnSeparator;
    private Separator lineDelimiter;
    private PartitionNames partitions;
    private String path;
    private boolean negative;
    private boolean strictMode = false;
    private String timezone = "Asia/Shanghai";
    private int timeout = Config.stream_load_default_timeout_second;
    private long execMemLimit = 0x80000000L;
    private LoadTask.MergeType mergeType = LoadTask.MergeType.APPEND;
    private Expr deleteCondition;
    private String sequenceCol;
    private int sendBatchParallelism = 1;
    private double maxFilterRatio = 0.0;
    private boolean loadToSingleTablet = false;

    public StreamLoadTask(TUniqueId id, long txnId, TFileType fileType, TFileFormatType formatType) {
        this.id = id;
        this.txnId = txnId;
        this.fileType = fileType;
        this.formatType = formatType;
        this.jsonPaths = "";
        this.jsonRoot = "";
        this.stripOuterArray = false;
        this.numAsString = false;
        this.fuzzyParse = false;
        this.readJsonByLine = false;
    }

    public TUniqueId getId() {
        return this.id;
    }

    @Override
    public long getTxnId() {
        return this.txnId;
    }

    @Override
    public TFileType getFileType() {
        return this.fileType;
    }

    @Override
    public TFileFormatType getFormatType() {
        return this.formatType;
    }

    @Override
    public LoadTaskInfo.ImportColumnDescs getColumnExprDescs() {
        return this.columnExprDescs;
    }

    @Override
    public Expr getPrecedingFilter() {
        return null;
    }

    @Override
    public Expr getWhereExpr() {
        return this.whereExpr;
    }

    @Override
    public Separator getColumnSeparator() {
        return this.columnSeparator;
    }

    @Override
    public Separator getLineDelimiter() {
        return this.lineDelimiter;
    }

    @Override
    public int getSendBatchParallelism() {
        return this.sendBatchParallelism;
    }

    @Override
    public boolean isLoadToSingleTablet() {
        return this.loadToSingleTablet;
    }

    @Override
    public PartitionNames getPartitions() {
        return this.partitions;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean getNegative() {
        return this.negative;
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public String getTimezone() {
        return this.timezone;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isStripOuterArray() {
        return this.stripOuterArray;
    }

    @Override
    public boolean isNumAsString() {
        return this.numAsString;
    }

    @Override
    public boolean isReadJsonByLine() {
        return this.readJsonByLine;
    }

    @Override
    public boolean isFuzzyParse() {
        return this.fuzzyParse;
    }

    public void setFuzzyParse(boolean fuzzyParse) {
        this.fuzzyParse = fuzzyParse;
    }

    public void setStripOuterArray(boolean stripOuterArray) {
        this.stripOuterArray = stripOuterArray;
    }

    public void setNumAsString(boolean numAsString) {
        this.numAsString = numAsString;
    }

    @Override
    public String getJsonPaths() {
        return this.jsonPaths;
    }

    public void setJsonPath(String jsonPaths) {
        this.jsonPaths = jsonPaths;
    }

    @Override
    public String getJsonRoot() {
        return this.jsonRoot;
    }

    public void setJsonRoot(String jsonRoot) {
        this.jsonRoot = jsonRoot;
    }

    @Override
    public LoadTask.MergeType getMergeType() {
        return this.mergeType;
    }

    @Override
    public Expr getDeleteCondition() {
        return this.deleteCondition;
    }

    @Override
    public boolean hasSequenceCol() {
        return !Strings.isNullOrEmpty((String)this.sequenceCol);
    }

    @Override
    public String getSequenceCol() {
        return this.sequenceCol;
    }

    public static StreamLoadTask fromTStreamLoadPutRequest(TStreamLoadPutRequest request) throws UserException {
        StreamLoadTask streamLoadTask = new StreamLoadTask(request.getLoadId(), request.getTxnId(), request.getFileType(), request.getFormatType());
        streamLoadTask.setOptionalFromTSLPutRequest(request);
        return streamLoadTask;
    }

    private void setOptionalFromTSLPutRequest(TStreamLoadPutRequest request) throws UserException {
        if (request.isSetColumns()) {
            this.setColumnToColumnExpr(request.getColumns());
        }
        if (request.isSetWhere()) {
            this.whereExpr = this.parseWhereExpr(request.getWhere());
        }
        if (request.isSetColumnSeparator()) {
            this.setColumnSeparator(request.getColumnSeparator());
        }
        if (request.isSetLineDelimiter()) {
            this.setLineDelimiter(request.getLineDelimiter());
        }
        if (request.isSetPartitions()) {
            Object[] partNames = request.getPartitions().trim().split("\\s*,\\s*");
            this.partitions = request.isSetIsTempPartition() ? new PartitionNames(request.isIsTempPartition(), Lists.newArrayList((Object[])partNames)) : new PartitionNames(false, Lists.newArrayList((Object[])partNames));
        }
        switch (request.getFileType()) {
            case FILE_STREAM: {
                this.path = request.getPath();
                break;
            }
            default: {
                throw new UserException("unsupported file type, type=" + request.getFileType());
            }
        }
        if (request.isSetNegative()) {
            this.negative = request.isNegative();
        }
        if (request.isSetTimeout()) {
            this.timeout = request.getTimeout();
        }
        if (request.isSetStrictMode()) {
            this.strictMode = request.isStrictMode();
        }
        if (request.isSetTimezone()) {
            this.timezone = TimeUtils.checkTimeZoneValidAndStandardize(request.getTimezone());
        }
        if (request.isSetExecMemLimit()) {
            this.execMemLimit = request.getExecMemLimit();
        }
        if (request.getFormatType() == TFileFormatType.FORMAT_JSON) {
            if (request.getJsonpaths() != null) {
                this.jsonPaths = request.getJsonpaths();
            }
            if (request.getJsonRoot() != null) {
                this.jsonRoot = request.getJsonRoot();
            }
            this.stripOuterArray = request.isStripOuterArray();
            this.numAsString = request.isNumAsString();
            this.fuzzyParse = request.isFuzzyParse();
            this.readJsonByLine = request.isReadJsonByLine();
        }
        if (request.isSetMergeType()) {
            try {
                this.mergeType = LoadTask.MergeType.valueOf(request.getMergeType().toString());
            }
            catch (IllegalArgumentException e) {
                throw new UserException("unknown merge type " + request.getMergeType().toString());
            }
        }
        if (request.isSetDeleteCondition()) {
            this.deleteCondition = this.parseWhereExpr(request.getDeleteCondition());
        }
        if (this.negative && this.mergeType != LoadTask.MergeType.APPEND) {
            throw new AnalysisException("Negative is only used when merge type is APPEND.");
        }
        if (request.isSetSequenceCol()) {
            this.sequenceCol = request.getSequenceCol();
        }
        if (request.isSetSendBatchParallelism()) {
            this.sendBatchParallelism = request.getSendBatchParallelism();
        }
        if (request.isSetMaxFilterRatio()) {
            this.maxFilterRatio = request.getMaxFilterRatio();
        }
        if (request.isSetLoadToSingleTablet()) {
            this.loadToSingleTablet = request.isLoadToSingleTablet();
        }
    }

    private void setColumnToColumnExpr(String columns) throws UserException {
        ImportColumnsStmt columnsStmt;
        String columnsSQL = new String("COLUMNS (" + columns + ")");
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(columnsSQL)));
        try {
            columnsStmt = (ImportColumnsStmt)SqlParserUtils.getFirstStmt(parser);
        }
        catch (Error e) {
            LOG.warn("error happens when parsing columns, sql={}", (Object)columnsSQL, (Object)e);
            throw new AnalysisException("failed to parsing columns' header, maybe contain unsupported character");
        }
        catch (AnalysisException e) {
            LOG.warn("analyze columns' statement failed, sql={}, error={}", (Object)columnsSQL, (Object)parser.getErrorMsg(columnsSQL), (Object)e);
            String errorMessage = parser.getErrorMsg(columnsSQL);
            if (errorMessage == null) {
                throw e;
            }
            throw new AnalysisException(errorMessage, e);
        }
        catch (Exception e) {
            LOG.warn("failed to parse columns header, sql={}", (Object)columnsSQL, (Object)e);
            throw new UserException("parse columns header failed", e);
        }
        if (columnsStmt.getColumns() != null && !columnsStmt.getColumns().isEmpty()) {
            this.columnExprDescs.descs = columnsStmt.getColumns();
        }
    }

    private Expr parseWhereExpr(String whereString) throws UserException {
        ImportWhereStmt whereStmt;
        String whereSQL = new String("WHERE " + whereString);
        SqlParser parser = new SqlParser(new SqlScanner(new StringReader(whereSQL)));
        try {
            whereStmt = (ImportWhereStmt)SqlParserUtils.getFirstStmt(parser);
        }
        catch (Error e) {
            LOG.warn("error happens when parsing where header, sql={}", (Object)whereSQL, (Object)e);
            throw new AnalysisException("failed to parsing where header, maybe contain unsupported character");
        }
        catch (AnalysisException e) {
            LOG.warn("analyze where statement failed, sql={}, error={}", (Object)whereSQL, (Object)parser.getErrorMsg(whereSQL), (Object)e);
            String errorMessage = parser.getErrorMsg(whereSQL);
            if (errorMessage == null) {
                throw e;
            }
            throw new AnalysisException(errorMessage, e);
        }
        catch (Exception e) {
            LOG.warn("failed to parse where header, sql={}", (Object)whereSQL, (Object)e);
            throw new UserException("parse columns header failed", e);
        }
        return whereStmt.getExpr();
    }

    private void setColumnSeparator(String oriSeparator) throws AnalysisException {
        this.columnSeparator = new Separator(oriSeparator);
        this.columnSeparator.analyze();
    }

    private void setLineDelimiter(String oriLineDelimiter) throws AnalysisException {
        this.lineDelimiter = new Separator(oriLineDelimiter);
        this.lineDelimiter.analyze();
    }

    @Override
    public long getMemLimit() {
        return this.execMemLimit;
    }

    @Override
    public double getMaxFilterRatio() {
        return this.maxFilterRatio;
    }
}

