/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TSnapshotRequest;
import org.apache.doris.thrift.TTaskType;

public class SnapshotTask
extends AgentTask {
    private long jobId;
    private long version;
    private int schemaHash;
    private long timeoutMs;
    private boolean isRestoreTask;

    public SnapshotTask(TResourceInfo resourceInfo, long backendId, long signature, long jobId, long dbId, long tableId, long partitionId, long indexId, long tabletId, long version, int schemaHash, long timeoutMs, boolean isRestoreTask) {
        super(resourceInfo, backendId, TTaskType.MAKE_SNAPSHOT, dbId, tableId, partitionId, indexId, tabletId, signature);
        this.jobId = jobId;
        this.version = version;
        this.schemaHash = schemaHash;
        this.timeoutMs = timeoutMs;
        this.isRestoreTask = isRestoreTask;
    }

    public long getJobId() {
        return this.jobId;
    }

    public long getVersion() {
        return this.version;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public boolean isRestoreTask() {
        return this.isRestoreTask;
    }

    public TSnapshotRequest toThrift() {
        TSnapshotRequest request = new TSnapshotRequest(this.tabletId, this.schemaHash);
        request.setVersion(this.version);
        request.setListFiles(true);
        request.setPreferredSnapshotVersion(4);
        request.setTimeout(this.timeoutMs / 1000L);
        return request;
    }
}

