/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.concurrent.ExecutorService;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.task.SerialExecutor;

public class SerialExecutorService {
    private final int numOfSlots;
    private final ExecutorService taskPool;
    private final SerialExecutor[] slots;

    private SerialExecutorService(int numOfSlots, ExecutorService taskPool) {
        this.numOfSlots = numOfSlots;
        this.slots = new SerialExecutor[numOfSlots];
        this.taskPool = taskPool;
        for (int i = 0; i < numOfSlots; ++i) {
            this.slots[i] = new SerialExecutor(taskPool);
        }
    }

    public SerialExecutorService(int numOfSlots) {
        this(numOfSlots, ThreadPoolManager.newDaemonFixedThreadPool(numOfSlots, 256, "sync-task-pool", true));
    }

    public void submit(Runnable command) {
        int index = this.getIndex(command);
        if (this.isSlotIndex(index)) {
            SerialExecutor serialEx = this.slots[index];
            serialEx.execute(command);
        } else {
            this.taskPool.execute(command);
        }
    }

    private int getIndex(Runnable command) {
        int index = -1;
        if (command instanceof SerialRunnable) {
            index = ((SerialRunnable)command).getIndex();
        }
        return index;
    }

    private boolean isSlotIndex(int index) {
        return index >= 0 && index < this.numOfSlots;
    }

    public void close() {
        for (int i = 0; i < this.numOfSlots; ++i) {
            SerialExecutor serialEx = this.slots[i];
            serialEx.shutdown();
        }
    }

    public static interface SerialRunnable
    extends Runnable {
        public int getIndex();
    }
}

