/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class SerialExecutor
extends AbstractExecutorService {
    private final ExecutorService taskPool;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition terminating = this.lock.newCondition();
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    private Runnable active;
    private boolean shutdown;

    public SerialExecutor(ExecutorService executor) {
        Preconditions.checkNotNull((Object)executor);
        this.taskPool = executor;
    }

    @Override
    public void execute(final Runnable r) {
        this.lock.lock();
        try {
            this.checkPoolIsRunning();
            this.tasks.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.active == null) {
                this.scheduleNext();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkPoolIsRunning() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (this.shutdown) {
            throw new RejectedExecutionException("SerialExecutor is already shutdown");
        }
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.lock.lock();
        try {
            this.shutdown = true;
            ArrayList<Runnable> result = new ArrayList<Runnable>();
            this.tasks.drainTo(result);
            ArrayList<Runnable> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isTerminated() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown && this.active == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            long remainingTime;
            long waitUntil = System.nanoTime() + unit.toNanos(timeout);
            while (!((remainingTime = waitUntil - System.nanoTime()) <= 0L || this.shutdown && this.active == null)) {
                this.terminating.awaitNanos(remainingTime);
            }
            boolean bl = remainingTime > 0L;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void scheduleNext() {
        this.lock.lock();
        try {
            this.active = (Runnable)this.tasks.poll();
            if (this.active != null) {
                this.taskPool.execute(this.active);
            } else if (this.shutdown) {
                this.terminating.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

