/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TBrokerScanRange;
import org.apache.doris.thrift.TCondition;
import org.apache.doris.thrift.TDescriptorTable;
import org.apache.doris.thrift.TPriority;
import org.apache.doris.thrift.TPushReq;
import org.apache.doris.thrift.TPushType;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PushTask
extends AgentTask {
    private static final Logger LOG = LogManager.getLogger(PushTask.class);
    private long replicaId;
    private int schemaHash;
    private long version;
    private String filePath;
    private long fileSize;
    private int timeoutSecond;
    private long loadJobId;
    private TPushType pushType;
    private List<Predicate> conditions;
    private MarkedCountDownLatch latch;
    private boolean needDecompress;
    private TPriority priority;
    private boolean isSyncDelete;
    private long asyncDeleteJobId;
    private long transactionId;
    private boolean isSchemaChanging;
    private TBrokerScanRange tBrokerScanRange;
    private TDescriptorTable tDescriptorTable;

    public PushTask(TResourceInfo resourceInfo, long backendId, long dbId, long tableId, long partitionId, long indexId, long tabletId, long replicaId, int schemaHash, long version, String filePath, long fileSize, int timeoutSecond, long loadJobId, TPushType pushType, List<Predicate> conditions, boolean needDecompress, TPriority priority, TTaskType taskType, long transactionId, long signature) {
        super(resourceInfo, backendId, taskType, dbId, tableId, partitionId, indexId, tabletId, signature);
        this.replicaId = replicaId;
        this.schemaHash = schemaHash;
        this.version = version;
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.timeoutSecond = timeoutSecond;
        this.loadJobId = loadJobId;
        this.pushType = pushType;
        this.conditions = conditions;
        this.latch = null;
        this.needDecompress = needDecompress;
        this.priority = priority;
        this.isSyncDelete = true;
        this.asyncDeleteJobId = -1L;
        this.transactionId = transactionId;
        this.tBrokerScanRange = null;
        this.tDescriptorTable = null;
    }

    public PushTask(TResourceInfo resourceInfo, long backendId, long dbId, long tableId, long partitionId, long indexId, long tabletId, long replicaId, int schemaHash, long version, String filePath, long fileSize, int timeoutSecond, long loadJobId, TPushType pushType, List<Predicate> conditions, boolean needDecompress, TPriority priority) {
        this(resourceInfo, backendId, dbId, tableId, partitionId, indexId, tabletId, replicaId, schemaHash, version, filePath, fileSize, timeoutSecond, loadJobId, pushType, conditions, needDecompress, priority, TTaskType.PUSH, -1L, tableId);
    }

    public PushTask(long backendId, long dbId, long tableId, long partitionId, long indexId, long tabletId, long replicaId, int schemaHash, int timeoutSecond, long loadJobId, TPushType pushType, TPriority priority, long transactionId, long signature, TBrokerScanRange tBrokerScanRange, TDescriptorTable tDescriptorTable) {
        this(null, backendId, dbId, tableId, partitionId, indexId, tabletId, replicaId, schemaHash, -1L, null, 0L, timeoutSecond, loadJobId, pushType, null, false, priority, TTaskType.REALTIME_PUSH, transactionId, signature);
        this.tBrokerScanRange = tBrokerScanRange;
        this.tDescriptorTable = tDescriptorTable;
    }

    public TPushReq toThrift() {
        TPushReq request = new TPushReq(this.tabletId, this.schemaHash, this.version, 0L, (long)this.timeoutSecond, this.pushType);
        if (this.taskType == TTaskType.REALTIME_PUSH) {
            request.setPartitionId(this.partitionId);
            request.setTransactionId(this.transactionId);
        }
        request.setIsSchemaChanging(this.isSchemaChanging);
        switch (this.pushType) {
            case LOAD: 
            case LOAD_DELETE: {
                request.setHttpFilePath(this.filePath);
                if (this.fileSize != -1L) {
                    request.setHttpFileSize(this.fileSize);
                }
                request.setNeedDecompress(this.needDecompress);
                break;
            }
            case DELETE: {
                ArrayList<TCondition> tConditions = new ArrayList<TCondition>();
                for (Predicate condition : this.conditions) {
                    String op;
                    String columnName;
                    TCondition tCondition = new TCondition();
                    ArrayList<String> conditionValues = new ArrayList<String>();
                    if (condition instanceof BinaryPredicate) {
                        BinaryPredicate binaryPredicate = (BinaryPredicate)condition;
                        columnName = ((SlotRef)binaryPredicate.getChild(0)).getColumnName();
                        String value = ((LiteralExpr)binaryPredicate.getChild(1)).getStringValue();
                        BinaryPredicate.Operator op2 = binaryPredicate.getOp();
                        tCondition.setColumnName(columnName);
                        tCondition.setConditionOp(op2.toString());
                        conditionValues.add(value);
                    } else if (condition instanceof IsNullPredicate) {
                        IsNullPredicate isNullPredicate = (IsNullPredicate)condition;
                        columnName = ((SlotRef)isNullPredicate.getChild(0)).getColumnName();
                        op = "IS";
                        String value = "NULL";
                        if (isNullPredicate.isNotNull()) {
                            value = "NOT NULL";
                        }
                        tCondition.setColumnName(columnName);
                        tCondition.setConditionOp(op);
                        conditionValues.add(value);
                    } else if (condition instanceof InPredicate) {
                        InPredicate inPredicate = (InPredicate)condition;
                        columnName = ((SlotRef)inPredicate.getChild(0)).getColumnName();
                        op = inPredicate.isNotIn() ? "!*=" : "*=";
                        tCondition.setColumnName(columnName);
                        tCondition.setConditionOp(op);
                        for (int i = 1; i <= inPredicate.getInElementNum(); ++i) {
                            conditionValues.add(((LiteralExpr)inPredicate.getChild(i)).getStringValue());
                        }
                    }
                    tCondition.setConditionValues(conditionValues);
                    tConditions.add(tCondition);
                }
                request.setDeleteConditions(tConditions);
                break;
            }
            case LOAD_V2: {
                request.setBrokerScanRange(this.tBrokerScanRange);
                request.setDescTbl(this.tDescriptorTable);
                break;
            }
            default: {
                LOG.warn("unknown push type. type: " + this.pushType.name());
            }
        }
        return request;
    }

    public void setCountDownLatch(MarkedCountDownLatch latch) {
        this.latch = latch;
    }

    public void countDownLatch(long backendId, long tabletId) {
        if (this.latch != null && this.latch.markedCountDown(backendId, tabletId)) {
            LOG.debug("pushTask current latch count: {}. backend: {}, tablet:{}", (Object)this.latch.getCount(), (Object)backendId, (Object)tabletId);
        }
    }

    public long getReplicaId() {
        return this.replicaId;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public long getVersion() {
        return this.version;
    }

    public long getLoadJobId() {
        return this.loadJobId;
    }

    public TPushType getPushType() {
        return this.pushType;
    }

    public TPriority getPriority() {
        return this.priority;
    }

    public void setIsSyncDelete(boolean isSyncDelete) {
        this.isSyncDelete = isSyncDelete;
    }

    public boolean isSyncDelete() {
        return this.isSyncDelete;
    }

    public void setAsyncDeleteJobId(long jobId) {
        this.asyncDeleteJobId = jobId;
    }

    public long getAsyncDeleteJobId() {
        return this.asyncDeleteJobId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setIsSchemaChanging(boolean isSchemaChanging) {
        this.isSchemaChanging = isSchemaChanging;
    }
}

