/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.ArrayList;
import java.util.List;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TPartitionVersionInfo;
import org.apache.doris.thrift.TPublishVersionRequest;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PublishVersionTask
extends AgentTask {
    private static final Logger LOG = LogManager.getLogger(PublishVersionTask.class);
    private long transactionId;
    private List<TPartitionVersionInfo> partitionVersionInfos;
    private List<Long> errorTablets;
    private boolean isFinished;

    public PublishVersionTask(long backendId, long transactionId, long dbId, List<TPartitionVersionInfo> partitionVersionInfos, long createTime) {
        super(null, backendId, TTaskType.PUBLISH_VERSION, dbId, -1L, -1L, -1L, -1L, transactionId, createTime);
        this.transactionId = transactionId;
        this.partitionVersionInfos = partitionVersionInfos;
        this.errorTablets = new ArrayList<Long>();
        this.isFinished = false;
    }

    public TPublishVersionRequest toThrift() {
        TPublishVersionRequest publishVersionRequest = new TPublishVersionRequest(this.transactionId, this.partitionVersionInfos);
        return publishVersionRequest;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public List<TPartitionVersionInfo> getPartitionVersionInfos() {
        return this.partitionVersionInfos;
    }

    public synchronized List<Long> getErrorTablets() {
        return this.errorTablets;
    }

    public synchronized void addErrorTablets(List<Long> errorTablets) {
        this.errorTablets.clear();
        if (errorTablets == null) {
            return;
        }
        this.errorTablets.addAll(errorTablets);
    }

    public void setIsFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }
}

