/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.task.MasterTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MasterTaskExecutor {
    private static final Logger LOG = LogManager.getLogger(MasterTaskExecutor.class);
    private ThreadPoolExecutor executor;
    private Map<Long, Future<?>> runningTasks;
    public ScheduledThreadPoolExecutor scheduledThreadPool;

    public MasterTaskExecutor(String name, int threadNum, boolean needRegisterMetric) {
        this.executor = ThreadPoolManager.newDaemonFixedThreadPool(threadNum, threadNum * 2, name + "_pool", needRegisterMetric);
        this.runningTasks = Maps.newHashMap();
        this.scheduledThreadPool = ThreadPoolManager.newDaemonScheduledThreadPool(1, name + "_scheduler_thread_pool", needRegisterMetric);
    }

    public MasterTaskExecutor(String name, int threadNum, int queueSize, boolean needRegisterMetric) {
        this.executor = ThreadPoolManager.newDaemonFixedThreadPool(threadNum, queueSize, name + "_pool", needRegisterMetric);
        this.runningTasks = Maps.newHashMap();
        this.scheduledThreadPool = ThreadPoolManager.newDaemonScheduledThreadPool(1, name + "_scheduler_thread_pool", needRegisterMetric);
    }

    public boolean hasIdleThread() {
        return this.executor.getActiveCount() < this.executor.getMaximumPoolSize();
    }

    public void start() {
        this.scheduledThreadPool.scheduleAtFixedRate(new TaskChecker(), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submit(MasterTask task) {
        long signature = task.getSignature();
        Map<Long, Future<?>> map = this.runningTasks;
        synchronized (map) {
            if (this.runningTasks.containsKey(signature)) {
                return false;
            }
            Future<?> future = this.executor.submit(task);
            this.runningTasks.put(signature, future);
            return true;
        }
    }

    public void close() {
        this.scheduledThreadPool.shutdown();
        this.executor.shutdown();
        this.runningTasks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskNum() {
        Map<Long, Future<?>> map = this.runningTasks;
        synchronized (map) {
            return this.runningTasks.size();
        }
    }

    private class TaskChecker
    implements Runnable {
        private TaskChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Map map = MasterTaskExecutor.this.runningTasks;
                synchronized (map) {
                    Iterator iterator = MasterTaskExecutor.this.runningTasks.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Future future = (Future)entry.getValue();
                        if (!future.isDone()) continue;
                        iterator.remove();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("check task error", (Throwable)e);
            }
        }
    }
}

