/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.UUID;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.load.EtlSubmitResult;
import org.apache.doris.load.FailMsg;
import org.apache.doris.load.Load;
import org.apache.doris.load.LoadChecker;
import org.apache.doris.load.LoadJob;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.task.MasterTask;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LoadPendingTask
extends MasterTask {
    private static final Logger LOG = LogManager.getLogger(LoadPendingTask.class);
    private static final int RETRY_NUM = 5;
    protected final LoadJob job;
    protected final Load load;
    protected Database db;

    public LoadPendingTask(LoadJob job) {
        this.job = job;
        this.signature = job.getId();
        this.load = Catalog.getCurrentCatalog().getLoadInstance();
    }

    @Override
    protected void exec() {
        if (this.job.getState() != LoadJob.JobState.PENDING) {
            return;
        }
        if (LoadChecker.checkTimeout(this.job)) {
            this.load.cancelLoadJob(this.job, FailMsg.CancelType.TIMEOUT, "pending timeout to cancel");
            return;
        }
        long dbId = this.job.getDbId();
        this.db = Catalog.getCurrentCatalog().getDbNullable(dbId);
        if (this.db == null) {
            this.load.cancelLoadJob(this.job, FailMsg.CancelType.ETL_SUBMIT_FAIL, "db does not exist. id: " + dbId);
            return;
        }
        try {
            if (this.job.getTransactionId() < 0L) {
                long transactionId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(dbId, this.job.getAllTableIds(), DebugUtil.printId(UUID.randomUUID()), new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.FE, FrontendOptions.getLocalHostAddress()), TransactionState.LoadJobSourceType.FRONTEND, this.job.getTimeoutSecond());
                this.job.setTransactionId(transactionId);
            }
            this.createEtlRequest();
        }
        catch (Exception e) {
            LOG.info("create etl request failed.", (Throwable)e);
            this.load.cancelLoadJob(this.job, FailMsg.CancelType.ETL_SUBMIT_FAIL, "create job request fail. " + e.getMessage());
            return;
        }
        EtlSubmitResult result = null;
        for (int retry = 0; retry < 5; ++retry) {
            result = this.submitEtlJob(retry);
            if (result == null || result.getStatus().getStatusCode() != TStatusCode.OK || !this.load.updateLoadJobState(this.job, LoadJob.JobState.ETL)) continue;
            LOG.info("submit etl job success. job: {}", (Object)this.job);
            return;
        }
        String failMsg = "submit etl job fail";
        if (result != null) {
            List failMsgs = result.getStatus().getErrorMsgs();
            failMsg = Joiner.on((String)";").join((Iterable)failMsgs);
        }
        this.load.cancelLoadJob(this.job, FailMsg.CancelType.ETL_SUBMIT_FAIL, failMsg);
        LOG.warn("submit etl job fail. job: {}", (Object)this.job);
    }

    protected abstract void createEtlRequest() throws Exception;

    protected abstract EtlSubmitResult submitEtlJob(int var1);
}

