/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.Pair;
import org.apache.doris.load.DppConfig;
import org.apache.doris.load.DppScheduler;
import org.apache.doris.load.EtlSubmitResult;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.PartitionLoadInfo;
import org.apache.doris.load.Source;
import org.apache.doris.load.TableLoadInfo;
import org.apache.doris.task.LoadPendingTask;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HadoopLoadPendingTask
extends LoadPendingTask {
    private static final Logger LOG = LogManager.getLogger(HadoopLoadPendingTask.class);
    private Map<String, Object> etlTaskConf;

    public HadoopLoadPendingTask(LoadJob job) {
        super(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createEtlRequest() throws Exception {
        EtlTaskConf taskConf = new EtlTaskConf();
        taskConf.setOutputPath(this.getOutputPath());
        taskConf.setOutputFilePattern(this.job.getLabel() + ".%(table)s.%(view)s.%(bucket)s");
        Map<String, EtlPartitionConf> etlPartitions = this.createEtlPartitions();
        Preconditions.checkNotNull(etlPartitions);
        taskConf.setEtlPartitions(etlPartitions);
        LoadErrorHub.Param info = this.load.getLoadErrorHubInfo();
        if (info != null && info.getType() == LoadErrorHub.HubType.MYSQL_TYPE) {
            taskConf.setHubInfo(new EtlErrorHubInfo(this.job.getId(), info));
        }
        this.etlTaskConf = taskConf.toDppTaskConf();
        Preconditions.checkNotNull(this.etlTaskConf);
        TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(this.job.getDbId(), this.job.getTransactionId());
        if (txnState == null) {
            throw new LoadException("txn does not exist: " + this.job.getTransactionId());
        }
        for (long tableId : this.job.getIdToTableLoadInfo().keySet()) {
            OlapTable table = (OlapTable)this.db.getTableOrException(tableId, s -> new LoadException("table does not exist. id: " + s));
            table.readLock();
            try {
                txnState.addTableIndexes(table);
            }
            finally {
                table.readUnlock();
            }
        }
    }

    @Override
    protected EtlSubmitResult submitEtlJob(int retry) {
        LOG.info("begin submit hadoop etl job: {}", (Object)this.job);
        this.etlTaskConf.put("output_path", this.getOutputPath());
        DppScheduler dppScheduler = new DppScheduler(this.job.getHadoopDppConfig());
        EtlSubmitResult result = dppScheduler.submitEtlJob(this.job.getId(), this.job.getLabel(), this.job.getHadoopCluster(), this.db.getFullName(), this.etlTaskConf, retry);
        if (result != null && result.getStatus().getStatusCode() == TStatusCode.OK) {
            this.job.setHadoopEtlJobId(result.getEtlJobId());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, EtlPartitionConf> createEtlPartitions() throws LoadException {
        HashMap etlPartitions = Maps.newHashMap();
        for (Map.Entry<Long, TableLoadInfo> tableEntry : this.job.getIdToTableLoadInfo().entrySet()) {
            long tableId = tableEntry.getKey();
            TableLoadInfo tableLoadInfo = tableEntry.getValue();
            OlapTable table = (OlapTable)this.db.getTableOrException(tableId, s -> new LoadException("table does not exist. id: " + s));
            table.readLock();
            try {
                Map<String, EtlColumn> etlColumns = this.createEtlColumns(table);
                Map<Long, PartitionLoadInfo> idToPartitionLoadInfo = tableLoadInfo.getIdToPartitionLoadInfo();
                for (Map.Entry<Long, PartitionLoadInfo> partitionEntry : idToPartitionLoadInfo.entrySet()) {
                    long partitionId = partitionEntry.getKey();
                    PartitionLoadInfo partitionLoadInfo = partitionEntry.getValue();
                    EtlPartitionConf etlPartitionConf = new EtlPartitionConf();
                    etlPartitionConf.setColumns(etlColumns);
                    Map<String, EtlIndex> etlIndices = this.createEtlIndices(table, partitionId);
                    Preconditions.checkNotNull(etlIndices);
                    etlPartitionConf.setIndices(etlIndices);
                    etlPartitionConf.setSources(this.createSources(partitionLoadInfo));
                    etlPartitionConf.setPartitionInfo(this.createPartitionInfo(table, partitionId));
                    etlPartitions.put(String.valueOf(partitionId), etlPartitionConf);
                }
            }
            finally {
                table.readUnlock();
            }
        }
        return etlPartitions;
    }

    private Map<String, EtlColumn> createEtlColumns(OlapTable table) {
        HashMap etlColumns = Maps.newHashMap();
        for (Column column : table.getBaseSchema(true)) {
            etlColumns.put(column.getName(), new EtlColumn(column));
        }
        return etlColumns;
    }

    private Map<String, EtlIndex> createEtlIndices(OlapTable table, long partitionId) throws LoadException {
        HashMap etlIndices = Maps.newHashMap();
        TableLoadInfo tableLoadInfo = this.job.getTableLoadInfo(table.getId());
        for (Map.Entry<Long, MaterializedIndexMeta> entry : table.getIndexIdToMeta().entrySet()) {
            long indexId = entry.getKey();
            MaterializedIndexMeta indexMeta = entry.getValue();
            List<Column> indexColumns = indexMeta.getSchema();
            Partition partition = table.getPartition(partitionId);
            if (partition == null) {
                throw new LoadException("partition does not exist. id: " + partitionId);
            }
            EtlIndex etlIndex = new EtlIndex();
            etlIndex.setKeysType(table.getKeysType());
            etlIndex.setIndexId(indexId);
            int schemaHash = indexMeta.getSchemaHash();
            etlIndex.setSchemaHash(schemaHash);
            tableLoadInfo.addIndexSchemaHash(indexId, schemaHash);
            int keySize = 0;
            ArrayList columnRefs = Lists.newArrayList();
            for (Column column : indexColumns) {
                HashMap dppColumn = Maps.newHashMap();
                dppColumn.put("name", column.getName());
                if (column.isKey()) {
                    dppColumn.put("is_key", true);
                    ++keySize;
                } else {
                    dppColumn.put("is_key", false);
                    String aggregation = "none";
                    if ("AGG_KEYS" == table.getKeysType().name()) {
                        AggregateType aggregateType = column.getAggregationType();
                        aggregation = AggregateType.SUM == aggregateType ? "ADD" : aggregateType.name();
                    } else if (table.getKeysType().name().equalsIgnoreCase("UNIQUE_KEYS")) {
                        aggregation = "REPLACE";
                    }
                    dppColumn.put("aggregation_method", aggregation);
                }
                columnRefs.add(dppColumn);
            }
            DistributionInfo distributionInfo = partition.getDistributionInfo();
            ArrayList distributionColumnRefs = Lists.newArrayList();
            etlIndex.setDistributionColumnRefs(distributionColumnRefs);
            etlIndex.setPartitionMethod("hash");
            etlIndex.setHashMod(distributionInfo.getBucketNum());
            switch (distributionInfo.getType()) {
                case RANDOM: {
                    etlIndex.setHashMethod("CRC32");
                    for (int i = 0; i < keySize; ++i) {
                        distributionColumnRefs.add(((Map)columnRefs.get(i)).get("name").toString());
                    }
                    break;
                }
                case HASH: {
                    etlIndex.setHashMethod("CRC32");
                    HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)distributionInfo;
                    for (Column column : hashDistributionInfo.getDistributionColumns()) {
                        distributionColumnRefs.add(column.getName());
                        boolean isImplicit = true;
                        Iterator iter = columnRefs.iterator();
                        while (iter.hasNext()) {
                            if (!((Map)iter.next()).get("name").equals(column.getName())) continue;
                            isImplicit = false;
                            break;
                        }
                        if (!isImplicit) continue;
                        HashMap dppColumn = Maps.newHashMap();
                        dppColumn.put("name", column.getName());
                        dppColumn.put("is_key", true);
                        dppColumn.put("is_implicit", true);
                        columnRefs.add(keySize, dppColumn);
                        ++keySize;
                    }
                    break;
                }
                default: {
                    LOG.warn("unknown distribution type. type: {}", (Object)distributionInfo.getType().name());
                    throw new LoadException("unknown distribution type. type: " + distributionInfo.getType().name());
                }
            }
            etlIndex.setPidKeyCount(keySize);
            etlIndex.setColumnRefs(columnRefs);
            etlIndices.put(String.valueOf(indexId), etlIndex);
        }
        return etlIndices;
    }

    private Map<String, EtlSource> createSources(PartitionLoadInfo partitionLoadInfo) {
        HashMap sources = Maps.newHashMap();
        int sourceIndex = 0;
        for (Source source : partitionLoadInfo.getSources()) {
            sources.put("schema" + sourceIndex, new EtlSource(source));
            ++sourceIndex;
        }
        return sources;
    }

    private EtlPartitionInfo createPartitionInfo(OlapTable table, long partitionId) {
        PartitionInfo partitionInfo = table.getPartitionInfo();
        switch (partitionInfo.getType()) {
            case RANGE: {
                RangePartitionInfo rangePartitionInfo = (RangePartitionInfo)partitionInfo;
                ArrayList partitionColumnNames = Lists.newArrayList();
                for (Column column : rangePartitionInfo.getPartitionColumns()) {
                    partitionColumnNames.add(column.getName());
                }
                Range range = (Range)rangePartitionInfo.getItem(partitionId).getItems();
                boolean isMaxPartition = ((PartitionKey)range.upperEndpoint()).isMaxValue();
                List<LiteralExpr> rangeKeyExprs = ((PartitionKey)range.lowerEndpoint()).getKeys();
                ArrayList startKeys = Lists.newArrayList();
                for (int i = 0; i < rangeKeyExprs.size(); ++i) {
                    LiteralExpr literalExpr = rangeKeyExprs.get(i);
                    Object keyValue = literalExpr.getRealValue();
                    startKeys.add(keyValue);
                }
                ArrayList endKeys = Lists.newArrayList();
                if (!isMaxPartition) {
                    rangeKeyExprs = ((PartitionKey)range.upperEndpoint()).getKeys();
                    for (int i = 0; i < rangeKeyExprs.size(); ++i) {
                        LiteralExpr literalExpr = rangeKeyExprs.get(i);
                        Object keyValue = literalExpr.getRealValue();
                        endKeys.add(keyValue);
                    }
                }
                return new EtlPartitionInfo(table.getId(), partitionColumnNames, "range", startKeys, endKeys, isMaxPartition);
            }
            case UNPARTITIONED: {
                break;
            }
            default: {
                LOG.error("unknown partition type. type: {}", (Object)partitionInfo.getType().name());
            }
        }
        return null;
    }

    private String getOutputPath() {
        this.job.setHadoopEtlOutputDir(String.valueOf(System.currentTimeMillis()));
        String loadLabel = this.job.getLabel();
        DppConfig dppConfig = this.job.getHadoopDppConfig();
        String outputPath = DppScheduler.getEtlOutputPath(dppConfig.getFsDefaultName(), dppConfig.getOutputPath(), this.job.getDbId(), loadLabel, this.job.getHadoopEtlOutputDir());
        return outputPath;
    }

    private class EtlPartitionInfo {
        private long tableId;
        private List<String> tablePartitionColumnRefs;
        private String tablePartitionMethod;
        private List<Object> startKeys;
        private List<Object> endKeys;
        private boolean isMaxPartition;

        public EtlPartitionInfo(long tableId, List<String> tablePartitionColumnRefs, String tablePartitionMethod, List<Object> startKeys, List<Object> endKeys, boolean isMaxPartition) {
            this.tableId = tableId;
            this.tablePartitionColumnRefs = tablePartitionColumnRefs;
            this.tablePartitionMethod = tablePartitionMethod;
            this.startKeys = startKeys;
            this.endKeys = endKeys;
            this.isMaxPartition = isMaxPartition;
        }

        public Map<String, Object> toDppPartitionInfo() {
            HashMap partitionInfo = Maps.newHashMap();
            partitionInfo.put("group_id", this.tableId);
            partitionInfo.put("group_partition_column_refs", this.tablePartitionColumnRefs);
            partitionInfo.put("group_partition_method", this.tablePartitionMethod);
            partitionInfo.put("start_keys", this.startKeys);
            partitionInfo.put("end_keys", this.endKeys);
            partitionInfo.put("is_max_partition", this.isMaxPartition);
            return partitionInfo;
        }
    }

    private class EtlIndex {
        private static final String OUTPUT_FORMAT = "palo";
        private static final String BE_INDEX_NAME = "PRIMARY";
        private KeysType keysType;
        private long indexId;
        private List<Map<String, Object>> columnRefs;
        private int schemaHash;
        private String partitionMethod;
        private String hashMethod;
        private int hashMod;
        private List<String> distributionColumnRefs;
        private int pidKeyCount;

        private EtlIndex() {
        }

        public void setKeysType(KeysType keysType) {
            this.keysType = keysType;
        }

        public void setIndexId(long indexId) {
            this.indexId = indexId;
        }

        public void setColumnRefs(List<Map<String, Object>> columnRefs) {
            this.columnRefs = columnRefs;
        }

        public void setSchemaHash(int schemaHash) {
            this.schemaHash = schemaHash;
        }

        public void setPartitionMethod(String partitionMethod) {
            this.partitionMethod = partitionMethod;
        }

        public void setHashMethod(String hashMethod) {
            this.hashMethod = hashMethod;
        }

        public void setHashMod(int hashMod) {
            this.hashMod = hashMod;
        }

        public void setDistributionColumnRefs(List<String> distributionColumnRefs) {
            this.distributionColumnRefs = distributionColumnRefs;
        }

        public void setPidKeyCount(int pidKeyCount) {
            this.pidKeyCount = pidKeyCount;
        }

        public Map<String, Object> toDppView() {
            HashMap index = Maps.newHashMap();
            index.put("keys_type", this.keysType.name());
            index.put("output_format", OUTPUT_FORMAT);
            index.put("index_name", BE_INDEX_NAME);
            index.put("table_name", String.valueOf(this.indexId));
            index.put("table_id", this.indexId);
            index.put("column_refs", this.columnRefs);
            index.put("schema_hash", this.schemaHash);
            index.put("partition_method", this.partitionMethod);
            index.put("hash_method", this.hashMethod);
            index.put("hash_mod", this.hashMod);
            index.put("partition_column_refs", this.distributionColumnRefs);
            index.put("pid_key_count", this.pidKeyCount);
            return index;
        }
    }

    private class EtlColumn {
        private final Column column;

        public EtlColumn(Column column) {
            this.column = column;
        }

        public Map<String, Object> toDppColumn() {
            HashMap dppColumn = Maps.newHashMap();
            PrimitiveType type = this.column.getDataType();
            String columnType = null;
            switch (type) {
                case TINYINT: {
                    columnType = "TINY";
                    break;
                }
                case SMALLINT: {
                    columnType = "SHORT";
                    break;
                }
                case INT: {
                    columnType = "INT";
                    break;
                }
                case BIGINT: {
                    columnType = "LONG";
                    break;
                }
                case LARGEINT: {
                    columnType = "LARGEINT";
                    break;
                }
                case FLOAT: {
                    columnType = "FLOAT";
                    break;
                }
                case DOUBLE: {
                    columnType = "DOUBLE";
                    break;
                }
                case DATE: {
                    columnType = "DATE";
                    break;
                }
                case DATETIME: {
                    columnType = "DATETIME";
                    break;
                }
                case CHAR: {
                    columnType = "STRING";
                    break;
                }
                case VARCHAR: {
                    columnType = "VARCHAR";
                    break;
                }
                case HLL: {
                    columnType = "HLL";
                    break;
                }
                case BITMAP: {
                    columnType = "BITMAP";
                    break;
                }
                case DECIMALV2: {
                    columnType = "DECIMAL";
                    break;
                }
                default: {
                    columnType = type.toString();
                }
            }
            dppColumn.put("column_type", columnType);
            if (this.column.isAllowNull()) {
                dppColumn.put("is_allow_null", this.column.isAllowNull());
            }
            if (this.column.getDefaultValue() != null) {
                dppColumn.put("default_value", this.column.getDefaultValue());
            }
            if (this.column.isAllowNull() && null == this.column.getDefaultValue()) {
                dppColumn.put("default_value", "\\N");
            }
            if (type == PrimitiveType.CHAR || type == PrimitiveType.VARCHAR || type == PrimitiveType.HLL) {
                dppColumn.put("string_length", this.column.getStrLen());
            }
            if (type == PrimitiveType.DECIMALV2) {
                dppColumn.put("precision", this.column.getPrecision());
                dppColumn.put("scale", this.column.getScale());
            }
            return dppColumn;
        }

        public boolean isKey() {
            return this.column.isKey();
        }

        public AggregateType getAggregationType() {
            return this.column.getAggregationType();
        }
    }

    private class EtlSource {
        private final Source source;

        public EtlSource(Source source) {
            this.source = source;
        }

        public Map<String, Object> toDppSource() {
            HashMap dppSource = Maps.newHashMap();
            dppSource.put("file_urls", this.source.getFileUrls());
            dppSource.put("columns", this.source.getColumnNames());
            dppSource.put("column_separator", this.source.getColumnSeparator());
            dppSource.put("is_negative", this.source.isNegative());
            Map<String, Pair<String, List<String>>> columnToFunction = this.source.getColumnToFunction();
            if (columnToFunction != null && !columnToFunction.isEmpty()) {
                HashMap columnMapping = Maps.newHashMap();
                for (Map.Entry<String, Pair<String, List<String>>> entry : columnToFunction.entrySet()) {
                    Pair<String, List<String>> functionPair = entry.getValue();
                    HashMap functionMap = Maps.newHashMap();
                    functionMap.put("function_name", functionPair.first);
                    functionMap.put("args", functionPair.second);
                    columnMapping.put(entry.getKey(), functionMap);
                }
                dppSource.put("column_mappings", columnMapping);
            }
            return dppSource;
        }
    }

    private class EtlPartitionConf {
        private Map<String, EtlSource> sources;
        private Map<String, EtlColumn> columns;
        private Map<String, EtlIndex> indices;
        private EtlPartitionInfo partitionInfo;

        private EtlPartitionConf() {
        }

        public void setSources(Map<String, EtlSource> sources) {
            this.sources = sources;
        }

        public void setColumns(Map<String, EtlColumn> columns) {
            this.columns = columns;
        }

        public void setIndices(Map<String, EtlIndex> indices) {
            this.indices = indices;
        }

        public void setPartitionInfo(EtlPartitionInfo partitionInfo) {
            this.partitionInfo = partitionInfo;
        }

        public Map<String, Object> toDppPartitionConf() {
            HashMap partitionConf = Maps.newHashMap();
            partitionConf.put("source_file_schema", Maps.transformValues(this.sources, (Function)new Function<EtlSource, Map<String, Object>>(){

                public Map<String, Object> apply(EtlSource source) {
                    return source.toDppSource();
                }
            }));
            partitionConf.put("columns", Maps.transformValues(this.columns, (Function)new Function<EtlColumn, Map<String, Object>>(){

                public Map<String, Object> apply(EtlColumn column) {
                    return column.toDppColumn();
                }
            }));
            partitionConf.put("views", Maps.transformValues(this.indices, (Function)new Function<EtlIndex, Map<String, Object>>(){

                public Map<String, Object> apply(EtlIndex index) {
                    return index.toDppView();
                }
            }));
            if (this.partitionInfo != null) {
                partitionConf.put("partition_info", this.partitionInfo.toDppPartitionInfo());
            }
            return partitionConf;
        }
    }

    private class EtlErrorHubInfo {
        LoadErrorHub.Param hubInfo;
        long jobId;
        private static final int MAX_EXPORT_LINE_NUM = 10;
        private static final int MAX_EXPORT_LINE_SIZE = 500;

        public EtlErrorHubInfo(long jobId, LoadErrorHub.Param info) {
            this.jobId = jobId;
            this.hubInfo = info;
        }

        public Map<String, Object> toDppHubInfo() {
            Map<String, Object> dppHubInfo = this.hubInfo.toDppConfigInfo();
            dppHubInfo.put("job_id", this.jobId);
            dppHubInfo.put("max_export_line_num", 10);
            dppHubInfo.put("max_export_line_size", 500);
            return dppHubInfo;
        }
    }

    private class EtlTaskConf {
        private static final String JOB_TYPE = "palo";
        private String outputFilePattern;
        private String outputPath;
        private Map<String, EtlPartitionConf> etlPartitions;
        private EtlErrorHubInfo hubInfo;

        private EtlTaskConf() {
        }

        public void setOutputFilePattern(String outputFilePattern) {
            this.outputFilePattern = outputFilePattern;
        }

        public void setOutputPath(String outputPath) {
            this.outputPath = outputPath;
        }

        public void setEtlPartitions(Map<String, EtlPartitionConf> etlPartitions) {
            this.etlPartitions = etlPartitions;
        }

        public void setHubInfo(EtlErrorHubInfo info) {
            this.hubInfo = info;
        }

        public Map<String, Object> toDppTaskConf() {
            HashMap taskConf = Maps.newHashMap();
            taskConf.put("job_type", JOB_TYPE);
            taskConf.put("output_file_pattern", this.outputFilePattern);
            taskConf.put("output_path", this.outputPath);
            taskConf.put("tables", Maps.transformValues(this.etlPartitions, (Function)new Function<EtlPartitionConf, Map<String, Object>>(){

                public Map<String, Object> apply(EtlPartitionConf partition) {
                    return partition.toDppPartitionConf();
                }
            }));
            if (this.hubInfo != null) {
                taskConf.put("hub_info", this.hubInfo.toDppHubInfo());
            }
            return taskConf;
        }
    }
}

