/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.Pair;
import org.apache.doris.load.DppConfig;
import org.apache.doris.load.DppScheduler;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.LoadJob;
import org.apache.doris.task.LoadEtlTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HadoopLoadEtlTask
extends LoadEtlTask {
    private static final Logger LOG = LogManager.getLogger(HadoopLoadEtlTask.class);
    private static final String MAP_COMPLETION = "map() completion";
    private static final String REDUCE_COMPLETION = "reduce() completion";
    private static final double FILTER_RATIO_DELTA = 0.02;

    public HadoopLoadEtlTask(LoadJob job) {
        super(job);
    }

    @Override
    protected boolean updateJobEtlStatus() {
        DppScheduler dppScheduler = new DppScheduler(this.job.getHadoopDppConfig());
        EtlStatus status = dppScheduler.getEtlJobStatus(this.job.getHadoopEtlJobId());
        LOG.info("job status: {}. job: {}", (Object)status, (Object)this.job.toString());
        this.job.setEtlJobStatus(status);
        return true;
    }

    @Override
    protected void processEtlRunning() throws LoadException {
        double maxFilterRatio;
        Map<String, String> stats = this.job.getEtlJobStatus().getStats();
        boolean isMapCompleted = false;
        if (stats.containsKey(MAP_COMPLETION) && stats.containsKey(REDUCE_COMPLETION)) {
            float reduceProgress;
            float mapProgress = Float.parseFloat(stats.get(MAP_COMPLETION));
            int progress = (int)(100.0f * (mapProgress + (reduceProgress = Float.parseFloat(stats.get(REDUCE_COMPLETION)))) / 2.0f);
            if (progress >= 100) {
                progress = 99;
            }
            this.job.setProgress(progress);
            if (mapProgress >= 1.0f) {
                isMapCompleted = true;
            }
        }
        if (isMapCompleted && !this.checkDataQuality(maxFilterRatio = this.job.getMaxFilterRatio() + 0.02)) {
            throw new LoadException("quality not good enough to cancel");
        }
    }

    @Override
    protected Map<String, Pair<String, Long>> getFilePathMap() throws LoadException {
        DppConfig dppConfig = this.job.getHadoopDppConfig();
        DppScheduler dppScheduler = new DppScheduler(dppConfig);
        long dbId = this.job.getDbId();
        String loadLabel = this.job.getLabel();
        String outputPath = DppScheduler.getEtlOutputPath(dppConfig.getFsDefaultName(), dppConfig.getOutputPath(), dbId, loadLabel, this.job.getHadoopEtlOutputDir());
        Map<String, Long> fileMap = dppScheduler.getEtlFiles(outputPath);
        if (fileMap == null) {
            throw new LoadException("get etl files error");
        }
        HashMap filePathMap = Maps.newHashMap();
        String httpServer = String.format("http://%s:%s", dppConfig.getNameNodeHost(), dppConfig.getHttpPort());
        String ugi = String.format("ugi=%s", dppConfig.getHadoopJobUgiStr());
        for (Map.Entry<String, Long> entry : fileMap.entrySet()) {
            String filePath = entry.getKey();
            String partitionIndexBucket = this.getPartitionIndexBucketString(filePath);
            filePath = String.format("%s/data%s?%s", httpServer, filePath, ugi);
            filePathMap.put(partitionIndexBucket, Pair.create(filePath, entry.getValue()));
        }
        return filePathMap;
    }
}

