/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Status;
import org.apache.doris.load.ExportFailMsg;
import org.apache.doris.load.ExportJob;
import org.apache.doris.system.Backend;
import org.apache.doris.task.AgentClient;
import org.apache.doris.task.MasterTask;
import org.apache.doris.thrift.TAgentResult;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPaloScanRange;
import org.apache.doris.thrift.TScanRange;
import org.apache.doris.thrift.TScanRangeLocation;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TSnapshotRequest;
import org.apache.doris.thrift.TStatusCode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportPendingTask
extends MasterTask {
    private static final Logger LOG = LogManager.getLogger(ExportPendingTask.class);
    protected final ExportJob job;
    protected Database db;

    public ExportPendingTask(ExportJob job) {
        this.job = job;
        this.signature = job.getId();
    }

    @Override
    protected void exec() {
        if (this.job.getState() != ExportJob.JobState.PENDING) {
            return;
        }
        long dbId = this.job.getDbId();
        this.db = Catalog.getCurrentCatalog().getDbNullable(dbId);
        if (this.db == null) {
            this.job.cancel(ExportFailMsg.CancelType.RUN_FAIL, "database does not exist");
            return;
        }
        if (this.job.isReplayed()) {
            String failMsg = "FE restarted or Master changed during exporting. Job must be cancelled.";
            this.job.cancel(ExportFailMsg.CancelType.RUN_FAIL, failMsg);
            return;
        }
        Status snapshotStatus = this.makeSnapshots();
        if (!snapshotStatus.ok()) {
            this.job.cancel(ExportFailMsg.CancelType.RUN_FAIL, snapshotStatus.getErrorMsg());
            return;
        }
        if (this.job.updateState(ExportJob.JobState.EXPORTING)) {
            LOG.info("submit pending export job success. job: {}", (Object)this.job);
            return;
        }
    }

    private Status makeSnapshots() {
        List<TScanRangeLocations> tabletLocations = this.job.getTabletLocations();
        if (tabletLocations == null) {
            return Status.OK;
        }
        for (TScanRangeLocations tablet : tabletLocations) {
            TScanRange scanRange = tablet.getScanRange();
            if (!scanRange.isSetPaloScanRange()) continue;
            TPaloScanRange paloScanRange = scanRange.getPaloScanRange();
            List locations = tablet.getLocations();
            for (TScanRangeLocation location : locations) {
                TNetworkAddress address = location.getServer();
                String host = address.getHostname();
                int port = address.getPort();
                Backend backend = Catalog.getCurrentSystemInfo().getBackendWithBePort(host, port);
                if (backend == null) {
                    return Status.CANCELLED;
                }
                long backendId = backend.getId();
                if (!Catalog.getCurrentSystemInfo().checkBackendQueryAvailable(backendId)) {
                    return Status.CANCELLED;
                }
                TSnapshotRequest snapshotRequest = new TSnapshotRequest();
                snapshotRequest.setTabletId(paloScanRange.getTabletId());
                snapshotRequest.setSchemaHash(Integer.parseInt(paloScanRange.getSchemaHash()));
                snapshotRequest.setVersion(Long.parseLong(paloScanRange.getVersion()));
                snapshotRequest.setTimeout((long)this.job.getTimeoutSecond());
                snapshotRequest.setPreferredSnapshotVersion(4);
                AgentClient client = new AgentClient(host, port);
                TAgentResult result = client.makeSnapshot(snapshotRequest);
                if (result == null || result.getStatus().getStatusCode() != TStatusCode.OK) {
                    String err = "snapshot for tablet " + paloScanRange.getTabletId() + " failed on backend " + address.toString() + ". reason: " + (result == null ? "unknown" : result.getStatus().error_msgs);
                    LOG.warn("{}, export job: {}", (Object)err, (Object)this.job.getId());
                    return new Status(TStatusCode.CANCELLED, err);
                }
                this.job.addSnapshotPath(new Pair<TNetworkAddress, String>(address, result.getSnapshotPath()));
            }
        }
        return Status.OK;
    }
}

