/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Status;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.ProfileManager;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.ExportFailMsg;
import org.apache.doris.load.ExportJob;
import org.apache.doris.qe.Coordinator;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.task.MasterTask;
import org.apache.doris.thrift.TBrokerOperationStatus;
import org.apache.doris.thrift.TBrokerOperationStatusCode;
import org.apache.doris.thrift.TBrokerRenamePathRequest;
import org.apache.doris.thrift.TBrokerVersion;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPaloBrokerService;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class ExportExportingTask
extends MasterTask {
    private static final Logger LOG = LogManager.getLogger(ExportExportingTask.class);
    private static final int RETRY_NUM = 2;
    protected final ExportJob job;
    private boolean isCancelled = false;
    private Status failStatus = Status.OK;
    private ExportFailMsg.CancelType cancelType = ExportFailMsg.CancelType.UNKNOWN;
    private RuntimeProfile profile = new RuntimeProfile("Export");
    private List<RuntimeProfile> fragmentProfiles = Lists.newArrayList();

    public ExportExportingTask(ExportJob job) {
        this.job = job;
        this.signature = job.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exec() {
        Status mvStatus;
        if (this.job.getState() != ExportJob.JobState.EXPORTING) {
            return;
        }
        LOG.info("begin execute export job in exporting state. job: {}", (Object)this.job);
        ExportJob exportJob = this.job;
        synchronized (exportJob) {
            if (this.job.getDoExportingThread() != null) {
                LOG.warn("export task is already being executed.");
                return;
            }
            this.job.setDoExportingThread(Thread.currentThread());
        }
        if (this.job.isReplayed()) {
            String failMsg = "FE restarted or Master changed during exporting. Job must be cancelled.";
            this.job.cancel(ExportFailMsg.CancelType.RUN_FAIL, failMsg);
            return;
        }
        List<Coordinator> coords = this.job.getCoordList();
        int coordSize = coords.size();
        for (int i = 0; i < coordSize && !this.isCancelled; ++i) {
            Coordinator coord = coords.get(i);
            for (int j = 0; j < 2; ++j) {
                this.execOneCoord(coord);
                if (coord.getExecStatus().ok()) break;
                if (j >= 1) continue;
                TUniqueId queryId = coord.getQueryId();
                coord.clearExportStatus();
                UUID uuid = UUID.randomUUID();
                TUniqueId newQueryId = new TUniqueId(queryId.hi, uuid.getLeastSignificantBits());
                coord.setQueryId(newQueryId);
                LOG.warn("export exporting job fail. err: {}. query_id: {}, job: {}. retry. {}, new query id: {}", (Object)coord.getExecStatus().getErrorMsg(), (Object)DebugUtil.printId(queryId), (Object)this.job.getId(), (Object)j, (Object)DebugUtil.printId(newQueryId));
            }
            if (!coord.getExecStatus().ok()) {
                this.onFailed(coord);
            } else {
                int progress = (i + 1) * 100 / coordSize;
                if (progress >= 100) {
                    progress = 99;
                }
                this.job.setProgress(progress);
                LOG.info("finish coordinator with query id {}, export job: {}. progress: {}", (Object)DebugUtil.printId(coord.getQueryId()), (Object)this.job.getId(), (Object)progress);
            }
            RuntimeProfile queryProfile = coord.getQueryProfile();
            if (queryProfile != null) {
                queryProfile.getCounterTotalTime().setValue(TimeUtils.getEstimatedTime(this.job.getStartTimeMs()));
            }
            coord.endProfile();
            this.fragmentProfiles.add(coord.getQueryProfile());
        }
        if (this.isCancelled) {
            this.job.cancel(this.cancelType, null);
            this.registerProfile();
            return;
        }
        if (this.job.getBrokerDesc().getStorageType() == StorageBackend.StorageType.BROKER && !(mvStatus = this.moveTmpFiles()).ok()) {
            String failMsg = "move tmp file to final destination fail.";
            failMsg = failMsg + mvStatus.getErrorMsg();
            this.job.cancel(ExportFailMsg.CancelType.RUN_FAIL, failMsg);
            LOG.warn("move tmp file to final destination fail. job:{}", (Object)this.job);
            this.registerProfile();
            return;
        }
        Status releaseSnapshotStatus = this.job.releaseSnapshotPaths();
        if (!releaseSnapshotStatus.ok()) {
            LOG.warn("failed to release snapshot for export job: {}. err: {}", (Object)this.job.getId(), (Object)releaseSnapshotStatus.getErrorMsg());
        }
        if (this.job.updateState(ExportJob.JobState.FINISHED)) {
            LOG.warn("export job success. job: {}", (Object)this.job);
            this.registerProfile();
        }
        ExportExportingTask exportExportingTask = this;
        synchronized (exportExportingTask) {
            this.job.setDoExportingThread(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status execOneCoord(Coordinator coord) {
        TUniqueId queryId = coord.getQueryId();
        boolean needUnregister = false;
        try {
            QeProcessorImpl.INSTANCE.registerQuery(queryId, coord);
            needUnregister = true;
            this.actualExecCoord(queryId, coord);
        }
        catch (UserException e) {
            LOG.warn("export exporting internal error, job: {}", (Object)this.job.getId(), (Object)e);
            Status status = new Status(TStatusCode.INTERNAL_ERROR, e.getMessage());
            return status;
        }
        finally {
            if (needUnregister) {
                QeProcessorImpl.INSTANCE.unregisterQuery(queryId);
            }
        }
        return Status.OK;
    }

    private void actualExecCoord(TUniqueId queryId, Coordinator coord) {
        int leftTimeSecond = this.getLeftTimeSecond();
        if (leftTimeSecond <= 0) {
            this.onTimeout();
            return;
        }
        try {
            coord.setTimeout(leftTimeSecond);
            coord.exec();
        }
        catch (Exception e) {
            LOG.warn("export Coordinator execute failed. job: {}", (Object)this.job.getId(), (Object)e);
        }
        if (coord.join(leftTimeSecond)) {
            Status status = coord.getExecStatus();
            if (status.ok()) {
                this.onSubTaskFinished(coord.getExportFiles());
            }
        } else {
            coord.cancel();
        }
    }

    private int getLeftTimeSecond() {
        return (int)((long)this.job.getTimeoutSecond() - (System.currentTimeMillis() - this.job.getCreateTimeMs()) / 1000L);
    }

    private synchronized void onSubTaskFinished(List<String> exportFiles) {
        this.job.addExportedFiles(exportFiles);
    }

    private synchronized void onFailed(Coordinator coordinator) {
        this.isCancelled = true;
        this.failStatus = coordinator.getExecStatus();
        this.cancelType = ExportFailMsg.CancelType.RUN_FAIL;
        String failMsg = "export exporting job fail. query id: " + DebugUtil.printId(coordinator.getQueryId()) + ", ";
        failMsg = failMsg + this.failStatus.getErrorMsg();
        this.job.setFailMsg(new ExportFailMsg(this.cancelType, failMsg));
        LOG.warn("export exporting job fail. err: {}. job: {}", (Object)failMsg, (Object)this.job);
    }

    public synchronized void onTimeout() {
        this.isCancelled = true;
        this.failStatus = new Status(TStatusCode.TIMEOUT, "timeout");
        this.cancelType = ExportFailMsg.CancelType.TIMEOUT;
        String failMsg = "export exporting job timeout.";
        this.job.setFailMsg(new ExportFailMsg(this.cancelType, failMsg));
        LOG.warn("export exporting job timeout. job: {}", (Object)this.job);
    }

    private void initProfile() {
        this.profile = new RuntimeProfile("ExportJob");
        RuntimeProfile summaryProfile = new RuntimeProfile("Summary");
        summaryProfile.addInfoString("Query ID", String.valueOf(this.job.getId()));
        summaryProfile.addInfoString("Start Time", TimeUtils.longToTimeString(this.job.getStartTimeMs()));
        long currentTimestamp = System.currentTimeMillis();
        long totalTimeMs = currentTimestamp - this.job.getStartTimeMs();
        summaryProfile.addInfoString("End Time", TimeUtils.longToTimeString(currentTimestamp));
        summaryProfile.addInfoString("Total", DebugUtil.getPrettyStringMs(totalTimeMs));
        summaryProfile.addInfoString("Query Type", "Export");
        summaryProfile.addInfoString("Query State", this.job.getState().toString());
        summaryProfile.addInfoString("Doris Version", "1.1.0-rc05");
        summaryProfile.addInfoString("User", "xxx");
        summaryProfile.addInfoString("Default Db", String.valueOf(this.job.getDbId()));
        summaryProfile.addInfoString("Sql Statement", this.job.getSql());
        this.profile.addChild(summaryProfile);
    }

    private void registerProfile() {
        this.initProfile();
        for (RuntimeProfile p : this.fragmentProfiles) {
            this.profile.addChild(p);
        }
        ProfileManager.getInstance().pushProfile(this.profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status moveTmpFiles() {
        FsBroker broker = null;
        try {
            String localIP = FrontendOptions.getLocalHostAddress();
            broker = Catalog.getCurrentCatalog().getBrokerMgr().getBroker(this.job.getBrokerDesc().getName(), localIP);
        }
        catch (AnalysisException e) {
            String failMsg = "get broker failed. export job: " + this.job.getId() + ". msg: " + e.getMessage();
            LOG.warn(failMsg);
            return new Status(TStatusCode.CANCELLED, failMsg);
        }
        TNetworkAddress address = new TNetworkAddress(broker.ip, broker.port);
        TPaloBrokerService.Client client = null;
        try {
            client = ClientPool.brokerPool.borrowObject(address);
        }
        catch (Exception e) {
            try {
                client = ClientPool.brokerPool.borrowObject(address);
            }
            catch (Exception e1) {
                String failMsg = "create connection to broker(" + address + ") failed";
                LOG.warn(failMsg);
                return new Status(TStatusCode.CANCELLED, failMsg);
            }
        }
        boolean failed = false;
        Set<String> exportedFiles = this.job.getExportedFiles();
        ArrayList newFiles = Lists.newArrayList();
        String exportPath = this.job.getExportPath();
        for (String exportedFile : exportedFiles) {
            String file = exportedFile.substring(exportedFile.lastIndexOf("/") + 1);
            String destPath = exportPath + "/" + file;
            LOG.debug("rename {} to {}, export job: {}", (Object)exportedFile, (Object)destPath, (Object)this.job.getId());
            String failMsg = "";
            try {
                TBrokerRenamePathRequest request = new TBrokerRenamePathRequest(TBrokerVersion.VERSION_ONE, exportedFile, destPath, this.job.getBrokerDesc().getProperties());
                TBrokerOperationStatus tBrokerOperationStatus = null;
                tBrokerOperationStatus = client.renamePath(request);
                if (tBrokerOperationStatus.getStatusCode() != TBrokerOperationStatusCode.OK) {
                    failed = true;
                    failMsg = "Broker renamePath failed. srcPath=" + exportedFile + ", destPath=" + destPath + ", broker=" + address + ", msg=" + tBrokerOperationStatus.getMessage();
                    Status status = new Status(TStatusCode.CANCELLED, failMsg);
                    return status;
                }
                newFiles.add(destPath);
            }
            catch (TException e) {
                failed = true;
                failMsg = "Broker renamePath failed. srcPath=" + exportedFile + ", destPath=" + destPath + ", broker=" + address + ", msg=" + e.getMessage();
                Status status = new Status(TStatusCode.CANCELLED, failMsg);
                return status;
            }
            finally {
                if (!failed) continue;
                ClientPool.brokerPool.invalidateObject(address, client);
            }
        }
        if (!failed) {
            exportedFiles.clear();
            this.job.addExportedFiles(newFiles);
            ClientPool.brokerPool.returnObject(address, client);
        }
        return Status.OK;
    }
}

