/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.Map;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TDownloadReq;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TTaskType;

public class DownloadTask
extends AgentTask {
    private long jobId;
    private Map<String, String> srcToDestPath;
    private FsBroker brokerAddr;
    private Map<String, String> brokerProperties;
    private StorageBackend.StorageType storageType;

    public DownloadTask(TResourceInfo resourceInfo, long backendId, long signature, long jobId, long dbId, Map<String, String> srcToDestPath, FsBroker brokerAddr, Map<String, String> brokerProperties, StorageBackend.StorageType storageType) {
        super(resourceInfo, backendId, TTaskType.DOWNLOAD, dbId, -1L, -1L, -1L, -1L, signature);
        this.jobId = jobId;
        this.srcToDestPath = srcToDestPath;
        this.brokerAddr = brokerAddr;
        this.brokerProperties = brokerProperties;
        this.storageType = storageType;
    }

    public long getJobId() {
        return this.jobId;
    }

    public Map<String, String> getSrcToDestPath() {
        return this.srcToDestPath;
    }

    public FsBroker getBrokerAddr() {
        return this.brokerAddr;
    }

    public Map<String, String> getBrokerProperties() {
        return this.brokerProperties;
    }

    public TDownloadReq toThrift() {
        TNetworkAddress address = new TNetworkAddress(this.brokerAddr.ip, this.brokerAddr.port);
        TDownloadReq req = new TDownloadReq(this.jobId, this.srcToDestPath, address);
        req.setBrokerProp(this.brokerProperties);
        req.setStorageBackend(this.storageType.toThrift());
        return req;
    }
}

