/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TMoveDirReq;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TTaskType;

public class DirMoveTask
extends AgentTask {
    private long jobId;
    private String src;
    private int schemaHash;
    private boolean overwrite;

    public DirMoveTask(TResourceInfo resourceInfo, long backendId, long signature, long jobId, long dbId, long tableId, long partitionId, long indexId, long tabletId, String src, int schemaHash, boolean overwrite) {
        super(resourceInfo, backendId, TTaskType.MOVE, dbId, tableId, partitionId, indexId, tabletId, signature);
        this.jobId = jobId;
        this.src = src;
        this.schemaHash = schemaHash;
        this.overwrite = overwrite;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getSrc() {
        return this.src;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public TMoveDirReq toThrift() {
        TMoveDirReq req = new TMoveDirReq(this.tabletId, this.schemaHash, this.src, this.jobId, this.overwrite);
        return req;
    }
}

