/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.DataSortInfo;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Index;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.common.MarkedCountDownLatch;
import org.apache.doris.common.Status;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TColumn;
import org.apache.doris.thrift.TCompressionType;
import org.apache.doris.thrift.TCreateTabletReq;
import org.apache.doris.thrift.TOlapTableIndex;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TStorageFormat;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TStorageType;
import org.apache.doris.thrift.TTabletSchema;
import org.apache.doris.thrift.TTabletType;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateReplicaTask
extends AgentTask {
    private static final Logger LOG = LogManager.getLogger(CreateReplicaTask.class);
    private short shortKeyColumnCount;
    private int schemaHash;
    private long version;
    private KeysType keysType;
    private TStorageType storageType;
    private TStorageMedium storageMedium;
    private TCompressionType compressionType;
    private List<Column> columns;
    private Set<String> bfColumns;
    private double bfFpp;
    private List<Index> indexes;
    private boolean isInMemory;
    private TTabletType tabletType;
    private MarkedCountDownLatch<Long, Long> latch;
    private boolean inRestoreMode = false;
    private long baseTabletId = -1L;
    private int baseSchemaHash = -1;
    private TStorageFormat storageFormat = TStorageFormat.V2;
    private boolean isRecoverTask = false;
    private DataSortInfo dataSortInfo;

    public CreateReplicaTask(long backendId, long dbId, long tableId, long partitionId, long indexId, long tabletId, short shortKeyColumnCount, int schemaHash, long version, KeysType keysType, TStorageType storageType, TStorageMedium storageMedium, List<Column> columns, Set<String> bfColumns, double bfFpp, MarkedCountDownLatch<Long, Long> latch, List<Index> indexes, boolean isInMemory, TTabletType tabletType, TCompressionType compressionType) {
        super(null, backendId, TTaskType.CREATE, dbId, tableId, partitionId, indexId, tabletId);
        this.shortKeyColumnCount = shortKeyColumnCount;
        this.schemaHash = schemaHash;
        this.version = version;
        this.keysType = keysType;
        this.storageType = storageType;
        this.storageMedium = storageMedium;
        this.compressionType = compressionType;
        this.columns = columns;
        this.bfColumns = bfColumns;
        this.indexes = indexes;
        this.bfFpp = bfFpp;
        this.latch = latch;
        this.isInMemory = isInMemory;
        this.tabletType = tabletType;
    }

    public CreateReplicaTask(long backendId, long dbId, long tableId, long partitionId, long indexId, long tabletId, short shortKeyColumnCount, int schemaHash, long version, KeysType keysType, TStorageType storageType, TStorageMedium storageMedium, List<Column> columns, Set<String> bfColumns, double bfFpp, MarkedCountDownLatch<Long, Long> latch, List<Index> indexes, boolean isInMemory, TTabletType tabletType, DataSortInfo dataSortInfo, TCompressionType compressionType) {
        super(null, backendId, TTaskType.CREATE, dbId, tableId, partitionId, indexId, tabletId);
        this.shortKeyColumnCount = shortKeyColumnCount;
        this.schemaHash = schemaHash;
        this.version = version;
        this.keysType = keysType;
        this.storageType = storageType;
        this.storageMedium = storageMedium;
        this.compressionType = compressionType;
        this.columns = columns;
        this.bfColumns = bfColumns;
        this.indexes = indexes;
        this.bfFpp = bfFpp;
        this.latch = latch;
        this.isInMemory = isInMemory;
        this.tabletType = tabletType;
        this.dataSortInfo = dataSortInfo;
    }

    public void setIsRecoverTask(boolean isRecoverTask) {
        this.isRecoverTask = isRecoverTask;
    }

    public boolean isRecoverTask() {
        return this.isRecoverTask;
    }

    public void countDownLatch(long backendId, long tabletId) {
        if (this.latch != null && this.latch.markedCountDown(backendId, tabletId)) {
            LOG.debug("CreateReplicaTask current latch count: {}, backend: {}, tablet:{}", (Object)this.latch.getCount(), (Object)backendId, (Object)tabletId);
        }
    }

    public void countDownToZero(String errMsg) {
        if (this.latch != null) {
            this.latch.countDownToZero(new Status(TStatusCode.CANCELLED, errMsg));
            LOG.debug("CreateReplicaTask download to zero. error msg: {}", (Object)errMsg);
        }
    }

    public void setLatch(MarkedCountDownLatch<Long, Long> latch) {
        this.latch = latch;
    }

    public void setInRestoreMode(boolean inRestoreMode) {
        this.inRestoreMode = inRestoreMode;
    }

    public void setBaseTablet(long baseTabletId, int baseSchemaHash) {
        this.baseTabletId = baseTabletId;
        this.baseSchemaHash = baseSchemaHash;
    }

    public void setStorageFormat(TStorageFormat storageFormat) {
        this.storageFormat = storageFormat;
    }

    public TCreateTabletReq toThrift() {
        TCreateTabletReq createTabletReq = new TCreateTabletReq();
        createTabletReq.setTabletId(this.tabletId);
        TTabletSchema tSchema = new TTabletSchema();
        tSchema.setShortKeyColumnCount(this.shortKeyColumnCount);
        tSchema.setSchemaHash(this.schemaHash);
        tSchema.setKeysType(this.keysType.toThrift());
        tSchema.setStorageType(this.storageType);
        if (this.dataSortInfo != null) {
            tSchema.setSortType(this.dataSortInfo.getSortType());
            tSchema.setSortColNum(this.dataSortInfo.getColNum());
        }
        int deleteSign = -1;
        int sequenceCol = -1;
        ArrayList<TColumn> tColumns = new ArrayList<TColumn>();
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            TColumn tColumn = column.toThrift();
            if (this.bfColumns != null && this.bfColumns.contains(column.getName())) {
                tColumn.setIsBloomFilterColumn(true);
            }
            if (column.getName().startsWith("__doris_shadow_")) {
                tColumn.setColumnName(column.getName().substring("__doris_shadow_".length()));
            }
            tColumn.setVisible(column.isVisible());
            tColumns.add(tColumn);
            if (column.isDeleteSignColumn()) {
                deleteSign = i;
            }
            if (!column.isSequenceColumn()) continue;
            sequenceCol = i;
        }
        tSchema.setColumns(tColumns);
        tSchema.setDeleteSignIdx(deleteSign);
        tSchema.setSequenceColIdx(sequenceCol);
        if (CollectionUtils.isNotEmpty(this.indexes)) {
            ArrayList<TOlapTableIndex> tIndexes = new ArrayList<TOlapTableIndex>();
            for (Index index : this.indexes) {
                tIndexes.add(index.toThrift());
            }
            tSchema.setIndexes(tIndexes);
            this.storageFormat = TStorageFormat.V2;
        }
        if (this.bfColumns != null) {
            tSchema.setBloomFilterFpp(this.bfFpp);
        }
        tSchema.setIsInMemory(this.isInMemory);
        createTabletReq.setTabletSchema(tSchema);
        createTabletReq.setVersion(this.version);
        createTabletReq.setStorageMedium(this.storageMedium);
        if (this.inRestoreMode) {
            createTabletReq.setInRestoreMode(true);
        }
        createTabletReq.setTableId(this.tableId);
        createTabletReq.setPartitionId(this.partitionId);
        if (this.baseTabletId != -1L) {
            createTabletReq.setBaseTabletId(this.baseTabletId);
            createTabletReq.setBaseSchemaHash(this.baseSchemaHash);
        }
        if (this.storageFormat != null) {
            createTabletReq.setStorageFormat(this.storageFormat);
        }
        createTabletReq.setTabletType(this.tabletType);
        createTabletReq.setCompressionType(this.compressionType);
        return createTabletReq;
    }
}

