/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TCompactionReq;
import org.apache.doris.thrift.TTaskType;

public class CompactionTask
extends AgentTask {
    private int schemaHash;
    private String type;

    public CompactionTask(long backendId, long dbId, long tableId, long partitionId, long indexId, long tabletId, int schemaHash, String type) {
        super(null, backendId, TTaskType.COMPACTION, dbId, tableId, partitionId, indexId, tabletId);
        this.schemaHash = schemaHash;
        this.type = type;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public TCompactionReq toThrift() {
        TCompactionReq request = new TCompactionReq();
        request.setTabletId(this.tabletId);
        request.setSchemaHash(this.schemaHash);
        request.setType(this.type);
        return request;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tablet id: ").append(this.tabletId).append(", schema hash: ").append(this.schemaHash);
        sb.append(", backend: ").append(this.backendId).append(", type: ").append(this.type);
        return sb.toString();
    }
}

