/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import java.util.List;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TBackend;
import org.apache.doris.thrift.TCloneReq;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.doris.thrift.TTaskType;

public class CloneTask
extends AgentTask {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    private int schemaHash;
    private List<TBackend> srcBackends;
    private TStorageMedium storageMedium;
    private long visibleVersion;
    private long srcPathHash = -1L;
    private long destPathHash = -1L;
    private int timeoutS;
    private int taskVersion = 1;

    public CloneTask(long backendId, long dbId, long tableId, long partitionId, long indexId, long tabletId, int schemaHash, List<TBackend> srcBackends, TStorageMedium storageMedium, long visibleVersion, int timeoutS) {
        super(null, backendId, TTaskType.CLONE, dbId, tableId, partitionId, indexId, tabletId);
        this.schemaHash = schemaHash;
        this.srcBackends = srcBackends;
        this.storageMedium = storageMedium;
        this.visibleVersion = visibleVersion;
        this.timeoutS = timeoutS;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public TStorageMedium getStorageMedium() {
        return this.storageMedium;
    }

    public long getVisibleVersion() {
        return this.visibleVersion;
    }

    public void setPathHash(long srcPathHash, long destPathHash) {
        this.srcPathHash = srcPathHash;
        this.destPathHash = destPathHash;
        this.taskVersion = 2;
    }

    public int getTaskVersion() {
        return this.taskVersion;
    }

    public TCloneReq toThrift() {
        TCloneReq request = new TCloneReq(this.tabletId, this.schemaHash, this.srcBackends);
        request.setStorageMedium(this.storageMedium);
        request.setCommittedVersion(this.visibleVersion);
        request.setTaskVersion(this.taskVersion);
        if (this.taskVersion == 2) {
            request.setSrcPathHash(this.srcPathHash);
            request.setDestPathHash(this.destPathHash);
        }
        request.setTimeoutS(this.timeoutS);
        return request;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tablet id: ").append(this.tabletId).append(", schema hash: ").append(this.schemaHash);
        sb.append(", storageMedium: ").append(this.storageMedium.name());
        sb.append(", visible version(hash): ").append(this.visibleVersion);
        sb.append(", src backend: ").append(this.srcBackends.get(0).getHost()).append(", src path hash: ").append(this.srcPathHash);
        sb.append(", dest backend: ").append(this.backendId).append(", dest path hash: ").append(this.destPathHash);
        return sb.toString();
    }
}

