/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.task.AgentTask;
import org.apache.doris.thrift.TAlterMaterializedViewParam;
import org.apache.doris.thrift.TAlterTabletReqV2;
import org.apache.doris.thrift.TTaskType;

public class AlterReplicaTask
extends AgentTask {
    private long baseTabletId;
    private long newReplicaId;
    private int baseSchemaHash;
    private int newSchemaHash;
    private long version;
    private long jobId;
    private AlterJobV2.JobType jobType;
    private Map<String, Expr> defineExprs;

    public AlterReplicaTask(long backendId, long dbId, long tableId, long partitionId, long rollupIndexId, long baseIndexId, long rollupTabletId, long baseTabletId, long newReplicaId, int newSchemaHash, int baseSchemaHash, long version, long jobId, AlterJobV2.JobType jobType) {
        this(backendId, dbId, tableId, partitionId, rollupIndexId, baseIndexId, rollupTabletId, baseTabletId, newReplicaId, newSchemaHash, baseSchemaHash, version, jobId, jobType, null);
    }

    public AlterReplicaTask(long backendId, long dbId, long tableId, long partitionId, long rollupIndexId, long baseIndexId, long rollupTabletId, long baseTabletId, long newReplicaId, int newSchemaHash, int baseSchemaHash, long version, long jobId, AlterJobV2.JobType jobType, Map<String, Expr> defineExprs) {
        super(null, backendId, TTaskType.ALTER, dbId, tableId, partitionId, rollupIndexId, rollupTabletId);
        this.baseTabletId = baseTabletId;
        this.newReplicaId = newReplicaId;
        this.newSchemaHash = newSchemaHash;
        this.baseSchemaHash = baseSchemaHash;
        this.version = version;
        this.jobId = jobId;
        this.jobType = jobType;
        this.defineExprs = defineExprs;
    }

    public long getBaseTabletId() {
        return this.baseTabletId;
    }

    public long getNewReplicaId() {
        return this.newReplicaId;
    }

    public int getNewSchemaHash() {
        return this.newSchemaHash;
    }

    public int getBaseSchemaHash() {
        return this.baseSchemaHash;
    }

    public long getVersion() {
        return this.version;
    }

    public long getJobId() {
        return this.jobId;
    }

    public AlterJobV2.JobType getJobType() {
        return this.jobType;
    }

    public TAlterTabletReqV2 toThrift() {
        TAlterTabletReqV2 req = new TAlterTabletReqV2(this.baseTabletId, this.signature, this.baseSchemaHash, this.newSchemaHash);
        req.setAlterVersion(this.version);
        if (this.defineExprs != null) {
            for (Map.Entry<String, Expr> entry : this.defineExprs.entrySet()) {
                ArrayList slots = Lists.newArrayList();
                entry.getValue().collect(SlotRef.class, slots);
                TAlterMaterializedViewParam mvParam = new TAlterMaterializedViewParam(entry.getKey());
                mvParam.setOriginColumnName(((SlotRef)slots.get(0)).getColumnName());
                mvParam.setMvExpr(entry.getValue().treeToThrift());
                req.addToMaterializedViewParams(mvParam);
            }
        }
        return req;
    }
}

