/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.task.AgentBatchTask;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.PushTask;
import org.apache.doris.thrift.TPushType;
import org.apache.doris.thrift.TTaskType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentTaskQueue {
    private static final Logger LOG = LogManager.getLogger(AgentTaskQueue.class);
    private static Table<Long, TTaskType, Map<Long, AgentTask>> tasks = HashBasedTable.create();
    private static int taskNum = 0;

    public static synchronized void addBatchTask(AgentBatchTask batchTask) {
        for (AgentTask task : batchTask.getAllTasks()) {
            AgentTaskQueue.addTask(task);
        }
    }

    public static synchronized boolean addTask(AgentTask task) {
        long signature;
        long backendId = task.getBackendId();
        TTaskType type = task.getTaskType();
        Map signatureMap = (Map)tasks.get((Object)backendId, (Object)type);
        if (signatureMap == null) {
            signatureMap = Maps.newHashMap();
            tasks.put((Object)backendId, (Object)type, (Object)signatureMap);
        }
        if (signatureMap.containsKey(signature = task.getSignature())) {
            return false;
        }
        signatureMap.put(signature, task);
        ++taskNum;
        LOG.debug("add task: type[{}], backend[{}], signature[{}]", (Object)type, (Object)backendId, (Object)signature);
        if (type == TTaskType.PUSH) {
            PushTask pushTask = (PushTask)task;
            LOG.debug("push task info: version[{}]", (Object)pushTask.getVersion());
        }
        return true;
    }

    public static synchronized void removeBatchTask(AgentBatchTask batchTask, TTaskType type) {
        for (AgentTask task : batchTask.getAllTasks()) {
            AgentTaskQueue.removeTask(task.getBackendId(), type, task.getSignature());
        }
    }

    public static synchronized void removeTask(long backendId, TTaskType type, long signature) {
        if (!tasks.contains((Object)backendId, (Object)type)) {
            return;
        }
        Map signatureMap = (Map)tasks.get((Object)backendId, (Object)type);
        if (!signatureMap.containsKey(signature)) {
            return;
        }
        signatureMap.remove(signature);
        LOG.debug("remove task: type[{}], backend[{}], signature[{}]", (Object)type, (Object)backendId, (Object)signature);
        --taskNum;
    }

    public static synchronized void removePushTask(long backendId, long signature, long version, TPushType pushType, TTaskType taskType) {
        if (!tasks.contains((Object)backendId, (Object)taskType)) {
            return;
        }
        Map signatureMap = (Map)tasks.get((Object)backendId, (Object)taskType);
        AgentTask task = (AgentTask)signatureMap.get(signature);
        if (task == null) {
            return;
        }
        PushTask pushTask = (PushTask)task;
        if (pushTask.getVersion() != version || pushTask.getPushType() != pushType) {
            return;
        }
        signatureMap.remove(signature);
        LOG.debug("remove task: type[{}], backend[{}], signature[{}]", (Object)taskType, (Object)backendId, (Object)signature);
        --taskNum;
    }

    public static synchronized void removeTaskOfType(TTaskType type, long signature) {
        Map map = tasks.column((Object)type);
        for (Map innerMap : map.values()) {
            innerMap.remove(signature);
        }
    }

    public static synchronized AgentTask getTask(long backendId, TTaskType type, long signature) {
        if (!tasks.contains((Object)backendId, (Object)type)) {
            return null;
        }
        Map signatureMap = (Map)tasks.get((Object)backendId, (Object)type);
        return (AgentTask)signatureMap.get(signature);
    }

    public static synchronized List<AgentTask> getTask(TTaskType type) {
        ArrayList res = Lists.newArrayList();
        for (Map agentTasks : tasks.column((Object)TTaskType.ALTER).values()) {
            res.addAll(agentTasks.values());
        }
        return res;
    }

    public static synchronized List<AgentTask> getTask(long dbId, TTaskType type) {
        Map taskMap = tasks.column((Object)type);
        Map signatureMap = taskMap == null ? null : (Map)taskMap.get(dbId);
        return signatureMap == null ? new ArrayList<AgentTask>() : new ArrayList(signatureMap.values());
    }

    public static synchronized List<AgentTask> getDiffTasks(long backendId, Map<TTaskType, Set<Long>> runningTasks) {
        ArrayList<AgentTask> diffTasks = new ArrayList<AgentTask>();
        if (!tasks.containsRow((Object)backendId)) {
            return diffTasks;
        }
        Map backendAllTasks = tasks.row((Object)backendId);
        for (Map.Entry entry : backendAllTasks.entrySet()) {
            TTaskType taskType = (TTaskType)entry.getKey();
            Map tasks = (Map)entry.getValue();
            Set<Object> excludeSignatures = new HashSet();
            if (runningTasks.containsKey(taskType)) {
                excludeSignatures = runningTasks.get(taskType);
            }
            for (Map.Entry taskEntry : tasks.entrySet()) {
                long signature = (Long)taskEntry.getKey();
                AgentTask task = (AgentTask)taskEntry.getValue();
                if (excludeSignatures.contains(signature)) continue;
                diffTasks.add(task);
            }
        }
        return diffTasks;
    }

    public static synchronized void removeReplicaRelatedTasks(long backendId, long tabletId) {
        if (!tasks.containsRow((Object)backendId)) {
            return;
        }
        Map backendTasks = tasks.row((Object)backendId);
        for (TTaskType type : TTaskType.values()) {
            if (!backendTasks.containsKey(type)) continue;
            Map typeTasks = (Map)backendTasks.get(type);
            if (type == TTaskType.REALTIME_PUSH) {
                Iterator taskIterator = typeTasks.values().iterator();
                while (taskIterator.hasNext()) {
                    PushTask realTimePushTask = (PushTask)taskIterator.next();
                    if (tabletId != realTimePushTask.getTabletId()) continue;
                    taskIterator.remove();
                }
                continue;
            }
            if (!typeTasks.containsKey(tabletId)) continue;
            typeTasks.remove(tabletId);
            LOG.debug("remove task: type[{}], backend[{}], signature[{}]", (Object)type, (Object)backendId, (Object)tabletId);
            --taskNum;
        }
    }

    public static synchronized void clearAllTasks() {
        tasks.clear();
        taskNum = 0;
    }

    public static synchronized int getTaskNum() {
        return taskNum;
    }

    public static synchronized int getTaskNum(long backendId, TTaskType type, boolean isFailed) {
        int taskNum = 0;
        if (backendId != -1L) {
            Map taskMap = (Map)tasks.get((Object)backendId, (Object)type);
            if (taskMap != null) {
                if (isFailed) {
                    for (AgentTask task : taskMap.values()) {
                        if (task.getFailedTimes() <= 0) continue;
                        ++taskNum;
                    }
                } else {
                    taskNum += taskMap.size();
                }
            }
        } else {
            Map taskMap = tasks.column((Object)type);
            if (taskMap != null) {
                for (Map signatureMap : taskMap.values()) {
                    if (isFailed) {
                        for (AgentTask task : signatureMap.values()) {
                            if (task.getFailedTimes() <= 0) continue;
                            ++taskNum;
                        }
                        continue;
                    }
                    taskNum += signatureMap.size();
                }
            }
        }
        LOG.info("get task num with type[{}] in backend[{}]: {}. isFailed: {}", (Object)type.name(), (Object)backendId, (Object)taskNum, (Object)isFailed);
        return taskNum;
    }

    public static synchronized List<AgentTask> getFailedTask(long backendId, TTaskType type) {
        Map taskMap = (Map)tasks.get((Object)backendId, (Object)type);
        ArrayList tasks = Lists.newArrayList();
        if (taskMap != null) {
            for (AgentTask task : taskMap.values()) {
                if (task.getFailedTimes() <= 0) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }
}

