/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import org.apache.doris.common.Config;
import org.apache.doris.thrift.TResourceInfo;
import org.apache.doris.thrift.TTaskType;

public abstract class AgentTask {
    protected long signature;
    protected long backendId;
    protected TTaskType taskType;
    protected long dbId;
    protected long tableId;
    protected long partitionId;
    protected long indexId;
    protected long tabletId;
    protected TResourceInfo resourceInfo;
    protected int failedTimes;
    protected String errorMsg;
    protected boolean isFinished = false;
    protected long createTime;

    public AgentTask(TResourceInfo resourceInfo, long backendId, TTaskType taskType, long dbId, long tableId, long partitionId, long indexId, long tabletId, long signature, long createTime) {
        this.backendId = backendId;
        this.signature = signature;
        this.taskType = taskType;
        this.dbId = dbId;
        this.tableId = tableId;
        this.partitionId = partitionId;
        this.indexId = indexId;
        this.tabletId = tabletId;
        this.resourceInfo = resourceInfo;
        this.failedTimes = 0;
        this.createTime = createTime;
    }

    public AgentTask(TResourceInfo resourceInfo, long backendId, TTaskType taskType, long dbId, long tableId, long partitionId, long indexId, long tabletId) {
        this(resourceInfo, backendId, taskType, dbId, tableId, partitionId, indexId, tabletId, tabletId, -1L);
    }

    public AgentTask(TResourceInfo resourceInfo, long backendId, TTaskType taskType, long dbId, long tableId, long partitionId, long indexId, long tabletId, long signature) {
        this(resourceInfo, backendId, taskType, dbId, tableId, partitionId, indexId, tabletId, signature, -1L);
    }

    public long getSignature() {
        return this.signature;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public TTaskType getTaskType() {
        return this.taskType;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public TResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public void failed() {
        ++this.failedTimes;
    }

    public int getFailedTimes() {
        return this.failedTimes;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean shouldResend(long currentTimeMillis) {
        return this.createTime == -1L || currentTimeMillis - this.createTime > Config.agent_task_resend_wait_time_ms;
    }

    public String toString() {
        return "[" + this.taskType + "], signature: " + this.signature + ", backendId: " + this.backendId + ", tablet id: " + this.tabletId;
    }
}

