/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.task;

import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Status;
import org.apache.doris.thrift.BackendService;
import org.apache.doris.thrift.TAgentResult;
import org.apache.doris.thrift.TAgentServiceVersion;
import org.apache.doris.thrift.TCheckStorageFormatResult;
import org.apache.doris.thrift.TDeleteEtlFilesRequest;
import org.apache.doris.thrift.TExportStatusResult;
import org.apache.doris.thrift.TExportTaskRequest;
import org.apache.doris.thrift.TMiniLoadEtlStatusRequest;
import org.apache.doris.thrift.TMiniLoadEtlStatusResult;
import org.apache.doris.thrift.TMiniLoadEtlTaskRequest;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TSnapshotRequest;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentClient {
    private static final Logger LOG = LogManager.getLogger(AgentClient.class);
    private String host;
    private int port;
    private BackendService.Client client;
    private TNetworkAddress address;
    private boolean ok;

    public AgentClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAgentResult submitEtlTask(TMiniLoadEtlTaskRequest request) {
        TAgentResult result = null;
        LOG.debug("submit etl task. request: {}", (Object)request);
        try {
            this.borrowClient();
            result = this.client.submitEtlTask(request);
            this.ok = true;
        }
        catch (Exception e) {
            LOG.warn("submit etl task error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAgentResult makeSnapshot(TSnapshotRequest request) {
        TAgentResult result = null;
        LOG.debug("submit make snapshot task. request: {}", (Object)request);
        try {
            this.borrowClient();
            result = this.client.makeSnapshot(request);
            this.ok = true;
        }
        catch (Exception e) {
            LOG.warn("submit make snapshot error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TAgentResult releaseSnapshot(String snapshotPath) {
        TAgentResult result = null;
        LOG.debug("submit release snapshot task. snapshotPath: {}", (Object)snapshotPath);
        try {
            this.borrowClient();
            result = this.client.releaseSnapshot(snapshotPath);
            this.ok = true;
        }
        catch (Exception e) {
            LOG.warn("submit release snapshot error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status submitExportTask(TExportTaskRequest request) {
        Status result = Status.CANCELLED;
        LOG.debug("submit export task. request: {}", (Object)request);
        try {
            this.borrowClient();
            TStatus status = this.client.submitExportTask(request);
            result = new Status(status);
        }
        catch (Exception e) {
            LOG.warn("submit export task error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMiniLoadEtlStatusResult getEtlStatus(long jobId, long taskId) {
        TMiniLoadEtlStatusResult result = null;
        TMiniLoadEtlStatusRequest request = new TMiniLoadEtlStatusRequest(TAgentServiceVersion.V1, new TUniqueId(jobId, taskId));
        LOG.debug("get mini load etl task status. request: {}", (Object)request);
        try {
            this.borrowClient();
            result = this.client.getEtlStatus(request);
            this.ok = true;
        }
        catch (Exception e) {
            LOG.warn("get etl status error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TExportStatusResult getExportStatus(long jobId, long taskId) {
        TExportStatusResult result = null;
        TUniqueId request = new TUniqueId(jobId, taskId);
        LOG.debug("get export task status. request: {}", (Object)request);
        try {
            this.borrowClient();
            result = this.client.getExportStatus(request);
            this.ok = true;
        }
        catch (Exception e) {
            LOG.warn("get export status error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status eraseExportTask(long jobId, long taskId) {
        Status result = Status.CANCELLED;
        TUniqueId request = new TUniqueId(jobId, taskId);
        LOG.debug("erase export task. request: {}", (Object)request);
        try {
            this.borrowClient();
            TStatus status = this.client.eraseExportTask(request);
            result = new Status(status);
        }
        catch (Exception e) {
            LOG.warn("submit export task error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    public TCheckStorageFormatResult checkStorageFormat() {
        TCheckStorageFormatResult result = null;
        LOG.debug("submit make snapshot task.");
        try {
            this.borrowClient();
            result = this.client.checkStorageFormat();
            this.ok = true;
        }
        catch (Exception e) {
            LOG.warn("checkStorageFormat error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEtlFiles(long dbId, long jobId, String dbName, String label) {
        TDeleteEtlFilesRequest request = new TDeleteEtlFilesRequest(TAgentServiceVersion.V1, new TUniqueId(dbId, jobId), dbName, label);
        LOG.debug("delete etl files. request: {}", (Object)request);
        try {
            this.borrowClient();
            this.client.deleteEtlFiles(request);
            this.ok = true;
        }
        catch (Exception e) {
            LOG.warn("delete etl files error", (Throwable)e);
        }
        finally {
            this.returnClient();
        }
    }

    private void borrowClient() throws Exception {
        this.ok = false;
        this.address = new TNetworkAddress(this.host, this.port);
        this.client = ClientPool.backendPool.borrowObject(this.address);
    }

    private void returnClient() {
        if (this.ok) {
            ClientPool.backendPool.returnObject(this.address, this.client);
        } else {
            ClientPool.backendPool.invalidateObject(this.address, this.client);
        }
    }
}

