/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.doris.analysis.ModifyBackendClause;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DiskInfo;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.cluster.Cluster;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Status;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.CountingDataOutputStream;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.system.BeSelectionPolicy;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemInfoService {
    private static final Logger LOG = LogManager.getLogger(SystemInfoService.class);
    public static final String DEFAULT_CLUSTER = "default_cluster";
    public static final String NO_BACKEND_LOAD_AVAILABLE_MSG = "No backend load available.";
    public static final String NO_SCAN_NODE_BACKEND_AVAILABLE_MSG = "There is no scanNode Backend available.";
    private volatile ImmutableMap<Long, Backend> idToBackendRef = ImmutableMap.of();
    private volatile ImmutableMap<Long, AtomicLong> idToReportVersionRef = ImmutableMap.of();
    private Map<Tag, Long> lastBackendIdForReplicaCreation = Maps.newConcurrentMap();
    private long lastBackendIdForCreation = -1L;
    private long lastBackendIdForOther = -1L;
    private volatile ImmutableMap<Long, DiskInfo> pathHashToDishInfoRef = ImmutableMap.of();
    private static final Comparator<List<Backend>> hostBackendsListComparator = new Comparator<List<Backend>>(){

        @Override
        public int compare(List<Backend> list1, List<Backend> list2) {
            if (list1.size() > list2.size()) {
                return -1;
            }
            return 1;
        }
    };

    public void addBackends(List<Pair<String, Integer>> hostPortPairs, boolean isFree) throws UserException {
        this.addBackends(hostPortPairs, isFree, "", Tag.DEFAULT_BACKEND_TAG);
    }

    public void addBackends(List<Pair<String, Integer>> hostPortPairs, boolean isFree, String destCluster, Tag tag) throws UserException {
        for (Pair<String, Integer> pair : hostPortPairs) {
            if (this.getBackendWithHeartbeatPort((String)pair.first, (Integer)pair.second) == null) continue;
            throw new DdlException("Same backend already exists[" + (String)pair.first + ":" + pair.second + "]");
        }
        for (Pair<String, Integer> pair : hostPortPairs) {
            this.addBackend((String)pair.first, (Integer)pair.second, isFree, destCluster, tag);
        }
    }

    public void addBackend(Backend backend) {
        ImmutableMap newIdToBackend;
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        copiedBackends.put(backend.getId(), backend);
        this.idToBackendRef = newIdToBackend = ImmutableMap.copyOf((Map)copiedBackends);
    }

    private void setBackendOwner(Backend backend, String clusterName) {
        Cluster cluster = Catalog.getCurrentCatalog().getCluster(clusterName);
        Preconditions.checkState((cluster != null ? 1 : 0) != 0);
        cluster.addBackend(backend.getId());
        backend.setOwnerClusterName(clusterName);
        backend.setBackendState(Backend.BackendState.using);
    }

    private void addBackend(String host, int heartbeatPort, boolean isFree, String destCluster, Tag tag) throws UserException {
        ImmutableMap newIdToReportVersion;
        ImmutableMap newIdToBackend;
        Backend newBackend = new Backend(Catalog.getCurrentCatalog().getNextId(), host, heartbeatPort);
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        copiedBackends.put(newBackend.getId(), newBackend);
        this.idToBackendRef = newIdToBackend = ImmutableMap.copyOf((Map)copiedBackends);
        HashMap copiedReportVersions = Maps.newHashMap(this.idToReportVersionRef);
        copiedReportVersions.put(newBackend.getId(), new AtomicLong(0L));
        this.idToReportVersionRef = newIdToReportVersion = ImmutableMap.copyOf((Map)copiedReportVersions);
        if (!Strings.isNullOrEmpty((String)destCluster)) {
            this.setBackendOwner(newBackend, destCluster);
        } else if (!isFree) {
            this.setBackendOwner(newBackend, DEFAULT_CLUSTER);
        }
        newBackend.setTag(tag);
        Catalog.getCurrentCatalog().getEditLog().logAddBackend(newBackend);
        LOG.info("finished to add {} ", (Object)newBackend);
        MetricRepo.generateBackendsTabletMetrics();
    }

    public void dropBackends(List<Pair<String, Integer>> hostPortPairs) throws DdlException {
        for (Pair<String, Integer> pair : hostPortPairs) {
            if (this.getBackendWithHeartbeatPort((String)pair.first, (Integer)pair.second) != null) continue;
            throw new DdlException("backend does not exists[" + (String)pair.first + ":" + pair.second + "]");
        }
        for (Pair<String, Integer> pair : hostPortPairs) {
            this.dropBackend((String)pair.first, (Integer)pair.second);
        }
    }

    public void dropBackend(long backendId) throws DdlException {
        Backend backend = this.getBackend(backendId);
        if (backend == null) {
            throw new DdlException("Backend[" + backendId + "] does not exist");
        }
        this.dropBackend(backend.getHost(), backend.getHeartbeatPort());
    }

    public void dropBackend(String host, int heartbeatPort) throws DdlException {
        ImmutableMap newIdToReportVersion;
        ImmutableMap newIdToBackend;
        if (this.getBackendWithHeartbeatPort(host, heartbeatPort) == null) {
            throw new DdlException("backend does not exists[" + host + ":" + heartbeatPort + "]");
        }
        Backend droppedBackend = this.getBackendWithHeartbeatPort(host, heartbeatPort);
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        copiedBackends.remove(droppedBackend.getId());
        this.idToBackendRef = newIdToBackend = ImmutableMap.copyOf((Map)copiedBackends);
        HashMap copiedReportVersions = Maps.newHashMap(this.idToReportVersionRef);
        copiedReportVersions.remove(droppedBackend.getId());
        this.idToReportVersionRef = newIdToReportVersion = ImmutableMap.copyOf((Map)copiedReportVersions);
        Cluster cluster = Catalog.getCurrentCatalog().getCluster(droppedBackend.getOwnerClusterName());
        if (null != cluster) {
            cluster.removeBackend(droppedBackend.getId());
        } else {
            LOG.error("Cluster " + droppedBackend.getOwnerClusterName() + " no exist.");
        }
        Catalog.getCurrentCatalog().getEditLog().logDropBackend(droppedBackend);
        LOG.info("finished to drop {}", (Object)droppedBackend);
        MetricRepo.generateBackendsTabletMetrics();
    }

    public void dropAllBackend() {
        this.idToBackendRef = ImmutableMap.of();
        this.idToReportVersionRef = ImmutableMap.of();
    }

    public Backend getBackend(long backendId) {
        return (Backend)this.idToBackendRef.get((Object)backendId);
    }

    public boolean checkBackendLoadAvailable(long backendId) {
        Backend backend = (Backend)this.idToBackendRef.get((Object)backendId);
        return backend != null && backend.isLoadAvailable();
    }

    public boolean checkBackendQueryAvailable(long backendId) {
        Backend backend = (Backend)this.idToBackendRef.get((Object)backendId);
        return backend != null && backend.isQueryAvailable();
    }

    public boolean checkBackendScheduleAvailable(long backendId) {
        Backend backend = (Backend)this.idToBackendRef.get((Object)backendId);
        return backend != null && backend.isScheduleAvailable();
    }

    public boolean checkBackendAlive(long backendId) {
        Backend backend = (Backend)this.idToBackendRef.get((Object)backendId);
        return backend != null && backend.isAlive();
    }

    public Backend getBackendWithHeartbeatPort(String host, int heartPort) {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        for (Backend backend : idToBackend.values()) {
            if (!backend.getHost().equals(host) || backend.getHeartbeatPort() != heartPort) continue;
            return backend;
        }
        return null;
    }

    public Backend getBackendWithBePort(String host, int bePort) {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        for (Backend backend : idToBackend.values()) {
            if (!backend.getHost().equals(host) || backend.getBePort() != bePort) continue;
            return backend;
        }
        return null;
    }

    public Backend getBackendWithHttpPort(String host, int httpPort) {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        for (Backend backend : idToBackend.values()) {
            if (!backend.getHost().equals(host) || backend.getHttpPort() != httpPort) continue;
            return backend;
        }
        return null;
    }

    public List<Long> getBackendIds(boolean needAlive) {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        ArrayList backendIds = Lists.newArrayList((Iterable)idToBackend.keySet());
        if (!needAlive) {
            return backendIds;
        }
        Iterator iter = backendIds.iterator();
        while (iter.hasNext()) {
            Backend backend = this.getBackend((Long)iter.next());
            if (backend != null && backend.isAlive()) continue;
            iter.remove();
        }
        return backendIds;
    }

    public List<Long> getDecommissionedBackendIds() {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        ArrayList backendIds = Lists.newArrayList((Iterable)idToBackend.keySet());
        Iterator iter = backendIds.iterator();
        while (iter.hasNext()) {
            Backend backend = this.getBackend((Long)iter.next());
            if (backend != null && backend.isDecommissioned()) continue;
            iter.remove();
        }
        return backendIds;
    }

    public List<Long> createCluster(String clusterName, int instanceNum) {
        ArrayList chosenBackendIds = Lists.newArrayList();
        Map<String, List<Backend>> hostBackendsMap = this.getHostBackendsMap(true, true, false);
        LOG.info("begin to create cluster {} with instance num: {}", (Object)clusterName, (Object)instanceNum);
        int availableBackendsCount = 0;
        ArrayList hostBackendsList = Lists.newArrayList();
        for (List<Backend> list : hostBackendsMap.values()) {
            availableBackendsCount += list.size();
            hostBackendsList.add(list);
        }
        if (instanceNum > availableBackendsCount) {
            LOG.warn("not enough available backends. requires :" + instanceNum + ", available:" + availableBackendsCount);
            return null;
        }
        Collections.sort(hostBackendsList, hostBackendsListComparator);
        boolean[] hostIsEmpty = new boolean[hostBackendsList.size()];
        for (int i = 0; i < hostBackendsList.size(); ++i) {
            hostIsEmpty[i] = false;
        }
        int numOfHost = hostBackendsList.size();
        int i = 0;
        while (true) {
            if (((List)hostBackendsList.get(i)).size() > 0) {
                chosenBackendIds.add(((Backend)((List)hostBackendsList.get(i)).remove(0)).getId());
            } else if (!hostIsEmpty[i]) {
                hostIsEmpty[i] = true;
                --numOfHost;
            }
            if (chosenBackendIds.size() == instanceNum || numOfHost == 0) break;
            ++i;
            i %= hostBackendsList.size();
        }
        if (chosenBackendIds.size() != instanceNum) {
            LOG.warn("not enough available backends. require :" + instanceNum + " get:" + chosenBackendIds.size());
            return null;
        }
        return chosenBackendIds;
    }

    public void releaseBackends(String clusterName, boolean isReplay) {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        List<Long> backendIds = this.getClusterBackendIds(clusterName);
        for (Long id : backendIds) {
            if (!idToBackend.containsKey((Object)id)) {
                LOG.warn("cluster {} contain backend {} that doesn't exist", (Object)clusterName, (Object)id);
                continue;
            }
            Backend backend = (Backend)idToBackend.get((Object)id);
            backend.setBackendState(Backend.BackendState.free);
            backend.clearClusterName();
            if (isReplay) continue;
            Catalog.getCurrentCatalog().getEditLog().logBackendStateChange(backend);
        }
    }

    @Deprecated
    public List<Long> calculateDecommissionBackends(String clusterName, int shrinkNum) {
        LOG.info("calculate decommission backend in cluster: {}. decommission num: {}", (Object)clusterName, (Object)shrinkNum);
        ArrayList decomBackendIds = Lists.newArrayList();
        ImmutableMap<Long, Backend> idToBackends = this.idToBackendRef;
        List<Long> clusterBackends = this.getClusterBackendIds(clusterName);
        HashMap hostBackendsMapInCluster = Maps.newHashMap();
        for (Long id : clusterBackends) {
            Backend backend = (Backend)idToBackends.get((Object)id);
            if (hostBackendsMapInCluster.containsKey(backend.getHost())) {
                ((List)hostBackendsMapInCluster.get(backend.getHost())).add(backend);
                continue;
            }
            ArrayList list = Lists.newArrayList();
            list.add(backend);
            hostBackendsMapInCluster.put(backend.getHost(), list);
        }
        ArrayList hostList = Lists.newArrayList(hostBackendsMapInCluster.values());
        Collections.sort(hostList, hostBackendsListComparator);
        while (((List)hostList.get(0)).size() > 0) {
            decomBackendIds.add(((Backend)((List)hostList.get(0)).remove(0)).getId());
            if (decomBackendIds.size() == shrinkNum) break;
            Collections.sort(hostList, hostBackendsListComparator);
        }
        if (decomBackendIds.size() != shrinkNum) {
            LOG.info("failed to get enough backends to shrink in cluster: {}. required: {}, get: {}", (Object)clusterName, (Object)shrinkNum, (Object)decomBackendIds.size());
            return null;
        }
        return decomBackendIds;
    }

    /*
     * WARNING - void declaration
     */
    public List<Long> calculateExpansionBackends(String clusterName, int expansionNum) {
        int i;
        boolean[] hostIsEmpty;
        LOG.debug("calculate expansion backend in cluster: {}, new instance num: {}", (Object)clusterName, (Object)expansionNum);
        ArrayList chosenBackendIds = Lists.newArrayList();
        ImmutableMap<Long, Backend> idToBackends = this.idToBackendRef;
        Map<String, List<Backend>> hostBackendsMap = this.getHostBackendsMap(true, true, false);
        List<Long> clusterBackends = this.getClusterBackendIds(clusterName);
        ArrayList hostsNotInCluster = Lists.newArrayList();
        ArrayList hostsInCluster = Lists.newArrayList();
        int availableBackendsCount = 0;
        HashSet hostsSet = Sets.newHashSet();
        for (Long l : clusterBackends) {
            hostsSet.add(this.getBackend(l).getHost());
        }
        for (Map.Entry entry : hostBackendsMap.entrySet()) {
            availableBackendsCount += ((List)entry.getValue()).size();
            if (hostsSet.contains(entry.getKey())) {
                hostsInCluster.add((List)entry.getValue());
                continue;
            }
            hostsNotInCluster.add((List)entry.getValue());
        }
        if (expansionNum > availableBackendsCount) {
            LOG.info("not enough available backends. requires :" + expansionNum + ", available:" + availableBackendsCount);
            return null;
        }
        Collections.sort(hostsNotInCluster, hostBackendsListComparator);
        Collections.sort(hostsInCluster, hostBackendsListComparator);
        if (hostsNotInCluster.size() > 0) {
            void var12_16;
            hostIsEmpty = new boolean[hostsNotInCluster.size()];
            boolean bl = false;
            while (var12_16 < hostsNotInCluster.size()) {
                hostIsEmpty[var12_16] = false;
                ++var12_16;
            }
            int n = hostsNotInCluster.size();
            i = 0;
            while (true) {
                void var12_18;
                if (((List)hostsNotInCluster.get(i)).size() > 0) {
                    chosenBackendIds.add(((Backend)((List)hostsNotInCluster.get(i)).remove(0)).getId());
                } else if (!hostIsEmpty[i]) {
                    hostIsEmpty[i] = true;
                    --var12_18;
                }
                if (chosenBackendIds.size() == expansionNum || var12_18 == false) break;
                ++i;
                i %= hostsNotInCluster.size();
            }
        }
        if (hostsInCluster.size() > 0 && chosenBackendIds.size() != expansionNum) {
            void var12_20;
            hostIsEmpty = new boolean[hostsInCluster.size()];
            boolean bl = false;
            while (var12_20 < hostsInCluster.size()) {
                hostIsEmpty[var12_20] = false;
                ++var12_20;
            }
            int n = hostsInCluster.size();
            i = 0;
            while (true) {
                void var12_22;
                if (((List)hostsInCluster.get(i)).size() > 0) {
                    chosenBackendIds.add(((Backend)((List)hostsInCluster.get(i)).remove(0)).getId());
                } else if (!hostIsEmpty[i]) {
                    hostIsEmpty[i] = true;
                    --var12_22;
                }
                if (chosenBackendIds.size() == expansionNum || var12_22 == false) break;
                ++i;
                i %= hostsInCluster.size();
            }
        }
        if (chosenBackendIds.size() != expansionNum) {
            LOG.info("not enough available backends. requires :" + expansionNum + ", get:" + chosenBackendIds.size());
            return null;
        }
        for (Long l : chosenBackendIds) {
            Backend backend = (Backend)idToBackends.get((Object)l);
            backend.setOwnerClusterName(clusterName);
            backend.setBackendState(Backend.BackendState.using);
            Catalog.getCurrentCatalog().getEditLog().logBackendStateChange(backend);
        }
        return chosenBackendIds;
    }

    public List<Backend> getClusterBackends(String name) {
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        ArrayList ret = Lists.newArrayList();
        if (Strings.isNullOrEmpty((String)name)) {
            return ret;
        }
        for (Backend backend : copiedBackends.values()) {
            if (!name.equals(backend.getOwnerClusterName())) continue;
            ret.add(backend);
        }
        return ret;
    }

    public List<Backend> getClusterBackends(String name, boolean needAlive) {
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        ArrayList<Backend> ret = new ArrayList<Backend>();
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (needAlive) {
            for (Backend backend : copiedBackends.values()) {
                if (backend == null || !name.equals(backend.getOwnerClusterName()) || !backend.isAlive()) continue;
                ret.add(backend);
            }
        } else {
            for (Backend backend : copiedBackends.values()) {
                if (!name.equals(backend.getOwnerClusterName())) continue;
                ret.add(backend);
            }
        }
        return ret;
    }

    public List<Long> getClusterBackendIds(String clusterName) {
        if (Strings.isNullOrEmpty((String)clusterName)) {
            return null;
        }
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        ArrayList beIds = Lists.newArrayList();
        for (Backend backend : idToBackend.values()) {
            if (!clusterName.equals(backend.getOwnerClusterName())) continue;
            beIds.add(backend.getId());
        }
        return beIds;
    }

    public List<Long> getClusterBackendIds(String clusterName, boolean needAlive) {
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        ArrayList<Long> ret = new ArrayList<Long>();
        if (Strings.isNullOrEmpty((String)clusterName)) {
            return null;
        }
        if (needAlive) {
            for (Backend backend : copiedBackends.values()) {
                if (backend == null || !clusterName.equals(backend.getOwnerClusterName()) || !backend.isAlive()) continue;
                ret.add(backend.getId());
            }
        } else {
            for (Backend backend : copiedBackends.values()) {
                if (!clusterName.equals(backend.getOwnerClusterName())) continue;
                ret.add(backend.getId());
            }
        }
        return ret;
    }

    private Map<String, List<Backend>> getHostBackendsMap(boolean needAlive, boolean needFree, boolean canBeDecommission) {
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        HashMap classMap = Maps.newHashMap();
        for (Backend backend : copiedBackends.values()) {
            List<Backend> list;
            if (needAlive && !backend.isAlive() || needFree && !backend.isFreeFromCluster() || !canBeDecommission && backend.isDecommissioned()) continue;
            if (classMap.containsKey(backend.getHost())) {
                list = (List)classMap.get(backend.getHost());
                list.add(backend);
                classMap.put(backend.getHost(), list);
                continue;
            }
            list = new ArrayList<Backend>();
            list.add(backend);
            classMap.put(backend.getHost(), list);
        }
        return classMap;
    }

    public Map<Tag, List<Long>> selectBackendIdsForReplicaCreation(ReplicaAllocation replicaAlloc, String clusterName, TStorageMedium storageMedium) throws DdlException {
        HashMap chosenBackendIds = Maps.newHashMap();
        Map<Tag, Short> allocMap = replicaAlloc.getAllocMap();
        short totalReplicaNum = 0;
        for (Map.Entry<Tag, Short> entry : allocMap.entrySet()) {
            BeSelectionPolicy policy;
            List<Long> beIds;
            BeSelectionPolicy.Builder builder = new BeSelectionPolicy.Builder().setCluster(clusterName).needScheduleAvailable().needCheckDiskUsage().addTags(Sets.newHashSet((Object[])new Tag[]{entry.getKey()})).setStorageMedium(storageMedium);
            if (FeConstants.runningUnitTest || Config.allow_replica_on_same_host) {
                builder.allowOnSameHost();
            }
            if ((beIds = this.selectBackendIdsByPolicy(policy = builder.build(), entry.getValue().shortValue())).isEmpty()) {
                throw new DdlException("Failed to find " + entry.getValue() + " backends for policy: " + policy);
            }
            chosenBackendIds.put(entry.getKey(), beIds);
            totalReplicaNum = (short)(totalReplicaNum + beIds.size());
        }
        Preconditions.checkState((totalReplicaNum == replicaAlloc.getTotalReplicaNum() ? 1 : 0) != 0);
        return chosenBackendIds;
    }

    public List<Long> selectBackendIdsByPolicy(BeSelectionPolicy policy, int number) {
        Preconditions.checkArgument((number >= -1 ? 1 : 0) != 0);
        List candidates = this.idToBackendRef.values().stream().filter(policy::isMatch).collect(Collectors.toList());
        if (number != -1 && candidates.size() < number || candidates.isEmpty()) {
            LOG.debug("Not match policy: {}. candidates num: {}, expected: {}", (Object)policy, (Object)candidates.size(), (Object)number);
            return Lists.newArrayList();
        }
        if (number == 1) {
            Collections.shuffle(candidates);
            return Lists.newArrayList((Object[])new Long[]{((Backend)candidates.get(0)).getId()});
        }
        if (policy.allowOnSameHost) {
            Collections.shuffle(candidates);
            if (number == -1) {
                return candidates.stream().map(b -> b.getId()).collect(Collectors.toList());
            }
            return candidates.subList(0, number).stream().map(b -> b.getId()).collect(Collectors.toList());
        }
        HashMap backendMaps = Maps.newHashMap();
        for (Backend backend : candidates) {
            if (backendMaps.containsKey(backend.getHost())) {
                ((List)backendMaps.get(backend.getHost())).add(backend);
                continue;
            }
            ArrayList list = Lists.newArrayList();
            list.add(backend);
            backendMaps.put(backend.getHost(), list);
        }
        candidates.clear();
        for (List list : backendMaps.values()) {
            Collections.shuffle(list);
            candidates.add((Backend)list.get(0));
        }
        if (number != -1 && candidates.size() < number) {
            LOG.debug("Not match policy: {}. candidates num: {}, expected: {}", (Object)policy, (Object)candidates.size(), (Object)number);
            return Lists.newArrayList();
        }
        Collections.shuffle(candidates);
        if (number != -1) {
            return candidates.subList(0, number).stream().map(b -> b.getId()).collect(Collectors.toList());
        }
        return candidates.stream().map(b -> b.getId()).collect(Collectors.toList());
    }

    public ImmutableMap<Long, Backend> getIdToBackend() {
        return this.idToBackendRef;
    }

    public ImmutableMap<Long, Backend> getBackendsInCluster(String cluster) {
        if (Strings.isNullOrEmpty((String)cluster)) {
            return this.idToBackendRef;
        }
        HashMap retMaps = Maps.newHashMap();
        for (Backend backend : this.idToBackendRef.values().asList()) {
            if (!cluster.equals(backend.getOwnerClusterName())) continue;
            retMaps.put(backend.getId(), backend);
        }
        return ImmutableMap.copyOf((Map)retMaps);
    }

    public long getBackendReportVersion(long backendId) {
        AtomicLong atomicLong = null;
        atomicLong = (AtomicLong)this.idToReportVersionRef.get((Object)backendId);
        if (atomicLong == null) {
            return -1L;
        }
        return atomicLong.get();
    }

    public void updateBackendReportVersion(long backendId, long newReportVersion, long dbId, long tableId) {
        AtomicLong atomicLong = (AtomicLong)this.idToReportVersionRef.get((Object)backendId);
        if (atomicLong != null) {
            Database db = Catalog.getCurrentCatalog().getDbNullable(dbId);
            if (db == null) {
                LOG.warn("failed to update backend report version, db {} does not exist", (Object)dbId);
                return;
            }
            atomicLong.set(newReportVersion);
            LOG.debug("update backend {} report version: {}, db: {}, table: {}", (Object)backendId, (Object)newReportVersion, (Object)dbId, (Object)tableId);
        }
    }

    public long saveBackends(CountingDataOutputStream dos, long checksum) throws IOException {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        int backendCount = idToBackend.size();
        checksum ^= (long)backendCount;
        dos.writeInt(backendCount);
        for (Map.Entry entry : idToBackend.entrySet()) {
            long key = (Long)entry.getKey();
            checksum ^= key;
            dos.writeLong(key);
            ((Backend)entry.getValue()).write((DataOutput)dos);
        }
        return checksum;
    }

    public long loadBackends(DataInputStream dis, long checksum) throws IOException {
        int count = dis.readInt();
        checksum ^= (long)count;
        for (int i = 0; i < count; ++i) {
            long key = dis.readLong();
            checksum ^= key;
            Backend backend = Backend.read(dis);
            this.replayAddBackend(backend);
        }
        return checksum;
    }

    public void clear() {
        this.idToBackendRef = null;
        this.idToReportVersionRef = null;
    }

    public static Pair<String, Integer> validateHostAndPort(String hostPort) throws AnalysisException {
        if ((hostPort = hostPort.replaceAll("\\s+", "")).isEmpty()) {
            throw new AnalysisException("Invalid host port: " + hostPort);
        }
        String[] pair = hostPort.split(":");
        if (pair.length != 2) {
            throw new AnalysisException("Invalid host port: " + hostPort);
        }
        String host = pair[0];
        if (Strings.isNullOrEmpty((String)host)) {
            throw new AnalysisException("Host is null");
        }
        int heartbeatPort = -1;
        try {
            if (!InetAddressValidator.getInstance().isValid(host)) {
                InetAddress inetAddress = InetAddress.getByName(host);
                host = inetAddress.getHostAddress();
            }
            if ((heartbeatPort = Integer.parseInt(pair[1])) <= 0 || heartbeatPort >= 65536) {
                throw new AnalysisException("Port is out of range: " + heartbeatPort);
            }
            return new Pair<String, Integer>(host, heartbeatPort);
        }
        catch (UnknownHostException e) {
            throw new AnalysisException("Unknown host: " + e.getMessage());
        }
        catch (Exception e) {
            throw new AnalysisException("Encounter unknown exception: " + e.getMessage());
        }
    }

    public void replayAddBackend(Backend newBackend) {
        Cluster cluster;
        ImmutableMap newIdToReportVersion;
        ImmutableMap newIdToBackend;
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        copiedBackends.put(newBackend.getId(), newBackend);
        this.idToBackendRef = newIdToBackend = ImmutableMap.copyOf((Map)copiedBackends);
        HashMap copiedReportVersions = Maps.newHashMap(this.idToReportVersionRef);
        copiedReportVersions.put(newBackend.getId(), new AtomicLong(0L));
        this.idToReportVersionRef = newIdToReportVersion = ImmutableMap.copyOf((Map)copiedReportVersions);
        if (newBackend.getBackendState() == Backend.BackendState.using && null != (cluster = Catalog.getCurrentCatalog().getCluster(DEFAULT_CLUSTER))) {
            cluster.addBackend(newBackend.getId());
        }
    }

    public void replayDropBackend(Backend backend) {
        ImmutableMap newIdToReportVersion;
        ImmutableMap newIdToBackend;
        LOG.debug("replayDropBackend: {}", (Object)backend);
        HashMap copiedBackends = Maps.newHashMap(this.idToBackendRef);
        copiedBackends.remove(backend.getId());
        this.idToBackendRef = newIdToBackend = ImmutableMap.copyOf((Map)copiedBackends);
        HashMap copiedReportVersions = Maps.newHashMap(this.idToReportVersionRef);
        copiedReportVersions.remove(backend.getId());
        this.idToReportVersionRef = newIdToReportVersion = ImmutableMap.copyOf((Map)copiedReportVersions);
        Cluster cluster = Catalog.getCurrentCatalog().getCluster(backend.getOwnerClusterName());
        if (null != cluster) {
            cluster.removeBackend(backend.getId());
        } else {
            LOG.error("Cluster " + backend.getOwnerClusterName() + " no exist.");
        }
    }

    public void updateBackendState(Backend be) {
        long id = be.getId();
        Backend memoryBe = this.getBackend(id);
        if (memoryBe == null) {
            return;
        }
        memoryBe.setBePort(be.getBePort());
        memoryBe.setAlive(be.isAlive());
        memoryBe.setDecommissioned(be.isDecommissioned());
        memoryBe.setHttpPort(be.getHttpPort());
        memoryBe.setBeRpcPort(be.getBeRpcPort());
        memoryBe.setBrpcPort(be.getBrpcPort());
        memoryBe.setLastUpdateMs(be.getLastUpdateMs());
        memoryBe.setLastStartTime(be.getLastStartTime());
        memoryBe.setDisks(be.getDisks());
        memoryBe.setBackendState(be.getBackendState());
        memoryBe.setOwnerClusterName(be.getOwnerClusterName());
        memoryBe.setDecommissionType(be.getDecommissionType());
    }

    private long getClusterAvailableCapacityB(String clusterName) {
        List<Backend> clusterBackends = this.getClusterBackends(clusterName);
        long capacity = 0L;
        for (Backend backend : clusterBackends) {
            if (backend.isDecommissioned()) {
                capacity -= backend.getDataUsedCapacityB();
                continue;
            }
            capacity += backend.getAvailableCapacityB();
        }
        return capacity;
    }

    public void checkClusterCapacity(String clusterName) throws DdlException {
        if (this.getClusterAvailableCapacityB(clusterName) <= 0L) {
            throw new DdlException("Cluster " + clusterName + " has no available capacity");
        }
    }

    public long getBackendIdByHost(String host) {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        ArrayList selectedBackends = Lists.newArrayList();
        for (Backend backend : idToBackend.values()) {
            if (!backend.getHost().equals(host)) continue;
            selectedBackends.add(backend);
        }
        if (selectedBackends.isEmpty()) {
            return -1L;
        }
        Collections.shuffle(selectedBackends);
        return ((Backend)selectedBackends.get(0)).getId();
    }

    public Set<String> getClusterNames() {
        ImmutableMap<Long, Backend> idToBackend = this.idToBackendRef;
        HashSet clusterNames = Sets.newHashSet();
        for (Backend backend : idToBackend.values()) {
            if (Strings.isNullOrEmpty((String)backend.getOwnerClusterName())) continue;
            clusterNames.add(backend.getOwnerClusterName());
        }
        return clusterNames;
    }

    public Status checkExceedDiskCapacityLimit(Multimap<Long, Long> bePathsMap, boolean floodStage) {
        LOG.debug("pathBeMap: {}", bePathsMap);
        ImmutableMap<Long, DiskInfo> pathHashToDiskInfo = this.pathHashToDishInfoRef;
        for (Long beId : bePathsMap.keySet()) {
            for (Long pathHash : bePathsMap.get((Object)beId)) {
                DiskInfo diskInfo = (DiskInfo)pathHashToDiskInfo.get((Object)pathHash);
                if (diskInfo == null || !diskInfo.exceedLimit(floodStage)) continue;
                return new Status(TStatusCode.CANCELLED, "disk " + pathHash + " on backend " + beId + " exceed limit usage");
            }
        }
        return Status.OK;
    }

    public void updatePathInfo(List<DiskInfo> addedDisks, List<DiskInfo> removedDisks) {
        ImmutableMap newPathInfos;
        HashMap copiedPathInfos = Maps.newHashMap(this.pathHashToDishInfoRef);
        for (DiskInfo diskInfo : addedDisks) {
            copiedPathInfos.put(diskInfo.getPathHash(), diskInfo);
        }
        for (DiskInfo diskInfo : removedDisks) {
            copiedPathInfos.remove(diskInfo.getPathHash());
        }
        this.pathHashToDishInfoRef = newPathInfos = ImmutableMap.copyOf((Map)copiedPathInfos);
        LOG.debug("update path infos: {}", (Object)newPathInfos);
    }

    public void modifyBackends(ModifyBackendClause alterClause) throws UserException {
        List<Pair<String, Integer>> hostPortPairs = alterClause.getHostPortPairs();
        ArrayList backends = Lists.newArrayList();
        for (Pair<String, Integer> pair : hostPortPairs) {
            Backend be = this.getBackendWithHeartbeatPort((String)pair.first, (Integer)pair.second);
            if (be == null) {
                throw new DdlException("backend does not exists[" + (String)pair.first + ":" + pair.second + "]");
            }
            backends.add(be);
        }
        for (Backend be : backends) {
            boolean shouldModify = false;
            if (alterClause.getTag() != null) {
                Tag tag = alterClause.getTag();
                if (!be.getTag().equals(tag)) {
                    be.setTag(tag);
                    shouldModify = true;
                }
            }
            if (alterClause.isQueryDisabled() != null && !alterClause.isQueryDisabled().equals(be.isQueryDisabled())) {
                be.setQueryDisabled(alterClause.isQueryDisabled());
                shouldModify = true;
            }
            if (alterClause.isLoadDisabled() != null && !alterClause.isLoadDisabled().equals(be.isLoadDisabled())) {
                be.setLoadDisabled(alterClause.isLoadDisabled());
                shouldModify = true;
            }
            if (!shouldModify) continue;
            Catalog.getCurrentCatalog().getEditLog().logModifyBackend(be);
            LOG.info("finished to modify backend {} ", (Object)be);
        }
    }

    public void replayModifyBackend(Backend backend) {
        Backend memBe = this.getBackend(backend.getId());
        memBe.setTag(backend.getTag());
        memBe.setQueryDisabled(backend.isQueryDisabled());
        memBe.setLoadDisabled(backend.isLoadDisabled());
        LOG.debug("replay modify backend: {}", (Object)backend);
    }

    public void checkReplicaAllocation(String cluster, ReplicaAllocation replicaAlloc) throws DdlException {
        List<Backend> backends = this.getClusterBackends(cluster);
        for (Map.Entry<Tag, Short> entry : replicaAlloc.getAllocMap().entrySet()) {
            if (backends.stream().filter(b -> b.getTag().equals(entry.getKey())).count() >= (long)entry.getValue().shortValue()) continue;
            throw new DdlException("Failed to find enough host with tag(" + entry.getKey() + ") in all backends. need: " + entry.getValue());
        }
    }

    public Set<Tag> getTagsByCluster(String clusterName) {
        List<Backend> bes = this.getClusterBackends(clusterName);
        HashSet tags = Sets.newHashSet();
        for (Backend be : bes) {
            tags.add(be.getTag());
        }
        return tags;
    }

    public List<Backend> getBackendsByTagInCluster(String clusterName, Tag tag) {
        List<Backend> bes = this.getClusterBackends(clusterName);
        return bes.stream().filter(b -> b.getTag().equals(tag)).collect(Collectors.toList());
    }
}

