/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.system.BackendHbResponse;
import org.apache.doris.system.BrokerHbResponse;
import org.apache.doris.system.FrontendHbResponse;

public class HeartbeatResponse
implements Writable {
    protected Type type;
    protected boolean isTypeRead = false;
    protected HbStatus status;
    protected String msg;
    protected long hbTime;

    public HeartbeatResponse(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public HbStatus getStatus() {
        return this.status;
    }

    public String getMsg() {
        return this.msg;
    }

    public long getHbTime() {
        return this.hbTime;
    }

    public void setTypeRead(boolean isTypeRead) {
        this.isTypeRead = isTypeRead;
    }

    public static HeartbeatResponse read(DataInput in) throws IOException {
        HeartbeatResponse result = null;
        Type type = Type.valueOf(Text.readString((DataInput)in));
        if (type == Type.FRONTEND) {
            result = new FrontendHbResponse();
        } else if (type == Type.BACKEND) {
            result = new BackendHbResponse();
        } else if (type == Type.BROKER) {
            result = new BrokerHbResponse();
        } else {
            throw new IOException("Unknown job type: " + type.name());
        }
        result.setTypeRead(true);
        ((HeartbeatResponse)result).readFields(in);
        return result;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.type.name());
        Text.writeString((DataOutput)out, (String)this.status.name());
    }

    public void readFields(DataInput in) throws IOException {
        if (!this.isTypeRead) {
            this.type = Type.valueOf(Text.readString((DataInput)in));
            this.isTypeRead = true;
        }
        this.status = HbStatus.valueOf(Text.readString((DataInput)in));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("type: ").append(this.type.name());
        sb.append(", status: ").append(this.status.name());
        sb.append(", msg: ").append(this.msg);
        return sb.toString();
    }

    public static enum HbStatus {
        OK,
        BAD;

    }

    public static enum Type {
        FRONTEND,
        BACKEND,
        BROKER;

    }
}

