/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.common.ClientPool;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.ThreadPoolManager;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.persist.HbPackage;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.system.Backend;
import org.apache.doris.system.BackendHbResponse;
import org.apache.doris.system.BrokerHbResponse;
import org.apache.doris.system.Frontend;
import org.apache.doris.system.FrontendHbResponse;
import org.apache.doris.system.HeartbeatFlags;
import org.apache.doris.system.HeartbeatResponse;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.thrift.FrontendService;
import org.apache.doris.thrift.HeartbeatService;
import org.apache.doris.thrift.TBackendInfo;
import org.apache.doris.thrift.TBrokerOperationStatus;
import org.apache.doris.thrift.TBrokerOperationStatusCode;
import org.apache.doris.thrift.TBrokerPingBrokerRequest;
import org.apache.doris.thrift.TBrokerVersion;
import org.apache.doris.thrift.TFrontendPingFrontendRequest;
import org.apache.doris.thrift.TFrontendPingFrontendResult;
import org.apache.doris.thrift.TFrontendPingFrontendStatusCode;
import org.apache.doris.thrift.THeartbeatResult;
import org.apache.doris.thrift.TMasterInfo;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TPaloBrokerService;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TStatusCode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatMgr
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(HeartbeatMgr.class);
    private final ExecutorService executor;
    private SystemInfoService nodeMgr;
    private HeartbeatFlags heartbeatFlags;
    private static volatile AtomicReference<TMasterInfo> masterInfo = new AtomicReference();

    public HeartbeatMgr(SystemInfoService nodeMgr, boolean needRegisterMetric) {
        super("heartbeat mgr", FeConstants.heartbeat_interval_second * 1000);
        this.nodeMgr = nodeMgr;
        this.executor = ThreadPoolManager.newDaemonFixedThreadPool(Config.heartbeat_mgr_threads_num, Config.heartbeat_mgr_blocking_queue_size, "heartbeat-mgr-pool", needRegisterMetric);
        this.heartbeatFlags = new HeartbeatFlags();
    }

    public void setMaster(int clusterId, String token, long epoch) {
        TMasterInfo tMasterInfo = new TMasterInfo(new TNetworkAddress(FrontendOptions.getLocalHostAddress(), Config.rpc_port), clusterId, epoch);
        tMasterInfo.setToken(token);
        tMasterInfo.setHttpPort(Config.http_port);
        long flags = this.heartbeatFlags.getHeartbeatFlags();
        tMasterInfo.setHeartbeatFlags(flags);
        masterInfo.set(tMasterInfo);
    }

    @Override
    protected void runAfterCatalogReady() {
        ArrayList hbResponses = Lists.newArrayList();
        for (Object backend : this.nodeMgr.getIdToBackend().values()) {
            BackendHeartbeatHandler backendHeartbeatHandler = new BackendHeartbeatHandler((Backend)backend);
            hbResponses.add(this.executor.submit(backendHeartbeatHandler));
        }
        List<Frontend> frontends = Catalog.getCurrentCatalog().getFrontends(null);
        for (Frontend frontend : frontends) {
            FrontendHeartbeatHandler frontendHeartbeatHandler = new FrontendHeartbeatHandler(frontend, Catalog.getCurrentCatalog().getClusterId(), Catalog.getCurrentCatalog().getToken());
            hbResponses.add(this.executor.submit(frontendHeartbeatHandler));
        }
        HashMap brokerMap = Maps.newHashMap(Catalog.getCurrentCatalog().getBrokerMgr().getBrokerListMap());
        for (Map.Entry entry : brokerMap.entrySet()) {
            for (FsBroker brokerAddress : (List)entry.getValue()) {
                BrokerHeartbeatHandler handler = new BrokerHeartbeatHandler((String)entry.getKey(), brokerAddress, masterInfo.get().getNetworkAddress().getHostname());
                hbResponses.add(this.executor.submit(handler));
            }
        }
        HbPackage hbPackage = new HbPackage();
        for (Future future : hbResponses) {
            boolean isChanged = false;
            try {
                HeartbeatResponse response = (HeartbeatResponse)future.get();
                if (response.getStatus() != HeartbeatResponse.HbStatus.OK) {
                    LOG.warn("get bad heartbeat response: {}", (Object)response);
                }
                if (!(isChanged = this.handleHbResponse(response, false))) continue;
                hbPackage.addHbResponse(response);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("got exception when doing heartbeat", (Throwable)e);
            }
        }
        Catalog.getCurrentCatalog().getEditLog().logHeartbeat(hbPackage);
    }

    private boolean handleHbResponse(HeartbeatResponse response, boolean isReplay) {
        switch (response.getType()) {
            case FRONTEND: {
                FrontendHbResponse hbResponse = (FrontendHbResponse)response;
                Frontend fe = Catalog.getCurrentCatalog().getFeByName(hbResponse.getName());
                if (fe == null) break;
                return fe.handleHbResponse(hbResponse);
            }
            case BACKEND: {
                BackendHbResponse hbResponse = (BackendHbResponse)response;
                Backend be = this.nodeMgr.getBackend(hbResponse.getBeId());
                if (be == null) break;
                boolean isChanged = be.handleHbResponse(hbResponse);
                if (hbResponse.getStatus() != HeartbeatResponse.HbStatus.OK) {
                    ClientPool.backendPool.clearPool(new TNetworkAddress(be.getHost(), be.getBePort()));
                    if (!isReplay) {
                        Catalog.getCurrentCatalog().getGlobalTransactionMgr().abortTxnWhenCoordinateBeDown(be.getHost(), 100);
                    }
                }
                return isChanged;
            }
            case BROKER: {
                BrokerHbResponse hbResponse = (BrokerHbResponse)response;
                FsBroker broker = Catalog.getCurrentCatalog().getBrokerMgr().getBroker(hbResponse.getName(), hbResponse.getHost(), hbResponse.getPort());
                if (broker == null) break;
                boolean isChanged = broker.handleHbResponse(hbResponse);
                if (hbResponse.getStatus() != HeartbeatResponse.HbStatus.OK) {
                    ClientPool.brokerPool.clearPool(new TNetworkAddress(broker.ip, broker.port));
                }
                return isChanged;
            }
        }
        return false;
    }

    public void replayHearbeat(HbPackage hbPackage) {
        for (HeartbeatResponse hbResult : hbPackage.getHbResults()) {
            this.handleHbResponse(hbResult, true);
        }
    }

    public static class BrokerHeartbeatHandler
    implements Callable<HeartbeatResponse> {
        private String brokerName;
        private FsBroker broker;
        private String clientId;

        public BrokerHeartbeatHandler(String brokerName, FsBroker broker, String clientId) {
            this.brokerName = brokerName;
            this.broker = broker;
            this.clientId = clientId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HeartbeatResponse call() {
            TPaloBrokerService.Client client = null;
            TNetworkAddress addr = new TNetworkAddress(this.broker.ip, this.broker.port);
            boolean ok = false;
            try {
                client = ClientPool.brokerPool.borrowObject(addr);
                TBrokerPingBrokerRequest request = new TBrokerPingBrokerRequest(TBrokerVersion.VERSION_ONE, this.clientId);
                TBrokerOperationStatus status = client.ping(request);
                ok = true;
                if (status.getStatusCode() != TBrokerOperationStatusCode.OK) {
                    BrokerHbResponse brokerHbResponse = new BrokerHbResponse(this.brokerName, this.broker.ip, this.broker.port, status.getMessage());
                    return brokerHbResponse;
                }
                BrokerHbResponse brokerHbResponse = new BrokerHbResponse(this.brokerName, this.broker.ip, this.broker.port, System.currentTimeMillis());
                return brokerHbResponse;
            }
            catch (Exception e) {
                BrokerHbResponse brokerHbResponse = new BrokerHbResponse(this.brokerName, this.broker.ip, this.broker.port, Strings.isNullOrEmpty((String)e.getMessage()) ? "got exception" : e.getMessage());
                return brokerHbResponse;
            }
            finally {
                if (ok) {
                    ClientPool.brokerPool.returnObject(addr, client);
                } else {
                    ClientPool.brokerPool.invalidateObject(addr, client);
                }
            }
        }
    }

    public static class FrontendHeartbeatHandler
    implements Callable<HeartbeatResponse> {
        private Frontend fe;
        private int clusterId;
        private String token;

        public FrontendHeartbeatHandler(Frontend fe, int clusterId, String token) {
            this.fe = fe;
            this.clusterId = clusterId;
            this.token = token;
        }

        @Override
        public HeartbeatResponse call() {
            if (this.fe.getHost().equals(Catalog.getCurrentCatalog().getSelfNode().first)) {
                if (Catalog.getCurrentCatalog().isReady()) {
                    return new FrontendHbResponse(this.fe.getNodeName(), Config.query_port, Config.rpc_port, Catalog.getCurrentCatalog().getMaxJournalId(), System.currentTimeMillis(), "1.1.0-rc05-Unknown");
                }
                return new FrontendHbResponse(this.fe.getNodeName(), "not ready");
            }
            return this.getHeartbeatResponse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HeartbeatResponse getHeartbeatResponse() {
            FrontendService.Client client = null;
            TNetworkAddress addr = new TNetworkAddress(this.fe.getHost(), Config.rpc_port);
            boolean ok = false;
            try {
                client = ClientPool.frontendHeartbeatPool.borrowObject(addr);
                TFrontendPingFrontendRequest request = new TFrontendPingFrontendRequest(this.clusterId, this.token);
                TFrontendPingFrontendResult result = client.ping(request);
                ok = true;
                if (result.getStatus() == TFrontendPingFrontendStatusCode.OK) {
                    FrontendHbResponse frontendHbResponse = new FrontendHbResponse(this.fe.getNodeName(), result.getQueryPort(), result.getRpcPort(), result.getReplayedJournalId(), System.currentTimeMillis(), result.getVersion());
                    return frontendHbResponse;
                }
                FrontendHbResponse frontendHbResponse = new FrontendHbResponse(this.fe.getNodeName(), result.getMsg());
                return frontendHbResponse;
            }
            catch (Exception e) {
                FrontendHbResponse frontendHbResponse = new FrontendHbResponse(this.fe.getNodeName(), Strings.isNullOrEmpty((String)e.getMessage()) ? "got exception" : e.getMessage());
                return frontendHbResponse;
            }
            finally {
                if (ok) {
                    ClientPool.frontendHeartbeatPool.returnObject(addr, client);
                } else {
                    ClientPool.frontendHeartbeatPool.invalidateObject(addr, client);
                }
            }
        }
    }

    private class BackendHeartbeatHandler
    implements Callable<HeartbeatResponse> {
        private Backend backend;

        public BackendHeartbeatHandler(Backend backend) {
            this.backend = backend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HeartbeatResponse call() {
            BackendHbResponse backendHbResponse;
            block19: {
                long backendId = this.backend.getId();
                HeartbeatService.Client client = null;
                TNetworkAddress beAddr = new TNetworkAddress(this.backend.getHost(), this.backend.getHeartbeatPort());
                boolean ok = false;
                try {
                    THeartbeatResult result;
                    TMasterInfo copiedMasterInfo = new TMasterInfo((TMasterInfo)masterInfo.get());
                    copiedMasterInfo.setBackendIp(this.backend.getHost());
                    long flags = HeartbeatMgr.this.heartbeatFlags.getHeartbeatFlags();
                    copiedMasterInfo.setHeartbeatFlags(flags);
                    copiedMasterInfo.setBackendId(backendId);
                    if (!FeConstants.runningUnitTest) {
                        client = ClientPool.backendHeartbeatPool.borrowObject(beAddr);
                        result = client.heartbeat(copiedMasterInfo);
                    } else {
                        TBackendInfo backendInfo = new TBackendInfo();
                        backendInfo.setBePort(1);
                        backendInfo.setHttpPort(2);
                        backendInfo.setBeRpcPort(3);
                        backendInfo.setBrpcPort(4);
                        backendInfo.setVersion("test-1234");
                        result = new THeartbeatResult();
                        result.setStatus(new TStatus(TStatusCode.OK));
                        result.setBackendInfo(backendInfo);
                    }
                    ok = true;
                    if (result.getStatus().getStatusCode() == TStatusCode.OK) {
                        TBackendInfo tBackendInfo = result.getBackendInfo();
                        int bePort = tBackendInfo.getBePort();
                        int httpPort = tBackendInfo.getHttpPort();
                        int brpcPort = -1;
                        if (tBackendInfo.isSetBrpcPort()) {
                            brpcPort = tBackendInfo.getBrpcPort();
                        }
                        String version = "";
                        if (tBackendInfo.isSetVersion()) {
                            version = tBackendInfo.getVersion();
                        }
                        long beStartTime = tBackendInfo.isSetBeStartTime() ? tBackendInfo.getBeStartTime() : System.currentTimeMillis();
                        BackendHbResponse backendHbResponse2 = new BackendHbResponse(backendId, bePort, httpPort, brpcPort, System.currentTimeMillis(), beStartTime, version);
                        if (client != null) {
                            if (ok) {
                                ClientPool.backendHeartbeatPool.returnObject(beAddr, client);
                            } else {
                                ClientPool.backendHeartbeatPool.invalidateObject(beAddr, client);
                            }
                        }
                        return backendHbResponse2;
                    }
                    backendHbResponse = new BackendHbResponse(backendId, result.getStatus().getErrorMsgs().isEmpty() ? "Unknown error" : (String)result.getStatus().getErrorMsgs().get(0));
                    if (client == null) break block19;
                }
                catch (Exception e) {
                    LOG.warn("backend heartbeat got exception", (Throwable)e);
                    BackendHbResponse backendHbResponse3 = new BackendHbResponse(backendId, Strings.isNullOrEmpty((String)e.getMessage()) ? "got exception" : e.getMessage());
                    return backendHbResponse3;
                }
                finally {
                    if (client != null) {
                        if (ok) {
                            ClientPool.backendHeartbeatPool.returnObject(beAddr, client);
                        } else {
                            ClientPool.backendHeartbeatPool.invalidateObject(beAddr, client);
                        }
                    }
                }
                if (ok) {
                    ClientPool.backendHeartbeatPool.returnObject(beAddr, client);
                } else {
                    ClientPool.backendHeartbeatPool.invalidateObject(beAddr, client);
                }
            }
            return backendHbResponse;
        }
    }
}

