/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.system.HeartbeatResponse;

public class FrontendHbResponse
extends HeartbeatResponse
implements Writable {
    private String name;
    private int queryPort;
    private int rpcPort;
    private long replayedJournalId;
    private String version;

    public FrontendHbResponse() {
        super(HeartbeatResponse.Type.FRONTEND);
    }

    public FrontendHbResponse(String name, int queryPort, int rpcPort, long replayedJournalId, long hbTime, String version) {
        super(HeartbeatResponse.Type.FRONTEND);
        this.status = HeartbeatResponse.HbStatus.OK;
        this.name = name;
        this.queryPort = queryPort;
        this.rpcPort = rpcPort;
        this.replayedJournalId = replayedJournalId;
        this.hbTime = hbTime;
        this.version = version;
    }

    public FrontendHbResponse(String name, String errMsg) {
        super(HeartbeatResponse.Type.FRONTEND);
        this.status = HeartbeatResponse.HbStatus.BAD;
        this.name = name;
        this.msg = errMsg;
    }

    public String getName() {
        return this.name;
    }

    public int getQueryPort() {
        return this.queryPort;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public long getReplayedJournalId() {
        return this.replayedJournalId;
    }

    public String getVersion() {
        return this.version;
    }

    public static FrontendHbResponse read(DataInput in) throws IOException {
        FrontendHbResponse result = new FrontendHbResponse();
        result.readFields(in);
        return result;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.name);
        out.writeInt(this.queryPort);
        out.writeInt(this.rpcPort);
        out.writeLong(this.replayedJournalId);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.name = Text.readString((DataInput)in);
        this.queryPort = in.readInt();
        this.rpcPort = in.readInt();
        this.replayedJournalId = in.readLong();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", name: ").append(this.name);
        sb.append(", version: ").append(this.version);
        sb.append(", queryPort: ").append(this.queryPort);
        sb.append(", rpcPort: ").append(this.rpcPort);
        sb.append(", replayedJournalId: ").append(this.replayedJournalId);
        return sb.toString();
    }
}

