/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.ha.FrontendNodeType;
import org.apache.doris.system.FrontendHbResponse;
import org.apache.doris.system.HeartbeatResponse;

public class Frontend
implements Writable {
    private FrontendNodeType role;
    private String nodeName;
    private String host;
    private int editLogPort;
    private String version;
    private int queryPort;
    private int rpcPort;
    private long replayedJournalId;
    private long lastUpdateTime;
    private String heartbeatErrMsg = "";
    private boolean isAlive = false;

    public Frontend() {
    }

    public Frontend(FrontendNodeType role, String nodeName, String host, int editLogPort) {
        this.role = role;
        this.nodeName = nodeName;
        this.host = host;
        this.editLogPort = editLogPort;
    }

    public FrontendNodeType getRole() {
        return this.role;
    }

    public String getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getQueryPort() {
        return this.queryPort;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public int getEditLogPort() {
        return this.editLogPort;
    }

    public long getReplayedJournalId() {
        return this.replayedJournalId;
    }

    public String getHeartbeatErrMsg() {
        return this.heartbeatErrMsg;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean handleHbResponse(FrontendHbResponse hbResponse) {
        boolean isChanged = false;
        if (hbResponse.getStatus() == HeartbeatResponse.HbStatus.OK) {
            this.isAlive = true;
            this.version = hbResponse.getVersion();
            this.queryPort = hbResponse.getQueryPort();
            this.rpcPort = hbResponse.getRpcPort();
            this.replayedJournalId = hbResponse.getReplayedJournalId();
            this.lastUpdateTime = hbResponse.getHbTime();
            this.heartbeatErrMsg = "";
            isChanged = true;
        } else {
            if (this.isAlive) {
                this.isAlive = false;
                isChanged = true;
            }
            this.heartbeatErrMsg = hbResponse.getMsg() == null ? "Unknown error" : hbResponse.getMsg();
        }
        return isChanged;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.role.name());
        Text.writeString((DataOutput)out, (String)this.host);
        out.writeInt(this.editLogPort);
        Text.writeString((DataOutput)out, (String)this.nodeName);
    }

    public void readFields(DataInput in) throws IOException {
        this.role = FrontendNodeType.valueOf(Text.readString((DataInput)in));
        if (this.role == FrontendNodeType.REPLICA) {
            this.role = FrontendNodeType.FOLLOWER;
        }
        this.host = Text.readString((DataInput)in);
        this.editLogPort = in.readInt();
        this.nodeName = Text.readString((DataInput)in);
    }

    public static Frontend read(DataInput in) throws IOException {
        Frontend frontend = new Frontend();
        frontend.readFields(in);
        return frontend;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name: ").append(this.nodeName).append(", role: ").append(this.role.name());
        sb.append(", ").append(this.host).append(":").append(this.editLogPort);
        return sb.toString();
    }
}

