/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.catalog.TabletMeta;
import org.apache.doris.common.Config;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.json.simple.JSONObject;

public class Diagnoser {
    public static List<List<String>> diagnoseTablet(long tabletId) {
        ArrayList results = Lists.newArrayList();
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        TabletMeta tabletMeta = invertedIndex.getTabletMeta(tabletId);
        if (tabletMeta == null) {
            results.add(Lists.newArrayList((Object[])new String[]{"TabletExist", "No", ""}));
            return results;
        }
        results.add(Lists.newArrayList((Object[])new String[]{"TabletExist", "Yes", ""}));
        results.add(Lists.newArrayList((Object[])new String[]{"TabletId", String.valueOf(tabletId), ""}));
        Database db = Catalog.getCurrentCatalog().getDbNullable(tabletMeta.getDbId());
        if (db == null) {
            results.add(Lists.newArrayList((Object[])new String[]{"Database", "Not exist", ""}));
            return results;
        }
        results.add(Lists.newArrayList((Object[])new String[]{"Database", db.getFullName() + ": " + db.getId(), ""}));
        OlapTable tbl = (OlapTable)db.getTableNullable(tabletMeta.getTableId());
        if (tbl == null) {
            results.add(Lists.newArrayList((Object[])new String[]{"Table", "Not exist", ""}));
            return results;
        }
        results.add(Lists.newArrayList((Object[])new String[]{"Table", tbl.getName() + ": " + tbl.getId(), ""}));
        Partition partition = tbl.getPartition(tabletMeta.getPartitionId());
        if (partition == null) {
            results.add(Lists.newArrayList((Object[])new String[]{"Partition", "Not exist", ""}));
            return results;
        }
        results.add(Lists.newArrayList((Object[])new String[]{"Partition", partition.getName() + ": " + partition.getId(), ""}));
        MaterializedIndex mIndex = partition.getIndex(tabletMeta.getIndexId());
        if (mIndex == null) {
            results.add(Lists.newArrayList((Object[])new String[]{"MaterializedIndex", "Not exist", ""}));
            return results;
        }
        results.add(Lists.newArrayList((Object[])new String[]{"MaterializedIndex", tbl.getIndexNameById(mIndex.getId()) + ": " + mIndex.getId(), ""}));
        Tablet tablet = mIndex.getTablet(tabletId);
        List<Replica> replicas = tablet.getReplicas();
        JSONObject jobj = new JSONObject();
        for (Replica replica : replicas) {
            jobj.put((Object)replica.getId(), (Object)replica.getBackendId());
        }
        results.add(Lists.newArrayList((Object[])new String[]{"Replicas(ReplicaId -> BackendId)", jobj.toJSONString(), ""}));
        short replicaNum = tbl.getPartitionInfo().getReplicaAllocation(partition.getId()).getTotalReplicaNum();
        if (replicas.size() != replicaNum) {
            results.add(Lists.newArrayList((Object[])new String[]{"ReplicasNum", "Replica num is " + replicas.size() + ", expected: " + replicaNum, ""}));
        } else {
            results.add(Lists.newArrayList((Object[])new String[]{"ReplicasNum", "OK", ""}));
        }
        SystemInfoService infoService = Catalog.getCurrentSystemInfo();
        StringBuilder backendErr = new StringBuilder();
        StringBuilder versionErr = new StringBuilder();
        StringBuilder statusErr = new StringBuilder();
        StringBuilder compactionErr = new StringBuilder();
        for (Replica replica : replicas) {
            Backend be = infoService.getBackend(replica.getBackendId());
            if (be == null) {
                backendErr.append("Backend " + replica.getBackendId() + " does not exist. ");
            } else if (!be.isAlive()) {
                backendErr.append("Backend " + replica.getBackendId() + " is not alive. ");
            } else if (be.isDecommissioned()) {
                backendErr.append("Backend " + replica.getBackendId() + " is decommission. ");
            } else if (!be.isLoadAvailable()) {
                backendErr.append("Backend " + replica.getBackendId() + " is not load available. ");
            } else if (!be.isQueryAvailable()) {
                backendErr.append("Backend " + replica.getBackendId() + " is not query available. ");
            } else if (be.diskExceedLimit()) {
                backendErr.append("Backend " + replica.getBackendId() + " has no space left. ");
            }
            if (replica.getVersion() != partition.getVisibleVersion()) {
                versionErr.append("Replica on backend " + replica.getBackendId() + "'s version (" + replica.getVersion() + ") does not equal to partition visible version (" + partition.getVisibleVersion() + ")");
            }
            if (!replica.isAlive()) {
                statusErr.append("Replica on backend " + replica.getBackendId() + "'s state is " + (Object)((Object)replica.getState()) + ", and is bad: " + (replica.isBad() ? "Yes" : "No"));
            }
            if (replica.getVersionCount() <= (long)Config.min_version_count_indicate_replica_compaction_too_slow) continue;
            compactionErr.append("Replica on backend " + replica.getBackendId() + "'s version count is too high: " + replica.getVersionCount());
        }
        results.add(Lists.newArrayList((Object[])new String[]{"ReplicaBackendStatus", backendErr.length() == 0 ? "OK" : backendErr.toString(), ""}));
        results.add(Lists.newArrayList((Object[])new String[]{"ReplicaVersionStatus", versionErr.length() == 0 ? "OK" : versionErr.toString(), ""}));
        results.add(Lists.newArrayList((Object[])new String[]{"ReplicaStatus", statusErr.length() == 0 ? "OK" : statusErr.toString(), ""}));
        results.add(Lists.newArrayList((Object[])new String[]{"ReplicaCompactionStatus", compactionErr.length() == 0 ? "OK" : compactionErr.toString(), ""}));
        return results;
    }
}

