/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.system.HeartbeatResponse;

public class BrokerHbResponse
extends HeartbeatResponse
implements Writable {
    private String name;
    private String host;
    private int port;

    public BrokerHbResponse() {
        super(HeartbeatResponse.Type.BROKER);
    }

    public BrokerHbResponse(String name, String host, int port, long hbTime) {
        super(HeartbeatResponse.Type.BROKER);
        this.status = HeartbeatResponse.HbStatus.OK;
        this.name = name;
        this.host = host;
        this.port = port;
        this.hbTime = hbTime;
    }

    public BrokerHbResponse(String name, String host, int port, String errMsg) {
        super(HeartbeatResponse.Type.BROKER);
        this.status = HeartbeatResponse.HbStatus.BAD;
        this.name = name;
        this.host = host;
        this.port = port;
        this.msg = errMsg;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static BrokerHbResponse read(DataInput in) throws IOException {
        BrokerHbResponse result = new BrokerHbResponse();
        result.readFields(in);
        return result;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.name);
        Text.writeString((DataOutput)out, (String)this.host);
        out.writeInt(this.port);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.name = Text.readString((DataInput)in);
        this.host = Text.readString((DataInput)in);
        this.port = in.readInt();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", name: ").append(this.name);
        sb.append(", host: ").append(this.host);
        sb.append(", port: ").append(this.port);
        return sb.toString();
    }
}

