/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.TStorageMedium;

public class BeSelectionPolicy {
    public String cluster = "default_cluster";
    public boolean needScheduleAvailable = false;
    public boolean needQueryAvailable = false;
    public boolean needLoadAvailable = false;
    public Set<Tag> resourceTags = Sets.newHashSet();
    public TStorageMedium storageMedium = null;
    public boolean checkDiskUsage = false;
    public boolean allowOnSameHost = false;

    private BeSelectionPolicy() {
    }

    public boolean isMatch(Backend backend) {
        if (this.needScheduleAvailable && !backend.isScheduleAvailable() || this.needQueryAvailable && !backend.isQueryAvailable() || this.needLoadAvailable && !backend.isLoadAvailable() || !this.resourceTags.isEmpty() && !this.resourceTags.contains(backend.getTag()) || this.storageMedium != null && !backend.hasSpecifiedStorageMedium(this.storageMedium)) {
            return false;
        }
        if (this.checkDiskUsage) {
            if (this.storageMedium == null && backend.diskExceedLimit()) {
                return false;
            }
            if (this.storageMedium != null && backend.diskExceedLimitByStorageMedium(this.storageMedium)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("cluster|query|load|schedule|tags|medium: ");
        sb.append(this.cluster).append("|");
        sb.append(this.needQueryAvailable).append("|");
        sb.append(this.needLoadAvailable).append("|");
        sb.append(this.needScheduleAvailable).append("|");
        sb.append(this.resourceTags).append("|");
        sb.append(this.storageMedium);
        return sb.toString();
    }

    public static class Builder {
        private BeSelectionPolicy policy = new BeSelectionPolicy();

        public Builder setCluster(String cluster) {
            this.policy.cluster = cluster;
            return this;
        }

        public Builder needScheduleAvailable() {
            this.policy.needScheduleAvailable = true;
            return this;
        }

        public Builder needQueryAvailable() {
            this.policy.needQueryAvailable = true;
            return this;
        }

        public Builder needLoadAvailable() {
            this.policy.needLoadAvailable = true;
            return this;
        }

        public Builder addTags(Set<Tag> tags) {
            this.policy.resourceTags.addAll(tags);
            return this;
        }

        public Builder setStorageMedium(TStorageMedium medium) {
            this.policy.storageMedium = medium;
            return this;
        }

        public Builder needCheckDiskUsage() {
            this.policy.checkDiskUsage = true;
            return this;
        }

        public Builder allowOnSameHost() {
            this.policy.allowOnSameHost = true;
            return this;
        }

        public BeSelectionPolicy build() {
            return this.policy;
        }
    }
}

