/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Writable;
import org.apache.doris.system.HeartbeatResponse;

public class BackendHbResponse
extends HeartbeatResponse
implements Writable {
    private long beId;
    private int bePort;
    private int httpPort;
    private int brpcPort;
    private long beStartTime;
    private String version = "";

    public BackendHbResponse() {
        super(HeartbeatResponse.Type.BACKEND);
    }

    public BackendHbResponse(long beId, int bePort, int httpPort, int brpcPort, long hbTime, long beStartTime, String version) {
        super(HeartbeatResponse.Type.BACKEND);
        this.beId = beId;
        this.status = HeartbeatResponse.HbStatus.OK;
        this.bePort = bePort;
        this.httpPort = httpPort;
        this.brpcPort = brpcPort;
        this.hbTime = hbTime;
        this.beStartTime = beStartTime;
        this.version = version;
    }

    public BackendHbResponse(long beId, String errMsg) {
        super(HeartbeatResponse.Type.BACKEND);
        this.status = HeartbeatResponse.HbStatus.BAD;
        this.beId = beId;
        this.msg = errMsg;
    }

    public long getBeId() {
        return this.beId;
    }

    public int getBePort() {
        return this.bePort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getBrpcPort() {
        return this.brpcPort;
    }

    public long getBeStartTime() {
        return this.beStartTime;
    }

    public String getVersion() {
        return this.version;
    }

    public static BackendHbResponse read(DataInput in) throws IOException {
        BackendHbResponse result = new BackendHbResponse();
        result.readFields(in);
        return result;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.beId);
        out.writeInt(this.bePort);
        out.writeInt(this.httpPort);
        out.writeInt(this.brpcPort);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.beId = in.readLong();
        this.bePort = in.readInt();
        this.httpPort = in.readInt();
        this.brpcPort = in.readInt();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", beId: ").append(this.beId);
        sb.append(", bePort: ").append(this.bePort);
        sb.append(", httpPort: ").append(this.httpPort);
        sb.append(", brpcPort: ").append(this.brpcPort);
        return sb.toString();
    }
}

