/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import org.apache.commons.lang.StringUtils;

public class BackendEvent {
    private final BackendEventType type;
    private final String message;
    private final Long[] backendIds;

    public BackendEvent(BackendEventType type, String message, Long ... backendIds) {
        this.type = type;
        this.message = message;
        this.backendIds = backendIds;
    }

    public BackendEventType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public Long[] getBackendIds() {
        return this.backendIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Backend[").append(StringUtils.join((Object[])this.backendIds, (String)", ")).append("]");
        sb.append(" Type: ").append(this.type.name());
        sb.append(" Msg: ").append(this.message);
        return sb.toString();
    }

    public static enum BackendEventType {
        BACKEND_DOWN,
        BACKEND_DROPPED,
        BACKEND_DECOMMISSION;

    }
}

