/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.system;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.doris.alter.DecommissionType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.DiskInfo;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.BackendHbResponse;
import org.apache.doris.system.HeartbeatResponse;
import org.apache.doris.thrift.TDisk;
import org.apache.doris.thrift.TStorageMedium;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Backend
implements Writable {
    public static final String DUMMY_IP = "0.0.0.0";
    private static final Logger LOG = LogManager.getLogger(Backend.class);
    @SerializedName(value="id")
    private long id;
    @SerializedName(value="host")
    private String host;
    private String version;
    @SerializedName(value="heartbeatPort")
    private int heartbeatPort;
    @SerializedName(value="bePort")
    private volatile int bePort;
    @SerializedName(value="httpPort")
    private volatile int httpPort;
    @SerializedName(value="beRpcPort")
    private volatile int beRpcPort;
    @SerializedName(value="brpcPort")
    private volatile int brpcPort = -1;
    @SerializedName(value="lastUpdateMs")
    private volatile long lastUpdateMs;
    @SerializedName(value="lastStartTime")
    private volatile long lastStartTime;
    @SerializedName(value="isAlive")
    private AtomicBoolean isAlive;
    @SerializedName(value="isDecommissioned")
    private AtomicBoolean isDecommissioned;
    @SerializedName(value="decommissionType")
    private volatile int decommissionType;
    @SerializedName(value="ownerClusterName")
    private volatile String ownerClusterName;
    @SerializedName(value="backendState")
    private volatile int backendState;
    @SerializedName(value="disksRef")
    private volatile ImmutableMap<String, DiskInfo> disksRef;
    private String heartbeatErrMsg = "";
    private boolean initPathInfo = false;
    private long lastMissingHeartbeatTime = -1L;
    private volatile long tabletMaxCompactionScore = 0L;
    @SerializedName(value="backendStatus")
    private BackendStatus backendStatus = new BackendStatus();
    @SerializedName(value="tag")
    private Tag tag = Tag.DEFAULT_BACKEND_TAG;

    public Backend() {
        this.host = "";
        this.version = "";
        this.lastUpdateMs = 0L;
        this.lastStartTime = 0L;
        this.isAlive = new AtomicBoolean();
        this.isDecommissioned = new AtomicBoolean(false);
        this.bePort = 0;
        this.httpPort = 0;
        this.beRpcPort = 0;
        this.disksRef = ImmutableMap.of();
        this.ownerClusterName = "";
        this.backendState = BackendState.free.ordinal();
        this.decommissionType = DecommissionType.SystemDecommission.ordinal();
    }

    public Backend(long id, String host, int heartbeatPort) {
        this.id = id;
        this.host = host;
        this.version = "";
        this.heartbeatPort = heartbeatPort;
        this.bePort = -1;
        this.httpPort = -1;
        this.beRpcPort = -1;
        this.lastUpdateMs = -1L;
        this.lastStartTime = -1L;
        this.disksRef = ImmutableMap.of();
        this.isAlive = new AtomicBoolean(false);
        this.isDecommissioned = new AtomicBoolean(false);
        this.ownerClusterName = "";
        this.backendState = BackendState.free.ordinal();
        this.decommissionType = DecommissionType.SystemDecommission.ordinal();
    }

    public long getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public String getVersion() {
        return this.version;
    }

    public int getBePort() {
        return this.bePort;
    }

    public int getHeartbeatPort() {
        return this.heartbeatPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getBeRpcPort() {
        return this.beRpcPort;
    }

    public int getBrpcPort() {
        return this.brpcPort;
    }

    public String getHeartbeatErrMsg() {
        return this.heartbeatErrMsg;
    }

    public long getLastStreamLoadTime() {
        return this.backendStatus.lastStreamLoadTime;
    }

    public void setLastStreamLoadTime(long lastStreamLoadTime) {
        this.backendStatus.lastStreamLoadTime = lastStreamLoadTime;
    }

    public boolean isQueryDisabled() {
        return this.backendStatus.isQueryDisabled;
    }

    public void setQueryDisabled(boolean isQueryDisabled) {
        this.backendStatus.isQueryDisabled = isQueryDisabled;
    }

    public boolean isLoadDisabled() {
        return this.backendStatus.isLoadDisabled;
    }

    public void setLoadDisabled(boolean isLoadDisabled) {
        this.backendStatus.isLoadDisabled = isLoadDisabled;
    }

    public void updateOnce(int bePort, int httpPort, int beRpcPort) {
        long currentTime;
        if (this.bePort != bePort) {
            this.bePort = bePort;
        }
        if (this.httpPort != httpPort) {
            this.httpPort = httpPort;
        }
        if (this.beRpcPort != beRpcPort) {
            this.beRpcPort = beRpcPort;
        }
        this.lastUpdateMs = currentTime = System.currentTimeMillis();
        if (!this.isAlive.get()) {
            this.lastStartTime = currentTime;
            LOG.info("{} is alive,", (Object)this.toString());
            this.isAlive.set(true);
        }
        this.heartbeatErrMsg = "";
    }

    public boolean setDecommissioned(boolean isDecommissioned) {
        if (this.isDecommissioned.compareAndSet(!isDecommissioned, isDecommissioned)) {
            LOG.warn("{} set decommission: {}", (Object)this.toString(), (Object)isDecommissioned);
            return true;
        }
        return false;
    }

    public void setBackendState(BackendState state) {
        this.backendState = state.ordinal();
    }

    public void setAlive(boolean isAlive) {
        this.isAlive.set(isAlive);
    }

    public void setBePort(int agentPort) {
        this.bePort = agentPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setBeRpcPort(int beRpcPort) {
        this.beRpcPort = beRpcPort;
    }

    public void setBrpcPort(int brpcPort) {
        this.brpcPort = brpcPort;
    }

    public long getLastUpdateMs() {
        return this.lastUpdateMs;
    }

    public void setLastUpdateMs(long currentTime) {
        this.lastUpdateMs = currentTime;
    }

    public long getLastStartTime() {
        return this.lastStartTime;
    }

    public void setLastStartTime(long currentTime) {
        this.lastStartTime = currentTime;
    }

    public long getLastMissingHeartbeatTime() {
        return this.lastMissingHeartbeatTime;
    }

    public boolean isAlive() {
        return this.isAlive.get();
    }

    public boolean isDecommissioned() {
        return this.isDecommissioned.get();
    }

    public boolean isQueryAvailable() {
        return this.isAlive() && !this.isQueryDisabled();
    }

    public boolean isScheduleAvailable() {
        return this.isAlive() && !this.isDecommissioned();
    }

    public boolean isLoadAvailable() {
        return this.isAlive() && !this.isLoadDisabled();
    }

    public void setDisks(ImmutableMap<String, DiskInfo> disks) {
        this.disksRef = disks;
    }

    public BackendStatus getBackendStatus() {
        return this.backendStatus;
    }

    public boolean isUsedByCluster() {
        return this.backendState == BackendState.using.ordinal();
    }

    public boolean isFreeFromCluster() {
        return this.backendState == BackendState.free.ordinal();
    }

    public boolean isOffLineFromCluster() {
        return this.backendState == BackendState.offline.ordinal();
    }

    public ImmutableMap<String, DiskInfo> getDisks() {
        return this.disksRef;
    }

    public boolean hasPathHash() {
        return this.disksRef.values().stream().allMatch(DiskInfo::hasPathHash);
    }

    public boolean hasSpecifiedStorageMedium(TStorageMedium storageMedium) {
        return this.disksRef.values().stream().anyMatch(d -> d.isStorageMediumMatch(storageMedium));
    }

    public long getTotalCapacityB() {
        ImmutableMap<String, DiskInfo> disks = this.disksRef;
        long totalCapacityB = 0L;
        for (DiskInfo diskInfo : disks.values()) {
            if (diskInfo.getState() != DiskInfo.DiskState.ONLINE) continue;
            totalCapacityB += diskInfo.getTotalCapacityB();
        }
        return totalCapacityB;
    }

    public long getAvailableCapacityB() {
        ImmutableMap<String, DiskInfo> disks = this.disksRef;
        long availableCapacityB = 1L;
        for (DiskInfo diskInfo : disks.values()) {
            if (diskInfo.getState() != DiskInfo.DiskState.ONLINE) continue;
            availableCapacityB += diskInfo.getAvailableCapacityB();
        }
        return availableCapacityB;
    }

    public long getDataUsedCapacityB() {
        ImmutableMap<String, DiskInfo> disks = this.disksRef;
        long dataUsedCapacityB = 0L;
        for (DiskInfo diskInfo : disks.values()) {
            if (diskInfo.getState() != DiskInfo.DiskState.ONLINE) continue;
            dataUsedCapacityB += diskInfo.getDataUsedCapacityB();
        }
        return dataUsedCapacityB;
    }

    public double getMaxDiskUsedPct() {
        ImmutableMap<String, DiskInfo> disks = this.disksRef;
        double maxPct = 0.0;
        for (DiskInfo diskInfo : disks.values()) {
            double percent;
            if (diskInfo.getState() != DiskInfo.DiskState.ONLINE || !((percent = diskInfo.getUsedPct()) > maxPct)) continue;
            maxPct = percent;
        }
        return maxPct;
    }

    public boolean diskExceedLimitByStorageMedium(TStorageMedium storageMedium) {
        if (this.getDiskNumByStorageMedium(storageMedium) <= 0L) {
            return true;
        }
        ImmutableMap<String, DiskInfo> diskInfos = this.disksRef;
        boolean exceedLimit = true;
        for (DiskInfo diskInfo : diskInfos.values()) {
            if (diskInfo.getState() != DiskInfo.DiskState.ONLINE || diskInfo.getStorageMedium() != storageMedium || diskInfo.exceedLimit(true)) continue;
            exceedLimit = false;
            break;
        }
        return exceedLimit;
    }

    public boolean diskExceedLimit() {
        if (this.getDiskNum() <= 0) {
            return true;
        }
        ImmutableMap<String, DiskInfo> diskInfos = this.disksRef;
        boolean exceedLimit = true;
        for (DiskInfo diskInfo : diskInfos.values()) {
            if (diskInfo.getState() != DiskInfo.DiskState.ONLINE || diskInfo.exceedLimit(true)) continue;
            exceedLimit = false;
            break;
        }
        return exceedLimit;
    }

    public String getPathByPathHash(long pathHash) {
        for (DiskInfo diskInfo : this.disksRef.values()) {
            if (diskInfo.getPathHash() != pathHash) continue;
            return diskInfo.getRootPath();
        }
        return null;
    }

    public void updateDisks(Map<String, TDisk> backendDisks) {
        String rootPath;
        ImmutableMap<String, DiskInfo> disks = this.disksRef;
        if (!this.initPathInfo) {
            boolean allPathHashUpdated = true;
            for (DiskInfo diskInfo : disks.values()) {
                if (diskInfo.getPathHash() != 0L) continue;
                allPathHashUpdated = false;
                break;
            }
            if (allPathHashUpdated) {
                this.initPathInfo = true;
                Catalog.getCurrentSystemInfo().updatePathInfo(new ArrayList<DiskInfo>((Collection<DiskInfo>)disks.values()), Lists.newArrayList());
            }
        }
        HashMap newDiskInfos = Maps.newHashMap();
        ArrayList addedDisks = Lists.newArrayList();
        ArrayList removedDisks = Lists.newArrayList();
        boolean isChanged = false;
        for (TDisk tDisk : backendDisks.values()) {
            rootPath = tDisk.getRootPath();
            long totalCapacityB = tDisk.getDiskTotalCapacity();
            long dataUsedCapacityB = tDisk.getDataUsedCapacity();
            long diskAvailableCapacityB = tDisk.getDiskAvailableCapacity();
            boolean isUsed = tDisk.isUsed();
            DiskInfo diskInfo = (DiskInfo)disks.get((Object)rootPath);
            if (diskInfo == null) {
                diskInfo = new DiskInfo(rootPath);
                addedDisks.add(diskInfo);
                isChanged = true;
                LOG.info("add new disk info. backendId: {}, rootPath: {}", (Object)this.id, (Object)rootPath);
            }
            newDiskInfos.put(rootPath, diskInfo);
            diskInfo.setTotalCapacityB(totalCapacityB);
            diskInfo.setDataUsedCapacityB(dataUsedCapacityB);
            diskInfo.setAvailableCapacityB(diskAvailableCapacityB);
            if (tDisk.isSetPathHash()) {
                diskInfo.setPathHash(tDisk.getPathHash());
            }
            if (tDisk.isSetStorageMedium()) {
                diskInfo.setStorageMedium(tDisk.getStorageMedium());
            }
            if (isUsed) {
                if (diskInfo.setState(DiskInfo.DiskState.ONLINE)) {
                    isChanged = true;
                }
            } else if (diskInfo.setState(DiskInfo.DiskState.OFFLINE)) {
                isChanged = true;
            }
            LOG.debug("update disk info. backendId: {}, diskInfo: {}", (Object)this.id, (Object)diskInfo.toString());
        }
        for (DiskInfo diskInfo : disks.values()) {
            rootPath = diskInfo.getRootPath();
            if (backendDisks.containsKey(rootPath)) continue;
            removedDisks.add(diskInfo);
            isChanged = true;
            LOG.warn("remove not exist rootPath. backendId: {}, rootPath: {}", (Object)this.id, (Object)rootPath);
        }
        if (isChanged) {
            this.disksRef = ImmutableMap.copyOf((Map)newDiskInfos);
            Catalog.getCurrentSystemInfo().updatePathInfo(addedDisks, removedDisks);
            Catalog.getCurrentCatalog().getEditLog().logBackendStateChange(this);
        }
    }

    public static Backend read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (Backend)GsonUtils.GSON.fromJson(json, Backend.class);
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        this.id = in.readLong();
        this.host = Text.readString((DataInput)in);
        this.heartbeatPort = in.readInt();
        this.bePort = in.readInt();
        this.httpPort = in.readInt();
        this.beRpcPort = in.readInt();
        this.isAlive.set(in.readBoolean());
        this.isDecommissioned.set(in.readBoolean());
        this.lastUpdateMs = in.readLong();
        this.lastStartTime = in.readLong();
        HashMap disks = Maps.newHashMap();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String rootPath = Text.readString((DataInput)in);
            DiskInfo diskInfo = DiskInfo.read(in);
            disks.put(rootPath, diskInfo);
        }
        this.disksRef = ImmutableMap.copyOf((Map)disks);
        this.ownerClusterName = Text.readString((DataInput)in);
        this.backendState = in.readInt();
        this.decommissionType = in.readInt();
        this.brpcPort = in.readInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Backend)) {
            return false;
        }
        Backend backend = (Backend)obj;
        return this.id == backend.id && this.host.equals(backend.host) && this.heartbeatPort == backend.heartbeatPort && this.bePort == backend.bePort && this.isAlive.get() == backend.isAlive.get();
    }

    public String toString() {
        return "Backend [id=" + this.id + ", host=" + this.host + ", heartbeatPort=" + this.heartbeatPort + ", alive=" + this.isAlive.get() + ", tag: " + this.tag + "]";
    }

    public String getOwnerClusterName() {
        return this.ownerClusterName;
    }

    public void setOwnerClusterName(String name) {
        this.ownerClusterName = name;
    }

    public void clearClusterName() {
        this.ownerClusterName = "";
    }

    public BackendState getBackendState() {
        switch (this.backendState) {
            case 0: {
                return BackendState.using;
            }
            case 1: {
                return BackendState.offline;
            }
        }
        return BackendState.free;
    }

    public void setDecommissionType(DecommissionType type) {
        this.decommissionType = type.ordinal();
    }

    public DecommissionType getDecommissionType() {
        if (this.decommissionType == DecommissionType.ClusterDecommission.ordinal()) {
            return DecommissionType.ClusterDecommission;
        }
        return DecommissionType.SystemDecommission;
    }

    public boolean handleHbResponse(BackendHbResponse hbResponse) {
        boolean isChanged = false;
        if (hbResponse.getStatus() == HeartbeatResponse.HbStatus.OK) {
            if (!this.version.equals(hbResponse.getVersion())) {
                isChanged = true;
                this.version = hbResponse.getVersion();
            }
            if (this.bePort != hbResponse.getBePort() && !FeConstants.runningUnitTest) {
                isChanged = true;
                this.bePort = hbResponse.getBePort();
            }
            if (this.httpPort != hbResponse.getHttpPort() && !FeConstants.runningUnitTest) {
                isChanged = true;
                this.httpPort = hbResponse.getHttpPort();
            }
            if (this.brpcPort != hbResponse.getBrpcPort() && !FeConstants.runningUnitTest) {
                isChanged = true;
                this.brpcPort = hbResponse.getBrpcPort();
            }
            this.lastUpdateMs = hbResponse.getHbTime();
            if (!this.isAlive.get()) {
                isChanged = true;
                this.lastStartTime = hbResponse.getBeStartTime();
                LOG.info("{} is alive, last start time: {}", (Object)this.toString(), (Object)hbResponse.getBeStartTime());
                this.isAlive.set(true);
            } else if (this.lastStartTime <= 0L) {
                this.lastStartTime = hbResponse.getBeStartTime();
            }
            this.heartbeatErrMsg = "";
        } else {
            if (this.isAlive.compareAndSet(true, false)) {
                isChanged = true;
                LOG.warn("{} is dead,", (Object)this.toString());
            }
            this.heartbeatErrMsg = hbResponse.getMsg() == null ? "Unknown error" : hbResponse.getMsg();
            this.lastMissingHeartbeatTime = System.currentTimeMillis();
        }
        return isChanged;
    }

    public void setTabletMaxCompactionScore(long compactionScore) {
        this.tabletMaxCompactionScore = compactionScore;
    }

    public long getTabletMaxCompactionScore() {
        return this.tabletMaxCompactionScore;
    }

    private long getDiskNumByStorageMedium(TStorageMedium storageMedium) {
        return this.disksRef.values().stream().filter(v -> v.getStorageMedium() == storageMedium).count();
    }

    private int getDiskNum() {
        return this.disksRef.size();
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Tag getTag() {
        return this.tag;
    }

    public class BackendStatus {
        public volatile String lastSuccessReportTabletsTime = "N/A";
        @SerializedName(value="lastStreamLoadTime")
        public volatile long lastStreamLoadTime = -1L;
        @SerializedName(value="isQueryDisabled")
        public volatile boolean isQueryDisabled = false;
        @SerializedName(value="isLoadDisabled")
        public volatile boolean isLoadDisabled = false;
    }

    public static enum BackendState {
        using,
        offline,
        free;

    }
}

