/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.clearspring.analytics.util.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.Util;
import org.apache.doris.statistics.ColumnStats;

public class TableStats {
    public static final String ROW_COUNT = "row_count";
    public static final String DATA_SIZE = "data_size";
    private static final Predicate<Long> DESIRED_ROW_COUNT_PRED = v -> v >= -1L;
    private static final Predicate<Long> DESIRED_DATA_SIZE_PRED = v -> v >= -1L;
    private long rowCount = -1L;
    private long dataSize = -1L;
    private Map<String, ColumnStats> nameToColumnStats = Maps.newConcurrentMap();

    public void updateTableStats(Map<String, String> statsNameToValue) throws AnalysisException {
        for (Map.Entry<String, String> entry : statsNameToValue.entrySet()) {
            String statsName = entry.getKey();
            if (statsName.equalsIgnoreCase(ROW_COUNT)) {
                this.rowCount = Util.getLongPropertyOrDefault(entry.getValue(), this.rowCount, DESIRED_ROW_COUNT_PRED, "row_count should >= -1");
                continue;
            }
            if (!statsName.equalsIgnoreCase(DATA_SIZE)) continue;
            this.dataSize = Util.getLongPropertyOrDefault(entry.getValue(), this.dataSize, DESIRED_DATA_SIZE_PRED, "data_size should >= -1");
        }
    }

    public void updateColumnStats(String columnName, Type columnType, Map<String, String> statsNameToValue) throws AnalysisException {
        ColumnStats columnStats = this.nameToColumnStats.get(columnName);
        if (columnStats == null) {
            columnStats = new ColumnStats();
            this.nameToColumnStats.put(columnName, columnStats);
        }
        columnStats.updateStats(columnType, statsNameToValue);
    }

    public List<String> getShowInfo() {
        List result = Lists.newArrayList();
        result.add(Long.toString(this.rowCount));
        result.add(Long.toString(this.dataSize));
        return result;
    }

    public Map<String, ColumnStats> getNameToColumnStats() {
        return this.nameToColumnStats;
    }
}

