/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.clearspring.analytics.util.Lists;
import com.google.common.collect.Queues;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.statistics.StatisticsTask;
import org.apache.doris.statistics.StatisticsTaskResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatisticsTaskScheduler
extends MasterDaemon {
    private static final Logger LOG = LogManager.getLogger(StatisticsTaskScheduler.class);
    private Queue<StatisticsTask> queue = Queues.newLinkedBlockingQueue();

    public StatisticsTaskScheduler() {
        super("Statistics task scheduler", 0L);
    }

    @Override
    protected void runAfterCatalogReady() {
        List<StatisticsTask> tasks = this.peek();
        ExecutorService executor = Executors.newFixedThreadPool(tasks.size());
        List<Future<StatisticsTaskResult>> taskResultList = null;
        try {
            taskResultList = executor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to execute this turn of statistics tasks", (Throwable)e);
        }
        this.handleTaskResult(taskResultList);
        this.remove(tasks.size());
    }

    public void addTasks(List<StatisticsTask> statisticsTaskList) {
        this.queue.addAll(statisticsTaskList);
    }

    private List<StatisticsTask> peek() {
        StatisticsTask task;
        List tasks = Lists.newArrayList();
        for (int i = Config.cbo_concurrency_statistics_task_num; i > 0 && (task = this.queue.peek()) != null; --i) {
            tasks.add(task);
        }
        return tasks;
    }

    private void remove(int size) {
    }

    private void handleTaskResult(List<Future<StatisticsTaskResult>> taskResultLists) {
    }
}

