/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.clearspring.analytics.util.Lists;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.AlterColumnStatsStmt;
import org.apache.doris.analysis.AlterTableStatsStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.statistics.ColumnStats;
import org.apache.doris.statistics.Statistics;
import org.apache.doris.statistics.TableStats;

public class StatisticsManager {
    private Statistics statistics = new Statistics();

    public void alterTableStatistics(AlterTableStatsStmt stmt) throws AnalysisException {
        Table table = this.validateTableName(stmt.getTableName());
        this.statistics.updateTableStats(table.getId(), stmt.getProperties());
    }

    public void alterColumnStatistics(AlterColumnStatsStmt stmt) throws AnalysisException {
        String columnName;
        Table table = this.validateTableName(stmt.getTableName());
        Column column = table.getColumn(columnName = stmt.getColumnName());
        if (column == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_BAD_FIELD_ERROR, columnName, table.getName());
        }
        this.statistics.updateColumnStats(table.getId(), columnName, column.getType(), stmt.getProperties());
    }

    public List<List<String>> showTableStatsList(String dbName, String tableName) throws AnalysisException {
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(dbName);
        List result = Lists.newArrayList();
        if (tableName != null) {
            Table table = db.getTableOrAnalysisException(tableName);
            if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tableName, PrivPredicate.SHOW)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW CREATE TABLE", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbName + ": " + tableName);
            }
            result.add(this.showTableStats(table));
        } else {
            for (Table table : db.getTables()) {
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, table.getName(), PrivPredicate.SHOW)) continue;
                try {
                    result.add(this.showTableStats(table));
                }
                catch (AnalysisException analysisException) {}
            }
        }
        return result;
    }

    public List<List<String>> showColumnStatsList(TableName tableName) throws AnalysisException {
        Table table = this.validateTableName(tableName);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), tableName.getDb(), tableName.getTbl(), PrivPredicate.SHOW)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SHOW CREATE TABLE", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), tableName.getDb() + ": " + tableName.getTbl());
        }
        List result = Lists.newArrayList();
        Map<String, ColumnStats> nameToColumnStats = this.statistics.getColumnStats(table.getId());
        if (nameToColumnStats == null) {
            throw new AnalysisException("There is no column statistics in this table:" + table.getName());
        }
        for (Map.Entry<String, ColumnStats> entry : nameToColumnStats.entrySet()) {
            List row = Lists.newArrayList();
            row.add(entry.getKey());
            row.addAll(entry.getValue().getShowInfo());
            result.add(row);
        }
        return result;
    }

    private List<String> showTableStats(Table table) throws AnalysisException {
        TableStats tableStats = this.statistics.getTableStats(table.getId());
        if (tableStats == null) {
            throw new AnalysisException("There is no statistics in this table:" + table.getName());
        }
        List row = Lists.newArrayList();
        row.add(table.getName());
        row.addAll(tableStats.getShowInfo());
        return row;
    }

    private Table validateTableName(TableName dbTableName) throws AnalysisException {
        String dbName = dbTableName.getDb();
        String tableName = dbTableName.getTbl();
        Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(dbName);
        Table table = db.getTableOrAnalysisException(tableName);
        return table;
    }
}

