/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.util.MasterDaemon;
import org.apache.doris.statistics.StatisticsJob;
import org.apache.doris.statistics.StatisticsTask;

public class StatisticsJobScheduler
extends MasterDaemon {
    public Queue<StatisticsJob> pendingJobQueue = Queues.newLinkedBlockingQueue();

    public StatisticsJobScheduler() {
        super("Statistics job scheduler", 0L);
    }

    @Override
    protected void runAfterCatalogReady() {
        StatisticsJob pendingJob = this.pendingJobQueue.peek();
        List<StatisticsTask> statisticsTaskList = this.divide(pendingJob);
        Catalog.getCurrentCatalog().getStatisticsTaskScheduler().addTasks(statisticsTaskList);
    }

    public void addPendingJob(StatisticsJob statisticsJob) throws IllegalStateException {
        this.pendingJobQueue.add(statisticsJob);
    }

    private List<StatisticsTask> divide(StatisticsJob statisticsJob) {
        return new ArrayList<StatisticsTask>();
    }
}

