/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.AnalyzeStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.statistics.StatisticsJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatisticsJobManager {
    private static final Logger LOG = LogManager.getLogger(StatisticsJobManager.class);
    private Map<Long, StatisticsJob> idToStatisticsJob = Maps.newConcurrentMap();

    public void createStatisticsJob(AnalyzeStmt analyzeStmt) {
        StatisticsJob statisticsJob = StatisticsJob.fromAnalyzeStmt(analyzeStmt);
        Set<Long> tableIdList = statisticsJob.relatedTableId();
        this.checkRestrict(tableIdList);
        this.checkPermission();
        this.createStatisticsJob(statisticsJob);
    }

    public void createStatisticsJob(StatisticsJob statisticsJob) {
        this.idToStatisticsJob.put(statisticsJob.getId(), statisticsJob);
        try {
            Catalog.getCurrentCatalog().getStatisticsJobScheduler().addPendingJob(statisticsJob);
        }
        catch (IllegalStateException e) {
            LOG.info("The pending statistics job is full. Please submit it again later.");
        }
    }

    private void checkRestrict(Set<Long> tableIdList) {
    }

    private void checkPermission() {
    }
}

