/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.statistics.ColumnStats;
import org.apache.doris.statistics.TableStats;

public class Statistics {
    private Map<Long, TableStats> idToTableStats = Maps.newConcurrentMap();

    public void updateTableStats(long tableId, Map<String, String> statsNameToValue) throws AnalysisException {
        TableStats tableStats = this.idToTableStats.get(tableId);
        if (tableStats == null) {
            tableStats = new TableStats();
            this.idToTableStats.put(tableId, tableStats);
        }
        tableStats.updateTableStats(statsNameToValue);
    }

    public void updateColumnStats(long tableId, String columnName, Type columnType, Map<String, String> statsNameToValue) throws AnalysisException {
        TableStats tableStats = this.idToTableStats.get(tableId);
        if (tableStats == null) {
            tableStats = new TableStats();
            this.idToTableStats.put(tableId, tableStats);
        }
        tableStats.updateColumnStats(columnName, columnType, statsNameToValue);
    }

    public TableStats getTableStats(long tableId) {
        return this.idToTableStats.get(tableId);
    }

    public Map<String, ColumnStats> getColumnStats(long tableId) {
        TableStats tableStats = this.getTableStats(tableId);
        if (tableStats == null) {
            return null;
        }
        return tableStats.getNameToColumnStats();
    }
}

