/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.analysis.SelectStmt;
import org.apache.doris.statistics.StatisticsTask;
import org.apache.doris.statistics.StatisticsTaskResult;
import org.apache.doris.statistics.StatsCategoryDesc;
import org.apache.doris.statistics.StatsGranularityDesc;
import org.apache.doris.statistics.StatsType;

public class SQLStatisticsTask
extends StatisticsTask {
    private SelectStmt query;

    public SQLStatisticsTask(long jobId, StatsGranularityDesc granularityDesc, StatsCategoryDesc categoryDesc, List<StatsType> statsTypeList) {
        super(jobId, granularityDesc, categoryDesc, statsTypeList);
    }

    @Override
    public StatisticsTaskResult call() throws Exception {
        this.constructQuery();
        List<String> queryResultList = this.executeQuery(this.query);
        this.constructTaskResult(queryResultList);
        return null;
    }

    protected void constructQuery() {
    }

    protected List<String> executeQuery(SelectStmt query) {
        return null;
    }

    protected StatisticsTaskResult constructTaskResult(List<String> queryResultList) {
        Preconditions.checkState((this.statsTypeList.size() == queryResultList.size() ? 1 : 0) != 0);
        HashMap statsTypeToValue = Maps.newHashMap();
        for (int i = 0; i < this.statsTypeList.size(); ++i) {
            statsTypeToValue.put((StatsType)((Object)this.statsTypeList.get(i)), queryResultList.get(i));
        }
        StatisticsTaskResult result = new StatisticsTaskResult(this.granularityDesc, this.categoryDesc, statsTypeToValue);
        return result;
    }
}

