/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.statistics;

import com.clearspring.analytics.util.Lists;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.Util;

public class ColumnStats {
    public static final String NDV = "ndv";
    public static final String AVG_SIZE = "avg_size";
    public static final String MAX_SIZE = "max_size";
    public static final String NUM_NULLS = "num_nulls";
    public static final String MIN_VALUE = "min_value";
    public static final String MAX_VALUE = "max_value";
    private static final Predicate<Long> DESIRED_NDV_PRED = v -> v >= -1L;
    private static final Predicate<Float> DESIRED_AVG_SIZE_PRED = v -> v.floatValue() == -1.0f || v.floatValue() >= 0.0f;
    private static final Predicate<Long> DESIRED_MAX_SIZE_PRED = v -> v >= -1L;
    private static final Predicate<Long> DESIRED_NUM_NULLS_PRED = v -> v >= -1L;
    private long ndv = -1L;
    private float avgSize = -1.0f;
    private long maxSize = -1L;
    private long numNulls = -1L;
    private LiteralExpr minValue;
    private LiteralExpr maxValue;

    public void updateStats(Type columnType, Map<String, String> statsNameToValue) throws AnalysisException {
        for (Map.Entry<String, String> entry : statsNameToValue.entrySet()) {
            String statsName = entry.getKey();
            if (statsName.equalsIgnoreCase(NDV)) {
                this.ndv = Util.getLongPropertyOrDefault(entry.getValue(), this.ndv, DESIRED_NDV_PRED, "ndv should >= -1");
                continue;
            }
            if (statsName.equalsIgnoreCase(AVG_SIZE)) {
                this.avgSize = Util.getFloatPropertyOrDefault(entry.getValue(), this.avgSize, DESIRED_AVG_SIZE_PRED, "avg_size should (>=0) or (=-1)");
                continue;
            }
            if (statsName.equalsIgnoreCase(MAX_SIZE)) {
                this.maxSize = Util.getLongPropertyOrDefault(entry.getValue(), this.maxSize, DESIRED_MAX_SIZE_PRED, "max_size should >=-1");
                continue;
            }
            if (statsName.equalsIgnoreCase(NUM_NULLS)) {
                this.numNulls = Util.getLongPropertyOrDefault(entry.getValue(), this.numNulls, DESIRED_NUM_NULLS_PRED, "num_nulls should >=-1");
                continue;
            }
            if (statsName.equalsIgnoreCase(MIN_VALUE)) {
                this.minValue = this.validateColumnValue(columnType, entry.getValue());
                continue;
            }
            if (!statsName.equalsIgnoreCase(MAX_VALUE)) continue;
            this.maxValue = this.validateColumnValue(columnType, entry.getValue());
        }
    }

    public List<String> getShowInfo() {
        List result = Lists.newArrayList();
        result.add(Long.toString(this.ndv));
        result.add(Float.toString(this.avgSize));
        result.add(Long.toString(this.maxSize));
        result.add(Long.toString(this.numNulls));
        if (this.minValue != null) {
            result.add(this.minValue.getStringValue());
        } else {
            result.add("N/A");
        }
        if (this.maxValue != null) {
            result.add(this.maxValue.getStringValue());
        } else {
            result.add("N/A");
        }
        return result;
    }

    private LiteralExpr validateColumnValue(Type type, String columnValue) throws AnalysisException {
        Preconditions.checkArgument((boolean)type.isScalarType());
        ScalarType scalarType = (ScalarType)type;
        PrimitiveType primitiveType = scalarType.getPrimitiveType();
        switch (primitiveType) {
            case BOOLEAN: {
                return new BoolLiteral(columnValue);
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return new IntLiteral(columnValue, type);
            }
            case LARGEINT: {
                return new LargeIntLiteral(columnValue);
            }
            case FLOAT: 
            case DOUBLE: {
                return new FloatLiteral(columnValue);
            }
            case DECIMALV2: {
                DecimalLiteral decimalLiteral = new DecimalLiteral(columnValue);
                decimalLiteral.checkPrecisionAndScale(scalarType.getScalarPrecision(), scalarType.getScalarScale());
                return decimalLiteral;
            }
            case DATE: 
            case DATETIME: {
                return new DateLiteral(columnValue, type);
            }
            case CHAR: 
            case VARCHAR: {
                if (columnValue.length() > scalarType.getLength()) {
                    throw new AnalysisException("Min/Max value is longer than length of column type: " + columnValue);
                }
                return new StringLiteral(columnValue);
            }
        }
        throw new AnalysisException("Unsupported setting this type: " + type + " of min max value");
    }
}

