/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.service;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.doris.analysis.SetType;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.AuthenticationException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.Config;
import org.apache.doris.common.DuplicatedRequestException;
import org.apache.doris.common.LabelAlreadyUsedException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.ThriftServerContext;
import org.apache.doris.common.ThriftServerEventProcessor;
import org.apache.doris.common.UserException;
import org.apache.doris.load.EtlStatus;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.MiniEtlTaskInfo;
import org.apache.doris.master.MasterImpl;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.planner.StreamLoadPlanner;
import org.apache.doris.plugin.AuditEvent;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.qe.ConnectProcessor;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.qe.VariableMgr;
import org.apache.doris.service.ExecuteEnv;
import org.apache.doris.service.FrontendOptions;
import org.apache.doris.system.Frontend;
import org.apache.doris.task.StreamLoadTask;
import org.apache.doris.thrift.FrontendService;
import org.apache.doris.thrift.FrontendServiceVersion;
import org.apache.doris.thrift.TColumnDef;
import org.apache.doris.thrift.TColumnDesc;
import org.apache.doris.thrift.TDescribeTableParams;
import org.apache.doris.thrift.TDescribeTableResult;
import org.apache.doris.thrift.TExecPlanFragmentParams;
import org.apache.doris.thrift.TFeResult;
import org.apache.doris.thrift.TFetchResourceResult;
import org.apache.doris.thrift.TFinishTaskRequest;
import org.apache.doris.thrift.TFrontendPingFrontendRequest;
import org.apache.doris.thrift.TFrontendPingFrontendResult;
import org.apache.doris.thrift.TFrontendPingFrontendStatusCode;
import org.apache.doris.thrift.TGetDbsParams;
import org.apache.doris.thrift.TGetDbsResult;
import org.apache.doris.thrift.TGetTablesParams;
import org.apache.doris.thrift.TGetTablesResult;
import org.apache.doris.thrift.TIsMethodSupportedRequest;
import org.apache.doris.thrift.TListPrivilegesResult;
import org.apache.doris.thrift.TListTableStatusResult;
import org.apache.doris.thrift.TLoadCheckRequest;
import org.apache.doris.thrift.TLoadTxn2PCRequest;
import org.apache.doris.thrift.TLoadTxn2PCResult;
import org.apache.doris.thrift.TLoadTxnBeginRequest;
import org.apache.doris.thrift.TLoadTxnBeginResult;
import org.apache.doris.thrift.TLoadTxnCommitRequest;
import org.apache.doris.thrift.TLoadTxnCommitResult;
import org.apache.doris.thrift.TLoadTxnRollbackRequest;
import org.apache.doris.thrift.TLoadTxnRollbackResult;
import org.apache.doris.thrift.TMasterOpRequest;
import org.apache.doris.thrift.TMasterOpResult;
import org.apache.doris.thrift.TMasterResult;
import org.apache.doris.thrift.TMiniLoadBeginRequest;
import org.apache.doris.thrift.TMiniLoadBeginResult;
import org.apache.doris.thrift.TMiniLoadEtlStatusResult;
import org.apache.doris.thrift.TMiniLoadRequest;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TReportExecStatusParams;
import org.apache.doris.thrift.TReportExecStatusResult;
import org.apache.doris.thrift.TReportRequest;
import org.apache.doris.thrift.TShowVariableRequest;
import org.apache.doris.thrift.TShowVariableResult;
import org.apache.doris.thrift.TSnapshotLoaderReportRequest;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TStatusCode;
import org.apache.doris.thrift.TStreamLoadPutRequest;
import org.apache.doris.thrift.TStreamLoadPutResult;
import org.apache.doris.thrift.TTableStatus;
import org.apache.doris.thrift.TUniqueId;
import org.apache.doris.thrift.TUpdateExportTaskStatusRequest;
import org.apache.doris.thrift.TUpdateMiniEtlTaskStatusRequest;
import org.apache.doris.thrift.TWaitingTxnStatusRequest;
import org.apache.doris.thrift.TWaitingTxnStatusResult;
import org.apache.doris.transaction.DatabaseTransactionMgr;
import org.apache.doris.transaction.TabletCommitInfo;
import org.apache.doris.transaction.TransactionState;
import org.apache.doris.transaction.TxnCommitAttachment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;

public class FrontendServiceImpl
implements FrontendService.Iface {
    private static final Logger LOG = LogManager.getLogger(FrontendServiceImpl.class);
    private MasterImpl masterImpl = new MasterImpl();
    private ExecuteEnv exeEnv;

    public FrontendServiceImpl(ExecuteEnv exeEnv) {
        this.exeEnv = exeEnv;
    }

    public TGetDbsResult getDbNames(TGetDbsParams params) throws TException {
        LOG.debug("get db request: {}", (Object)params);
        TGetDbsResult result = new TGetDbsResult();
        ArrayList dbs = Lists.newArrayList();
        PatternMatcher matcher = null;
        if (params.isSetPattern()) {
            try {
                matcher = PatternMatcher.createMysqlPattern(params.getPattern(), CaseSensibility.DATABASE.getCaseSensibility());
            }
            catch (AnalysisException e) {
                throw new TException("Pattern is in bad format: " + params.getPattern());
            }
        }
        Catalog catalog = Catalog.getCurrentCatalog();
        List<String> dbNames = catalog.getDbNames();
        LOG.debug("get db names: {}", dbNames);
        UserIdentity currentUser = null;
        currentUser = params.isSetCurrentUserIdent() ? UserIdentity.fromThrift(params.current_user_ident) : UserIdentity.createAnalyzedUserIdentWithIp(params.user, params.user_ip);
        for (String fullName : dbNames) {
            if (!catalog.getAuth().checkDbPriv(currentUser, fullName, PrivPredicate.SHOW)) continue;
            String db = ClusterNamespace.getNameFromFullName(fullName);
            if (matcher != null && !matcher.match(db)) continue;
            dbs.add(fullName);
        }
        result.setDbs((List)dbs);
        return result;
    }

    public TGetTablesResult getTableNames(TGetTablesParams params) throws TException {
        LOG.debug("get table name request: {}", (Object)params);
        TGetTablesResult result = new TGetTablesResult();
        ArrayList tablesResult = Lists.newArrayList();
        result.setTables((List)tablesResult);
        PatternMatcher matcher = null;
        if (params.isSetPattern()) {
            try {
                matcher = PatternMatcher.createMysqlPattern(params.getPattern(), CaseSensibility.TABLE.getCaseSensibility());
            }
            catch (AnalysisException e) {
                throw new TException("Pattern is in bad format: " + params.getPattern());
            }
        }
        UserIdentity currentUser = params.isSetCurrentUserIdent() ? UserIdentity.fromThrift(params.current_user_ident) : UserIdentity.createAnalyzedUserIdentWithIp(params.user, params.user_ip);
        Database db = Catalog.getCurrentCatalog().getDbNullable(params.db);
        if (db != null) {
            for (String tableName : db.getTableNamesWithLock()) {
                LOG.debug("get table: {}, wait to check", (Object)tableName);
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(currentUser, params.db, tableName, PrivPredicate.SHOW) || matcher != null && !matcher.match(tableName)) continue;
                tablesResult.add(tableName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TListTableStatusResult listTableStatus(TGetTablesParams params) throws TException {
        LOG.debug("get list table request: {}", (Object)params);
        TListTableStatusResult result = new TListTableStatusResult();
        ArrayList tablesResult = Lists.newArrayList();
        result.setTables((List)tablesResult);
        PatternMatcher matcher = null;
        if (params.isSetPattern()) {
            try {
                matcher = PatternMatcher.createMysqlPattern(params.getPattern(), CaseSensibility.TABLE.getCaseSensibility());
            }
            catch (AnalysisException e) {
                throw new TException("Pattern is in bad format " + params.getPattern());
            }
        }
        UserIdentity currentUser = params.isSetCurrentUserIdent() ? UserIdentity.fromThrift(params.current_user_ident) : UserIdentity.createAnalyzedUserIdentWithIp(params.user, params.user_ip);
        Database db = Catalog.getCurrentCatalog().getDbNullable(params.db);
        if (db != null) {
            List<Table> tables = null;
            if (!params.isSetType() || params.getType() == null || params.getType().isEmpty()) {
                tables = db.getTables();
            } else {
                switch (params.getType()) {
                    case "VIEW": {
                        tables = db.getViews();
                        break;
                    }
                    default: {
                        tables = db.getTables();
                    }
                }
            }
            for (Table table : tables) {
                if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(currentUser, params.db, table.getName(), PrivPredicate.SHOW)) continue;
                table.readLock();
                try {
                    if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(currentUser, params.db, table.getName(), PrivPredicate.SHOW) || matcher != null && !matcher.match(table.getName())) continue;
                    TTableStatus status = new TTableStatus();
                    status.setName(table.getName());
                    status.setType(table.getMysqlType());
                    status.setEngine(table.getEngine());
                    status.setComment(table.getComment());
                    status.setCreateTime(table.getCreateTime());
                    status.setLastCheckTime(table.getLastCheckTime());
                    status.setUpdateTime(table.getUpdateTime() / 1000L);
                    status.setCheckTime(table.getLastCheckTime());
                    status.setCollation("utf-8");
                    status.setRows(table.getRowCount());
                    status.setDataLength(table.getDataLength());
                    status.setAvgRowLength(table.getAvgRowLength());
                    tablesResult.add(status);
                }
                finally {
                    table.readUnlock();
                }
            }
        }
        return result;
    }

    public TListPrivilegesResult listTablePrivilegeStatus(TGetTablesParams params) throws TException {
        LOG.debug("get list table privileges request: {}", (Object)params);
        TListPrivilegesResult result = new TListPrivilegesResult();
        ArrayList tblPrivResult = Lists.newArrayList();
        result.setPrivileges((List)tblPrivResult);
        UserIdentity currentUser = null;
        currentUser = params.isSetCurrentUserIdent() ? UserIdentity.fromThrift(params.current_user_ident) : UserIdentity.createAnalyzedUserIdentWithIp(params.user, params.user_ip);
        Catalog.getCurrentCatalog().getAuth().getTablePrivStatus(tblPrivResult, currentUser);
        return result;
    }

    public TListPrivilegesResult listSchemaPrivilegeStatus(TGetTablesParams params) throws TException {
        LOG.debug("get list schema privileges request: {}", (Object)params);
        TListPrivilegesResult result = new TListPrivilegesResult();
        ArrayList tblPrivResult = Lists.newArrayList();
        result.setPrivileges((List)tblPrivResult);
        UserIdentity currentUser = null;
        currentUser = params.isSetCurrentUserIdent() ? UserIdentity.fromThrift(params.current_user_ident) : UserIdentity.createAnalyzedUserIdentWithIp(params.user, params.user_ip);
        Catalog.getCurrentCatalog().getAuth().getSchemaPrivStatus(tblPrivResult, currentUser);
        return result;
    }

    public TListPrivilegesResult listUserPrivilegeStatus(TGetTablesParams params) throws TException {
        LOG.debug("get list user privileges request: {}", (Object)params);
        TListPrivilegesResult result = new TListPrivilegesResult();
        ArrayList userPrivResult = Lists.newArrayList();
        result.setPrivileges((List)userPrivResult);
        UserIdentity currentUser = null;
        currentUser = params.isSetCurrentUserIdent() ? UserIdentity.fromThrift(params.current_user_ident) : UserIdentity.createAnalyzedUserIdentWithIp(params.user, params.user_ip);
        Catalog.getCurrentCatalog().getAuth().getGlobalPrivStatus(userPrivResult, currentUser);
        return result;
    }

    public TFeResult updateExportTaskStatus(TUpdateExportTaskStatusRequest request) throws TException {
        TStatus status = new TStatus(TStatusCode.OK);
        TFeResult result = new TFeResult(FrontendServiceVersion.V1, status);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDescribeTableResult describeTable(TDescribeTableParams params) throws TException {
        Table table;
        LOG.debug("get desc table request: {}", (Object)params);
        TDescribeTableResult result = new TDescribeTableResult();
        ArrayList columns = Lists.newArrayList();
        result.setColumns((List)columns);
        UserIdentity currentUser = null;
        currentUser = params.isSetCurrentUserIdent() ? UserIdentity.fromThrift(params.current_user_ident) : UserIdentity.createAnalyzedUserIdentWithIp(params.user, params.user_ip);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(currentUser, params.db, params.getTableName(), PrivPredicate.SHOW)) {
            return result;
        }
        Database db = Catalog.getCurrentCatalog().getDbNullable(params.db);
        if (db != null && (table = db.getTableNullable(params.getTableName())) != null) {
            table.readLock();
            try {
                for (Column column : table.getBaseSchema()) {
                    Integer decimalDigits;
                    Integer columnLength;
                    TColumnDesc desc = new TColumnDesc(column.getName(), column.getDataType().toThrift());
                    Integer precision = column.getOriginType().getPrecision();
                    if (precision != null) {
                        desc.setColumnPrecision(precision.intValue());
                    }
                    if ((columnLength = column.getOriginType().getColumnSize()) != null) {
                        desc.setColumnLength(columnLength.intValue());
                    }
                    if ((decimalDigits = column.getOriginType().getDecimalDigits()) != null) {
                        desc.setColumnScale(decimalDigits.intValue());
                    }
                    desc.setIsAllowNull(column.isAllowNull());
                    TColumnDef colDef = new TColumnDef(desc);
                    String comment = column.getComment();
                    if (comment != null) {
                        colDef.setComment(comment);
                    }
                    columns.add(colDef);
                }
            }
            finally {
                table.readUnlock();
            }
        }
        return result;
    }

    public TShowVariableResult showVariables(TShowVariableRequest params) throws TException {
        TShowVariableResult result = new TShowVariableResult();
        HashMap map = Maps.newHashMap();
        result.setVariables((Map)map);
        ConnectContext ctx = this.exeEnv.getScheduler().getContext((int)params.getThreadId());
        if (ctx == null) {
            return result;
        }
        List<List<String>> rows = VariableMgr.dump(SetType.fromThrift(params.getVarType()), ctx.getSessionVariable(), null);
        for (List<String> row : rows) {
            map.put(row.get(0), row.get(1));
        }
        return result;
    }

    public TReportExecStatusResult reportExecStatus(TReportExecStatusParams params) throws TException {
        return QeProcessorImpl.INSTANCE.reportExecStatus(params, this.getClientAddr());
    }

    public TMasterResult finishTask(TFinishTaskRequest request) throws TException {
        return this.masterImpl.finishTask(request);
    }

    public TMasterResult report(TReportRequest request) throws TException {
        return this.masterImpl.report(request);
    }

    public TFetchResourceResult fetchResource() throws TException {
        return this.masterImpl.fetchResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public TFeResult miniLoad(TMiniLoadRequest request) throws TException {
        LOG.debug("receive mini load request: label: {}, db: {}, tbl: {}, backend: {}", (Object)request.getLabel(), (Object)request.getDb(), (Object)request.getTbl(), (Object)request.getBackend());
        ConnectContext context = new ConnectContext(null);
        String cluster = "default_cluster";
        if (request.isSetCluster()) {
            cluster = request.cluster;
        }
        String fullDbName = ClusterNamespace.getFullName(cluster, request.db);
        request.setDb(fullDbName);
        context.setCluster(cluster);
        context.setDatabase(ClusterNamespace.getFullName(cluster, request.db));
        context.setQualifiedUser(ClusterNamespace.getFullName(cluster, request.user));
        context.setCatalog(Catalog.getCurrentCatalog());
        context.getState().reset();
        context.setThreadLocalInfo();
        TStatus status = new TStatus(TStatusCode.OK);
        TFeResult result = new TFeResult(FrontendServiceVersion.V1, status);
        try {
            if (request.isSetSubLabel()) {
                ExecuteEnv.getInstance().getMultiLoadMgr().load(request);
            } else if (Catalog.getCurrentCatalog().getLoadManager().createLoadJobV1FromRequest(request)) {
                try {
                    this.logMiniLoadStmt(request);
                }
                catch (Exception e) {
                    LOG.warn("failed log mini load stmt", (Throwable)e);
                }
            }
        }
        catch (UserException e) {
            LOG.warn("add mini load error: {}", (Object)e.getMessage());
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("unexpected exception when adding mini load", e);
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
        }
        finally {
            ConnectContext.remove();
        }
        LOG.debug("mini load result: {}", (Object)result);
        return result;
    }

    private void logMiniLoadStmt(TMiniLoadRequest request) throws UnknownHostException {
        String stmt = this.getMiniLoadStmt(request);
        AuditEvent auditEvent = new AuditEvent.AuditEventBuilder().setEventType(AuditEvent.EventType.AFTER_QUERY).setClientIp(request.user_ip + ":0").setUser(request.user).setDb(request.db).setState(TStatusCode.OK.name()).setQueryTime(0L).setStmt(stmt).build();
        Catalog.getCurrentAuditEventProcessor().handleAuditEvent(auditEvent);
    }

    private String getMiniLoadStmt(TMiniLoadRequest request) throws UnknownHostException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("curl --location-trusted -u user:passwd -T ");
        if (request.files.size() == 1) {
            stringBuilder.append((String)request.files.get(0));
        } else if (request.files.size() > 1) {
            stringBuilder.append("\"{").append(Joiner.on((String)",").join((Iterable)request.files)).append("}\"");
        }
        InetAddress masterAddress = FrontendOptions.getLocalHost();
        stringBuilder.append(" http://").append(masterAddress.getHostAddress()).append(":");
        stringBuilder.append(Config.http_port).append("/api/").append(request.db).append("/");
        stringBuilder.append(request.tbl).append("/_load?label=").append(request.label);
        if (!request.properties.isEmpty()) {
            stringBuilder.append("&");
            ArrayList props = Lists.newArrayList();
            for (Map.Entry entry : request.properties.entrySet()) {
                String prop = (String)entry.getKey() + "=" + (String)entry.getValue();
                props.add(prop);
            }
            stringBuilder.append(Joiner.on((String)"&").join((Iterable)props));
        }
        return stringBuilder.toString();
    }

    public TFeResult updateMiniEtlTaskStatus(TUpdateMiniEtlTaskStatusRequest request) throws TException {
        TFeResult result = new TFeResult();
        result.setProtocolVersion(FrontendServiceVersion.V1);
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        TUniqueId etlTaskId = request.getEtlTaskId();
        long jobId = etlTaskId.getHi();
        long taskId = etlTaskId.getLo();
        LoadJob job = Catalog.getCurrentCatalog().getLoadInstance().getLoadJob(jobId);
        if (job == null) {
            String failMsg = "job does not exist. id: " + jobId;
            LOG.warn(failMsg);
            status.setStatusCode(TStatusCode.CANCELLED);
            status.addToErrorMsgs(failMsg);
            return result;
        }
        MiniEtlTaskInfo taskInfo = job.getMiniEtlTask(taskId);
        if (taskInfo == null) {
            String failMsg = "task info does not exist. task id: " + taskId + ", job id: " + jobId;
            LOG.warn(failMsg);
            status.setStatusCode(TStatusCode.CANCELLED);
            status.addToErrorMsgs(failMsg);
            return result;
        }
        TMiniLoadEtlStatusResult statusResult = request.getEtlTaskStatus();
        LOG.debug("load job id: {}, etl task id: {}, status: {}", (Object)jobId, (Object)taskId, (Object)statusResult);
        EtlStatus taskStatus = taskInfo.getTaskStatus();
        if (taskStatus.setState(statusResult.getEtlState())) {
            if (statusResult.isSetCounters()) {
                taskStatus.setCounters(statusResult.getCounters());
            }
            if (statusResult.isSetTrackingUrl()) {
                taskStatus.setTrackingUrl(statusResult.getTrackingUrl());
            }
            if (statusResult.isSetFileMap()) {
                taskStatus.setFileMap(statusResult.getFileMap());
            }
        }
        return result;
    }

    public TMiniLoadBeginResult miniLoadBegin(TMiniLoadBeginRequest request) throws TException {
        LOG.debug("receive mini load begin request. label: {}, user: {}, ip: {}", (Object)request.getLabel(), (Object)request.getUser(), (Object)request.getUserIp());
        TMiniLoadBeginResult result = new TMiniLoadBeginResult();
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        try {
            String cluster = "default_cluster";
            if (request.isSetCluster()) {
                cluster = request.cluster;
            }
            this.checkPasswordAndPrivs(cluster, request.getUser(), request.getPasswd(), request.getDb(), request.getTbl(), request.getUserIp(), PrivPredicate.LOAD);
            if (!request.isSetSubLabel()) {
                result.setTxnId(Catalog.getCurrentCatalog().getLoadManager().createLoadJobFromMiniLoad(request));
            }
            return result;
        }
        catch (UserException e) {
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
            return result;
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
    }

    public TFeResult isMethodSupported(TIsMethodSupportedRequest request) throws TException {
        TStatus status = new TStatus(TStatusCode.OK);
        TFeResult result = new TFeResult(FrontendServiceVersion.V1, status);
        switch (request.getFunctionName()) {
            case "STREAMING_MINI_LOAD": {
                break;
            }
            default: {
                status.setStatusCode(TStatusCode.NOT_IMPLEMENTED_ERROR);
            }
        }
        return result;
    }

    public TMasterOpResult forward(TMasterOpRequest params) throws TException {
        Frontend fe;
        TNetworkAddress clientAddr = this.getClientAddr();
        if (clientAddr != null && (fe = Catalog.getCurrentCatalog().getFeByHost(clientAddr.getHostname())) == null) {
            LOG.warn("reject request from invalid host. client: {}", (Object)clientAddr);
            throw new TException("request from invalid host was rejected.");
        }
        LOG.debug("receive forwarded stmt {} from FE: {}", (Object)params.getStmtId(), (Object)clientAddr.getHostname());
        ConnectContext context = new ConnectContext(null);
        context.setCurrentConnectedFEIp(clientAddr.getHostname());
        ConnectProcessor processor = new ConnectProcessor(context);
        TMasterOpResult result = processor.proxyExecute(params);
        ConnectContext.remove();
        return result;
    }

    private void checkAuthCodeUuid(String dbName, long txnId, String authCodeUuid) throws AuthenticationException {
        Database db = Catalog.getCurrentCatalog().getDbOrException(dbName, s -> new AuthenticationException("invalid db name: " + s));
        TransactionState transactionState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(db.getId(), txnId);
        if (transactionState == null) {
            throw new AuthenticationException("invalid transactionState: " + txnId);
        }
        if (!authCodeUuid.equals(transactionState.getAuthCode())) {
            throw new AuthenticationException("Access denied; you need (at least one of) the LOAD privilege(s) for this operation");
        }
    }

    private void checkPasswordAndPrivs(String cluster, String user, String passwd, String db, String tbl, String clientIp, PrivPredicate predicate) throws AuthenticationException {
        String fullUserName = ClusterNamespace.getFullName(cluster, user);
        String fullDbName = ClusterNamespace.getFullName(cluster, db);
        ArrayList currentUser = Lists.newArrayList();
        if (!Catalog.getCurrentCatalog().getAuth().checkPlainPassword(fullUserName, clientIp, passwd, currentUser)) {
            throw new AuthenticationException("Access denied for " + fullUserName + "@" + clientIp);
        }
        Preconditions.checkState((currentUser.size() == 1 ? 1 : 0) != 0);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv((UserIdentity)currentUser.get(0), fullDbName, tbl, predicate)) {
            throw new AuthenticationException("Access denied; you need (at least one of) the LOAD privilege(s) for this operation");
        }
    }

    public TFeResult loadCheck(TLoadCheckRequest request) throws TException {
        LOG.debug("receive load check request. label: {}, user: {}, ip: {}", (Object)request.getLabel(), (Object)request.getUser(), (Object)request.getUserIp());
        TStatus status = new TStatus(TStatusCode.OK);
        TFeResult result = new TFeResult(FrontendServiceVersion.V1, status);
        try {
            String cluster = "default_cluster";
            if (request.isSetCluster()) {
                cluster = request.cluster;
            }
            this.checkPasswordAndPrivs(cluster, request.getUser(), request.getPasswd(), request.getDb(), request.getTbl(), request.getUserIp(), PrivPredicate.LOAD);
        }
        catch (UserException e) {
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
            return result;
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
        return result;
    }

    public TLoadTxnBeginResult loadTxnBegin(TLoadTxnBeginRequest request) throws TException {
        String clientAddr = this.getClientAddrAsString();
        LOG.debug("receive txn begin request: {}, backend: {}", (Object)request, (Object)clientAddr);
        TLoadTxnBeginResult result = new TLoadTxnBeginResult();
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        try {
            TLoadTxnBeginResult tmpRes = this.loadTxnBeginImpl(request, clientAddr);
            result.setTxnId(tmpRes.getTxnId()).setDbId(tmpRes.getDbId());
        }
        catch (DuplicatedRequestException e) {
            LOG.warn("duplicate request for stream load. request id: {}, txn: {}", (Object)e.getDuplicatedRequestId(), (Object)e.getTxnId());
            result.setTxnId(e.getTxnId());
        }
        catch (LabelAlreadyUsedException e) {
            status.setStatusCode(TStatusCode.LABEL_ALREADY_EXISTS);
            status.addToErrorMsgs(e.getMessage());
            result.setJobStatus(e.getJobStatus());
        }
        catch (UserException e) {
            LOG.warn("failed to begin: {}", (Object)e.getMessage());
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
        return result;
    }

    private TLoadTxnBeginResult loadTxnBeginImpl(TLoadTxnBeginRequest request, String clientIp) throws UserException {
        String fullDbName;
        String cluster = request.getCluster();
        if (Strings.isNullOrEmpty((String)cluster)) {
            cluster = "default_cluster";
        }
        if (Strings.isNullOrEmpty((String)request.getAuthCodeUuid())) {
            this.checkPasswordAndPrivs(cluster, request.getUser(), request.getPasswd(), request.getDb(), request.getTbl(), request.getUserIp(), PrivPredicate.LOAD);
        }
        if (Strings.isNullOrEmpty((String)request.getLabel())) {
            throw new UserException("empty label in begin request");
        }
        Catalog catalog = Catalog.getCurrentCatalog();
        Database db = catalog.getDbNullable(fullDbName = ClusterNamespace.getFullName(cluster, request.getDb()));
        if (db == null) {
            String dbName = fullDbName;
            if (Strings.isNullOrEmpty((String)request.getCluster())) {
                dbName = request.getDb();
            }
            throw new UserException("unknown database, database=" + dbName);
        }
        Object table = db.getTableOrMetaException(request.tbl, Table.TableType.OLAP);
        long timeoutSecond = request.isSetTimeout() ? request.getTimeout() : (long)Config.stream_load_default_timeout_second;
        MetricRepo.COUNTER_LOAD_ADD.increase(1L);
        long txnId = Catalog.getCurrentGlobalTransactionMgr().beginTransaction(db.getId(), Lists.newArrayList((Object[])new Long[]{((Table)table).getId()}), request.getLabel(), request.getRequestId(), new TransactionState.TxnCoordinator(TransactionState.TxnSourceType.BE, clientIp), TransactionState.LoadJobSourceType.BACKEND_STREAMING, -1L, timeoutSecond);
        if (!Strings.isNullOrEmpty((String)request.getAuthCodeUuid())) {
            Catalog.getCurrentGlobalTransactionMgr().getTransactionState(db.getId(), txnId).setAuthCode(request.getAuthCodeUuid());
        }
        TLoadTxnBeginResult result = new TLoadTxnBeginResult();
        result.setTxnId(txnId).setDbId(db.getId());
        return result;
    }

    public TLoadTxnCommitResult loadTxnPreCommit(TLoadTxnCommitRequest request) throws TException {
        String clientAddr = this.getClientAddrAsString();
        LOG.debug("receive txn pre-commit request: {}, backend: {}", (Object)request, (Object)clientAddr);
        TLoadTxnCommitResult result = new TLoadTxnCommitResult();
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        try {
            this.loadTxnPreCommitImpl(request);
        }
        catch (UserException e) {
            LOG.warn("failed to pre-commit txn: {}: {}", (Object)request.getTxnId(), (Object)e.getMessage());
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
        return result;
    }

    private void loadTxnPreCommitImpl(TLoadTxnCommitRequest request) throws UserException {
        String cluster = request.getCluster();
        if (Strings.isNullOrEmpty((String)cluster)) {
            cluster = "default_cluster";
        }
        if (!request.isSetAuthCode()) {
            if (request.isSetAuthCodeUuid()) {
                this.checkAuthCodeUuid(request.getDb(), request.getTxnId(), request.getAuthCodeUuid());
            } else {
                this.checkPasswordAndPrivs(cluster, request.getUser(), request.getPasswd(), request.getDb(), request.getTbl(), request.getUserIp(), PrivPredicate.LOAD);
            }
        }
        Catalog catalog = Catalog.getCurrentCatalog();
        String fullDbName = ClusterNamespace.getFullName(cluster, request.getDb());
        Database db = request.isSetDbId() && request.getDbId() > 0L ? catalog.getDbNullable(request.getDbId()) : catalog.getDbNullable(fullDbName);
        if (db == null) {
            String dbName = fullDbName;
            if (Strings.isNullOrEmpty((String)request.getCluster())) {
                dbName = request.getDb();
            }
            throw new UserException("unknown database, database=" + dbName);
        }
        long timeoutMs = request.isSetThriftRpcTimeoutMs() ? request.getThriftRpcTimeoutMs() / 2L : 5000L;
        Object table = db.getTableOrMetaException(request.getTbl(), Table.TableType.OLAP);
        Catalog.getCurrentGlobalTransactionMgr().preCommitTransaction2PC(db, Lists.newArrayList((Object[])new Table[]{table}), request.getTxnId(), TabletCommitInfo.fromThrift(request.getCommitInfos()), timeoutMs, TxnCommitAttachment.fromThrift(request.txnCommitAttachment));
    }

    public TLoadTxn2PCResult loadTxn2PC(TLoadTxn2PCRequest request) throws TException {
        String clientAddr = this.getClientAddrAsString();
        LOG.debug("receive txn 2PC request: {}, backend: {}", (Object)request, (Object)clientAddr);
        TLoadTxn2PCResult result = new TLoadTxn2PCResult();
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        try {
            this.loadTxn2PCImpl(request);
        }
        catch (UserException e) {
            LOG.warn("failed to {} txn {}: {}", (Object)request.getOperation(), (Object)request.getTxnId(), (Object)e.getMessage());
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
        return result;
    }

    private void loadTxn2PCImpl(TLoadTxn2PCRequest request) throws UserException {
        String dbName;
        String cluster = request.getCluster();
        if (Strings.isNullOrEmpty((String)cluster)) {
            cluster = "default_cluster";
        }
        if (Strings.isNullOrEmpty((String)(dbName = request.getDb()))) {
            throw new UserException("No database selected.");
        }
        String fullDbName = ClusterNamespace.getFullName(cluster, dbName);
        Catalog catalog = Catalog.getCurrentCatalog();
        Database database = catalog.getDbNullable(fullDbName);
        if (database == null) {
            throw new UserException("unknown database, database=" + fullDbName);
        }
        DatabaseTransactionMgr dbTransactionMgr = Catalog.getCurrentGlobalTransactionMgr().getDatabaseTransactionMgr(database.getId());
        TransactionState transactionState = dbTransactionMgr.getTransactionState(request.getTxnId());
        if (transactionState == null) {
            throw new UserException("transaction [" + request.getTxnId() + "] not found");
        }
        List<Long> tableIdList = transactionState.getTableIdList();
        List<Table> tableList = database.getTablesOnIdOrderOrThrowException(tableIdList);
        for (Table table : tableList) {
            this.checkPasswordAndPrivs(cluster, request.getUser(), request.getPasswd(), request.getDb(), table.getName(), request.getUserIp(), PrivPredicate.LOAD);
        }
        String txnOperation = request.getOperation().trim();
        if (txnOperation.equalsIgnoreCase("commit")) {
            Catalog.getCurrentGlobalTransactionMgr().commitTransaction2PC(database, tableList, request.getTxnId(), 5000L);
        } else if (txnOperation.equalsIgnoreCase("abort")) {
            Catalog.getCurrentGlobalTransactionMgr().abortTransaction2PC(database.getId(), request.getTxnId());
        } else {
            throw new UserException("transaction operation should be 'commit' or 'abort'");
        }
    }

    public TLoadTxnCommitResult loadTxnCommit(TLoadTxnCommitRequest request) throws TException {
        String clientAddr = this.getClientAddrAsString();
        LOG.debug("receive txn commit request: {}, backend: {}", (Object)request, (Object)clientAddr);
        TLoadTxnCommitResult result = new TLoadTxnCommitResult();
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        try {
            if (!this.loadTxnCommitImpl(request)) {
                status.setStatusCode(TStatusCode.PUBLISH_TIMEOUT);
                status.addToErrorMsgs("transaction commit successfully, BUT data will be visible later");
            }
        }
        catch (UserException e) {
            LOG.warn("failed to commit txn: {}: {}", (Object)request.getTxnId(), (Object)e.getMessage());
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
        return result;
    }

    private boolean loadTxnCommitImpl(TLoadTxnCommitRequest request) throws UserException {
        String cluster = request.getCluster();
        if (Strings.isNullOrEmpty((String)cluster)) {
            cluster = "default_cluster";
        }
        if (!request.isSetAuthCode()) {
            if (request.isSetAuthCodeUuid()) {
                this.checkAuthCodeUuid(request.getDb(), request.getTxnId(), request.getAuthCodeUuid());
            } else {
                this.checkPasswordAndPrivs(cluster, request.getUser(), request.getPasswd(), request.getDb(), request.getTbl(), request.getUserIp(), PrivPredicate.LOAD);
            }
        }
        Catalog catalog = Catalog.getCurrentCatalog();
        String fullDbName = ClusterNamespace.getFullName(cluster, request.getDb());
        Database db = request.isSetDbId() && request.getDbId() > 0L ? catalog.getDbNullable(request.getDbId()) : catalog.getDbNullable(fullDbName);
        if (db == null) {
            String dbName = fullDbName;
            if (Strings.isNullOrEmpty((String)request.getCluster())) {
                dbName = request.getDb();
            }
            throw new UserException("unknown database, database=" + dbName);
        }
        long timeoutMs = request.isSetThriftRpcTimeoutMs() ? request.getThriftRpcTimeoutMs() / 2L : 5000L;
        Object table = db.getTableOrMetaException(request.getTbl(), Table.TableType.OLAP);
        boolean ret = Catalog.getCurrentGlobalTransactionMgr().commitAndPublishTransaction(db, Lists.newArrayList((Object[])new Table[]{table}), request.getTxnId(), TabletCommitInfo.fromThrift(request.getCommitInfos()), timeoutMs, TxnCommitAttachment.fromThrift(request.txnCommitAttachment));
        if (ret) {
            MetricRepo.COUNTER_LOAD_FINISHED.increase(1L);
        }
        return ret;
    }

    public TLoadTxnRollbackResult loadTxnRollback(TLoadTxnRollbackRequest request) throws TException {
        String clientAddr = this.getClientAddrAsString();
        LOG.debug("receive txn rollback request: {}, backend: {}", (Object)request, (Object)clientAddr);
        TLoadTxnRollbackResult result = new TLoadTxnRollbackResult();
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        try {
            this.loadTxnRollbackImpl(request);
        }
        catch (UserException e) {
            LOG.warn("failed to rollback txn {}: {}", (Object)request.getTxnId(), (Object)e.getMessage());
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
        return result;
    }

    private void loadTxnRollbackImpl(TLoadTxnRollbackRequest request) throws UserException {
        String cluster = request.getCluster();
        if (Strings.isNullOrEmpty((String)cluster)) {
            cluster = "default_cluster";
        }
        if (!request.isSetAuthCode()) {
            if (request.isSetAuthCodeUuid()) {
                this.checkAuthCodeUuid(request.getDb(), request.getTxnId(), request.getAuthCodeUuid());
            } else {
                this.checkPasswordAndPrivs(cluster, request.getUser(), request.getPasswd(), request.getDb(), request.getTbl(), request.getUserIp(), PrivPredicate.LOAD);
            }
        }
        String dbName = ClusterNamespace.getFullName(cluster, request.getDb());
        Database db = request.isSetDbId() && request.getDbId() > 0L ? Catalog.getCurrentCatalog().getDbNullable(request.getDbId()) : Catalog.getCurrentCatalog().getDbNullable(dbName);
        if (db == null) {
            throw new MetaNotFoundException("db " + request.getDb() + " does not exist");
        }
        long dbId = db.getId();
        Catalog.getCurrentGlobalTransactionMgr().abortTransaction(dbId, request.getTxnId(), request.isSetReason() ? request.getReason() : "system cancel", TxnCommitAttachment.fromThrift(request.getTxnCommitAttachment()));
    }

    public TStreamLoadPutResult streamLoadPut(TStreamLoadPutRequest request) {
        String clientAddr = this.getClientAddrAsString();
        LOG.debug("receive stream load put request: {}, backend: {}", (Object)request, (Object)clientAddr);
        TStreamLoadPutResult result = new TStreamLoadPutResult();
        TStatus status = new TStatus(TStatusCode.OK);
        result.setStatus(status);
        try {
            result.setParams(this.streamLoadPutImpl(request));
        }
        catch (UserException e) {
            LOG.warn("failed to get stream load plan: {}", (Object)e.getMessage());
            status.setStatusCode(TStatusCode.ANALYSIS_ERROR);
            status.addToErrorMsgs(e.getMessage());
        }
        catch (Throwable e) {
            LOG.warn("catch unknown result.", e);
            status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            status.addToErrorMsgs(Strings.nullToEmpty((String)e.getMessage()));
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TExecPlanFragmentParams streamLoadPutImpl(TStreamLoadPutRequest request) throws UserException {
        String fullDbName;
        Catalog catalog;
        Database db;
        String cluster = request.getCluster();
        if (Strings.isNullOrEmpty((String)cluster)) {
            cluster = "default_cluster";
        }
        if ((db = (catalog = Catalog.getCurrentCatalog()).getDbNullable(fullDbName = ClusterNamespace.getFullName(cluster, request.getDb()))) == null) {
            String dbName = fullDbName;
            if (Strings.isNullOrEmpty((String)request.getCluster())) {
                dbName = request.getDb();
            }
            throw new UserException("unknown database, database=" + dbName);
        }
        long timeoutMs = request.isSetThriftRpcTimeoutMs() ? request.getThriftRpcTimeoutMs() : 5000L;
        Object table = db.getTableOrMetaException(request.getTbl(), Table.TableType.OLAP);
        if (!((Table)table).tryReadLock(timeoutMs, TimeUnit.MILLISECONDS)) {
            throw new UserException("get table read lock timeout, database=" + fullDbName + ",table=" + ((Table)table).getName());
        }
        try {
            StreamLoadTask streamLoadTask = StreamLoadTask.fromTStreamLoadPutRequest(request);
            StreamLoadPlanner planner = new StreamLoadPlanner(db, (OlapTable)table, streamLoadTask);
            TExecPlanFragmentParams plan = planner.plan(streamLoadTask.getId());
            TransactionState txnState = Catalog.getCurrentGlobalTransactionMgr().getTransactionState(db.getId(), request.getTxnId());
            if (txnState == null) {
                throw new UserException("txn does not exist: " + request.getTxnId());
            }
            txnState.addTableIndexes((OlapTable)table);
            TExecPlanFragmentParams tExecPlanFragmentParams = plan;
            return tExecPlanFragmentParams;
        }
        finally {
            ((Table)table).readUnlock();
        }
    }

    public TStatus snapshotLoaderReport(TSnapshotLoaderReportRequest request) throws TException {
        if (Catalog.getCurrentCatalog().getBackupHandler().report(request.getTaskType(), request.getJobId(), request.getTaskId(), request.getFinishedNum(), request.getTotalNum())) {
            return new TStatus(TStatusCode.OK);
        }
        return new TStatus(TStatusCode.CANCELLED);
    }

    public TFrontendPingFrontendResult ping(TFrontendPingFrontendRequest request) throws TException {
        boolean isReady = Catalog.getCurrentCatalog().isReady();
        TFrontendPingFrontendResult result = new TFrontendPingFrontendResult();
        result.setStatus(TFrontendPingFrontendStatusCode.OK);
        if (isReady) {
            if (request.getClusterId() != Catalog.getCurrentCatalog().getClusterId()) {
                result.setStatus(TFrontendPingFrontendStatusCode.FAILED);
                result.setMsg("invalid cluster id: " + Catalog.getCurrentCatalog().getClusterId());
            }
            if (result.getStatus() == TFrontendPingFrontendStatusCode.OK && !request.getToken().equals(Catalog.getCurrentCatalog().getToken())) {
                result.setStatus(TFrontendPingFrontendStatusCode.FAILED);
                result.setMsg("invalid token: " + Catalog.getCurrentCatalog().getToken());
            }
            if (result.status == TFrontendPingFrontendStatusCode.OK) {
                long replayedJournalId = Catalog.getCurrentCatalog().getReplayedJournalId();
                result.setMsg("success");
                result.setReplayedJournalId(replayedJournalId);
                result.setQueryPort(Config.query_port);
                result.setRpcPort(Config.rpc_port);
                result.setVersion("1.1.0-rc05-Unknown");
            }
        } else {
            result.setStatus(TFrontendPingFrontendStatusCode.FAILED);
            result.setMsg("not ready");
        }
        return result;
    }

    private TNetworkAddress getClientAddr() {
        ThriftServerContext connectionContext = ThriftServerEventProcessor.getConnectionContext();
        if (connectionContext != null) {
            return connectionContext.getClient();
        }
        return null;
    }

    private String getClientAddrAsString() {
        TNetworkAddress addr = this.getClientAddr();
        return addr == null ? "unknown" : addr.hostname;
    }

    public TWaitingTxnStatusResult waitingTxnStatus(TWaitingTxnStatusRequest request) throws TException {
        TWaitingTxnStatusResult result = new TWaitingTxnStatusResult();
        result.setStatus(new TStatus());
        try {
            result = Catalog.getCurrentGlobalTransactionMgr().getWaitingTxnStatus(request);
            result.status.setStatusCode(TStatusCode.OK);
        }
        catch (TimeoutException e) {
            result.status.setStatusCode(TStatusCode.INCOMPLETE);
            result.status.addToErrorMsgs(e.getMessage());
        }
        catch (AnalysisException e) {
            result.status.setStatusCode(TStatusCode.INTERNAL_ERROR);
            result.status.addToErrorMsgs(e.getMessage());
        }
        return result;
    }
}

