/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.service;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.doris.common.CIDR;
import org.apache.doris.common.Config;
import org.apache.doris.common.util.NetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrontendOptions {
    private static final Logger LOG = LogManager.getLogger(FrontendOptions.class);
    private static String PRIORITY_CIDR_SEPARATOR = ";";
    private static List<CIDR> priorityCidrs = Lists.newArrayList();
    private static InetAddress localAddr = InetAddress.getLoopbackAddress();

    public static void init() throws UnknownHostException {
        localAddr = null;
        if (!"0.0.0.0".equals(Config.frontend_address)) {
            if (!InetAddressValidator.getInstance().isValidInet4Address(Config.frontend_address)) {
                throw new UnknownHostException("invalid frontend_address: " + Config.frontend_address);
            }
            localAddr = InetAddress.getByName(Config.frontend_address);
            LOG.info("use configured address. {}", (Object)localAddr);
            return;
        }
        FrontendOptions.analyzePriorityCidrs();
        ArrayList<InetAddress> hosts = new ArrayList<InetAddress>();
        NetUtils.getHosts(hosts);
        if (hosts.isEmpty()) {
            LOG.error("fail to get localhost");
            System.exit(-1);
        }
        InetAddress loopBack = null;
        for (InetAddress addr : hosts) {
            LOG.debug("check ip address: {}", (Object)addr);
            if (!(addr instanceof Inet4Address)) continue;
            if (addr.isLoopbackAddress()) {
                loopBack = addr;
                continue;
            }
            if (!priorityCidrs.isEmpty()) {
                if (!FrontendOptions.isInPriorNetwork(addr.getHostAddress())) continue;
                localAddr = addr;
                break;
            }
            localAddr = addr;
            break;
        }
        if (localAddr == null) {
            localAddr = loopBack;
        }
        LOG.info("local address: {}.", (Object)localAddr);
    }

    public static InetAddress getLocalHost() {
        return localAddr;
    }

    public static String getLocalHostAddress() {
        return localAddr.getHostAddress();
    }

    public static String getHostname() {
        return localAddr.getHostName();
    }

    private static void analyzePriorityCidrs() {
        String prior_cidrs = Config.priority_networks;
        if (Strings.isNullOrEmpty((String)prior_cidrs)) {
            return;
        }
        LOG.info("configured prior_cidrs value: {}", (Object)prior_cidrs);
        Object[] cidrList = prior_cidrs.split(PRIORITY_CIDR_SEPARATOR);
        ArrayList priorNetworks = Lists.newArrayList((Object[])cidrList);
        for (String cidrStr : priorNetworks) {
            priorityCidrs.add(new CIDR(cidrStr));
        }
    }

    private static boolean isInPriorNetwork(String ip) {
        for (CIDR cidr : priorityCidrs) {
            if (!cidr.contains(ip)) continue;
            return true;
        }
        return false;
    }
}

