/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rpc;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.doris.common.Config;
import org.apache.doris.proto.InternalService;
import org.apache.doris.proto.Types;
import org.apache.doris.rpc.BackendServiceClient;
import org.apache.doris.rpc.RpcException;
import org.apache.doris.thrift.TExecPlanFragmentParamsList;
import org.apache.doris.thrift.TFoldConstantParams;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class BackendServiceProxy {
    private static final Logger LOG = LogManager.getLogger(BackendServiceProxy.class);
    private ReentrantLock lock = new ReentrantLock();
    private final Map<TNetworkAddress, BackendServiceClient> serviceMap = Maps.newConcurrentMap();

    public static BackendServiceProxy getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void removeProxy(TNetworkAddress address) {
        BackendServiceClient service;
        LOG.warn("begin to remove proxy: {}", (Object)address);
        this.lock.lock();
        try {
            service = this.serviceMap.remove(address);
        }
        finally {
            this.lock.unlock();
        }
        if (service != null) {
            service.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackendServiceClient getProxy(TNetworkAddress address) {
        BackendServiceClient service = this.serviceMap.get(address);
        if (service != null) {
            return service;
        }
        this.lock.lock();
        try {
            service = this.serviceMap.get(address);
            if (service == null) {
                service = new BackendServiceClient(address);
                this.serviceMap.put(address, service);
            }
            BackendServiceClient backendServiceClient = service;
            return backendServiceClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Future<InternalService.PExecPlanFragmentResult> execPlanFragmentsAsync(TNetworkAddress address, TExecPlanFragmentParamsList paramsList, boolean twoPhaseExecution) throws TException, RpcException {
        InternalService.PExecPlanFragmentRequest.Builder builder = InternalService.PExecPlanFragmentRequest.newBuilder();
        if (Config.use_compact_thrift_rpc) {
            builder.setRequest(ByteString.copyFrom((byte[])new TSerializer((TProtocolFactory)new TCompactProtocol.Factory()).serialize((TBase)paramsList)));
            builder.setCompact(true);
        } else {
            builder.setRequest(ByteString.copyFrom((byte[])new TSerializer().serialize((TBase)paramsList))).build();
            builder.setCompact(false);
        }
        builder.setVersion(InternalService.PFragmentRequestVersion.VERSION_2);
        InternalService.PExecPlanFragmentRequest pRequest = builder.build();
        try {
            BackendServiceClient client = this.getProxy(address);
            if (twoPhaseExecution) {
                return client.execPlanFragmentPrepareAsync(pRequest);
            }
            return client.execPlanFragmentAsync(pRequest);
        }
        catch (Throwable e) {
            LOG.warn("Execute plan fragment catch a exception, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PExecPlanFragmentResult> execPlanFragmentStartAsync(TNetworkAddress address, InternalService.PExecPlanFragmentStartRequest request) throws TException, RpcException {
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.execPlanFragmentStartAsync(request);
        }
        catch (Exception e) {
            throw new RpcException(address.hostname, e.getMessage(), e);
        }
    }

    public Future<InternalService.PCancelPlanFragmentResult> cancelPlanFragmentAsync(TNetworkAddress address, TUniqueId finstId, Types.PPlanFragmentCancelReason cancelReason) throws RpcException {
        InternalService.PCancelPlanFragmentRequest pRequest = InternalService.PCancelPlanFragmentRequest.newBuilder().setFinstId(Types.PUniqueId.newBuilder().setHi(finstId.hi).setLo(finstId.lo).build()).setCancelReason(cancelReason).build();
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.cancelPlanFragmentAsync(pRequest);
        }
        catch (Throwable e) {
            LOG.warn("Cancel plan fragment catch a exception, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PFetchDataResult> fetchDataAsync(TNetworkAddress address, InternalService.PFetchDataRequest request) throws RpcException {
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.fetchDataAsync(request);
        }
        catch (Throwable e) {
            LOG.warn("fetch data catch a exception, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public InternalService.PFetchDataResult fetchDataSync(TNetworkAddress address, InternalService.PFetchDataRequest request) throws RpcException {
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.fetchDataSync(request);
        }
        catch (Throwable e) {
            LOG.warn("fetch data catch a exception, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PCacheResponse> updateCache(TNetworkAddress address, InternalService.PUpdateCacheRequest request) throws RpcException {
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.updateCache(request);
        }
        catch (Throwable e) {
            LOG.warn("update cache catch a exception, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PFetchCacheResult> fetchCache(TNetworkAddress address, InternalService.PFetchCacheRequest request) throws RpcException {
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.fetchCache(request);
        }
        catch (Throwable e) {
            LOG.warn("fetch cache catch a exception, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PCacheResponse> clearCache(TNetworkAddress address, InternalService.PClearCacheRequest request) throws RpcException {
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.clearCache(request);
        }
        catch (Throwable e) {
            LOG.warn("clear cache catch a exception, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PProxyResult> getInfo(TNetworkAddress address, InternalService.PProxyRequest request) throws RpcException {
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.getInfo(request);
        }
        catch (Throwable e) {
            LOG.warn("failed to get info, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PSendDataResult> sendData(TNetworkAddress address, Types.PUniqueId fragmentInstanceId, List<InternalService.PDataRow> data) throws RpcException {
        InternalService.PSendDataRequest.Builder pRequest = InternalService.PSendDataRequest.newBuilder();
        pRequest.setFragmentInstanceId(fragmentInstanceId);
        pRequest.addAllData(data);
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.sendData(pRequest.build());
        }
        catch (Throwable e) {
            LOG.warn("failed to send data, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PRollbackResult> rollback(TNetworkAddress address, Types.PUniqueId fragmentInstanceId) throws RpcException {
        InternalService.PRollbackRequest pRequest = InternalService.PRollbackRequest.newBuilder().setFragmentInstanceId(fragmentInstanceId).build();
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.rollback(pRequest);
        }
        catch (Throwable e) {
            LOG.warn("failed to rollback, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PCommitResult> commit(TNetworkAddress address, Types.PUniqueId fragmentInstanceId) throws RpcException {
        InternalService.PCommitRequest pRequest = InternalService.PCommitRequest.newBuilder().setFragmentInstanceId(fragmentInstanceId).build();
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.commit(pRequest);
        }
        catch (Throwable e) {
            LOG.warn("failed to commit, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    public Future<InternalService.PConstantExprResult> foldConstantExpr(TNetworkAddress address, TFoldConstantParams tParams) throws RpcException, TException {
        InternalService.PConstantExprRequest pRequest = InternalService.PConstantExprRequest.newBuilder().setRequest(ByteString.copyFrom((byte[])new TSerializer().serialize((TBase)tParams))).build();
        try {
            BackendServiceClient client = this.getProxy(address);
            return client.foldConstantExpr(pRequest);
        }
        catch (Throwable e) {
            LOG.warn("failed to fold constant expr, address={}:{}", (Object)address.getHostname(), (Object)address.getPort(), (Object)e);
            throw new RpcException(address.hostname, e.getMessage());
        }
    }

    private static class SingletonHolder {
        private static final BackendServiceProxy INSTANCE = new BackendServiceProxy();

        private SingletonHolder() {
        }
    }
}

