/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.doris.common.Config;
import org.apache.doris.proto.InternalService;
import org.apache.doris.proto.PBackendServiceGrpc;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackendServiceClient {
    public static final Logger LOG = LogManager.getLogger(BackendServiceClient.class);
    private static final int MAX_RETRY_NUM = 0;
    private final TNetworkAddress address;
    private final PBackendServiceGrpc.PBackendServiceFutureStub stub;
    private final PBackendServiceGrpc.PBackendServiceBlockingStub blockingStub;
    private final ManagedChannel channel;

    public BackendServiceClient(TNetworkAddress address) {
        this.address = address;
        this.channel = ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)address.getHostname(), (int)address.getPort()).flowControlWindow(Config.grpc_max_message_size_bytes).maxInboundMessageSize(Config.grpc_max_message_size_bytes)).enableRetry()).maxRetryAttempts(0)).usePlaintext().build();
        this.stub = PBackendServiceGrpc.newFutureStub((Channel)this.channel);
        this.blockingStub = PBackendServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public Future<InternalService.PExecPlanFragmentResult> execPlanFragmentAsync(InternalService.PExecPlanFragmentRequest request) {
        return this.stub.execPlanFragment(request);
    }

    public Future<InternalService.PExecPlanFragmentResult> execPlanFragmentPrepareAsync(InternalService.PExecPlanFragmentRequest request) {
        return this.stub.execPlanFragmentPrepare(request);
    }

    public Future<InternalService.PExecPlanFragmentResult> execPlanFragmentStartAsync(InternalService.PExecPlanFragmentStartRequest request) {
        return this.stub.execPlanFragmentStart(request);
    }

    public Future<InternalService.PCancelPlanFragmentResult> cancelPlanFragmentAsync(InternalService.PCancelPlanFragmentRequest request) {
        return this.stub.cancelPlanFragment(request);
    }

    public Future<InternalService.PFetchDataResult> fetchDataAsync(InternalService.PFetchDataRequest request) {
        return this.stub.fetchData(request);
    }

    public InternalService.PFetchDataResult fetchDataSync(InternalService.PFetchDataRequest request) {
        return this.blockingStub.fetchData(request);
    }

    public Future<InternalService.PCacheResponse> updateCache(InternalService.PUpdateCacheRequest request) {
        return this.stub.updateCache(request);
    }

    public Future<InternalService.PFetchCacheResult> fetchCache(InternalService.PFetchCacheRequest request) {
        return this.stub.fetchCache(request);
    }

    public Future<InternalService.PCacheResponse> clearCache(InternalService.PClearCacheRequest request) {
        return this.stub.clearCache(request);
    }

    public Future<InternalService.PProxyResult> getInfo(InternalService.PProxyRequest request) {
        return this.stub.getInfo(request);
    }

    public Future<InternalService.PSendDataResult> sendData(InternalService.PSendDataRequest request) {
        return this.stub.sendData(request);
    }

    public Future<InternalService.PRollbackResult> rollback(InternalService.PRollbackRequest request) {
        return this.stub.rollback(request);
    }

    public Future<InternalService.PCommitResult> commit(InternalService.PCommitRequest request) {
        return this.stub.commit(request);
    }

    public Future<InternalService.PConstantExprResult> foldConstantExpr(InternalService.PConstantExprRequest request) {
        return this.stub.foldConstantExpr(request);
    }

    public void shutdown() {
        if (!this.channel.isShutdown()) {
            this.channel.shutdown();
            try {
                if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.warn("Timed out gracefully shutting down connection: {}. ", (Object)this.channel);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (!this.channel.isTerminated()) {
            this.channel.shutdownNow();
            try {
                if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                    LOG.warn("Timed out forcefully shutting down connection: {}. ", (Object)this.channel);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
        LOG.warn("shut down backend service client: {}", (Object)this.address);
    }
}

