/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite.mvrewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.CreateMaterializedViewStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class HLLHashToSlotRefRule
implements ExprRewriteRule {
    public static final ExprRewriteRule INSTANCE = new HLLHashToSlotRefRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        SlotRef queryColumnSlotRef;
        if (!(expr instanceof FunctionCallExpr)) {
            return expr;
        }
        FunctionCallExpr fnExpr = (FunctionCallExpr)expr;
        String fnNameString = fnExpr.getFnName().getFunction();
        if (!(fnNameString.equalsIgnoreCase("hll_union") || fnNameString.equalsIgnoreCase("hll_raw_agg") || fnNameString.equalsIgnoreCase("hll_union_agg"))) {
            return expr;
        }
        if (!(fnExpr.getChild(0) instanceof FunctionCallExpr)) {
            return expr;
        }
        FunctionCallExpr child0FnExpr = (FunctionCallExpr)fnExpr.getChild(0);
        if (!child0FnExpr.getFnName().getFunction().equalsIgnoreCase("hll_hash")) {
            return expr;
        }
        if (child0FnExpr.getChild(0) instanceof SlotRef) {
            queryColumnSlotRef = (SlotRef)child0FnExpr.getChild(0);
        } else if (child0FnExpr.getChild(0) instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)child0FnExpr.getChild(0);
            if (!(castExpr.getChild(0) instanceof SlotRef)) {
                return expr;
            }
            queryColumnSlotRef = (SlotRef)castExpr.getChild(0);
        } else {
            return expr;
        }
        Column column = queryColumnSlotRef.getColumn();
        Table table = queryColumnSlotRef.getTable();
        if (column == null || table == null || !(table instanceof OlapTable)) {
            return expr;
        }
        OlapTable olapTable = (OlapTable)table;
        String queryColumnName = column.getName();
        String mvColumnName = CreateMaterializedViewStmt.mvColumnBuilder(AggregateType.HLL_UNION.name().toLowerCase(), queryColumnName);
        Column mvColumn = olapTable.getVisibleColumn(mvColumnName);
        if (mvColumn == null) {
            return expr;
        }
        return this.rewriteExpr(fnNameString, queryColumnSlotRef, mvColumn, analyzer);
    }

    private Expr rewriteExpr(String fnName, SlotRef queryColumnSlotRef, Column mvColumn, Analyzer analyzer) {
        Preconditions.checkNotNull((Object)mvColumn);
        Preconditions.checkNotNull((Object)queryColumnSlotRef);
        TableName tableName = queryColumnSlotRef.getTableName();
        Preconditions.checkNotNull((Object)tableName);
        SlotRef mvSlotRef = new SlotRef(tableName, mvColumn.getName());
        ArrayList newFnParams = Lists.newArrayList();
        newFnParams.add(mvSlotRef);
        FunctionCallExpr result = new FunctionCallExpr(fnName, (List<Expr>)newFnParams);
        result.analyzeNoThrow(analyzer);
        return result;
    }
}

