/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite.mvrewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import org.apache.doris.analysis.CastExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.rewrite.mvrewrite.MVExprEqualRule;
import org.apache.doris.rewrite.mvrewrite.MVExprEquivalent;

public class FunctionCallEqualRule
implements MVExprEqualRule {
    public static MVExprEqualRule INSTANCE = new FunctionCallEqualRule();
    private static final ImmutableSetMultimap<String, String> columnAggTypeMatchFnName;

    @Override
    public boolean equal(Expr queryExpr, Expr mvColumnExpr) {
        Expr mvColumnFnChild0;
        if (!(queryExpr instanceof FunctionCallExpr) || !(mvColumnExpr instanceof FunctionCallExpr)) {
            return false;
        }
        FunctionCallExpr queryFn = (FunctionCallExpr)queryExpr;
        FunctionCallExpr mvColumnFn = (FunctionCallExpr)mvColumnExpr;
        if (!columnAggTypeMatchFnName.get((Object)mvColumnFn.getFnName().getFunction()).contains((Object)queryFn.getFnName().getFunction().toLowerCase())) {
            return false;
        }
        if (queryFn.getChildren().size() != mvColumnFn.getChildren().size()) {
            return false;
        }
        Preconditions.checkState((queryFn.getChildren().size() == 1 ? 1 : 0) != 0);
        Expr queryFnChild0 = (Expr)queryFn.getChild(0);
        if (queryFnChild0 instanceof CastExpr) {
            queryFnChild0 = (Expr)queryFnChild0.getChild(0);
        }
        if ((mvColumnFnChild0 = (Expr)mvColumnFn.getChild(0)) instanceof CastExpr) {
            mvColumnFnChild0 = (Expr)mvColumnFnChild0.getChild(0);
        }
        return MVExprEquivalent.mvExprEqual(queryFnChild0, mvColumnFnChild0);
    }

    static {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)"sum", (Object)"sum");
        builder.put((Object)"max", (Object)"max");
        builder.put((Object)"min", (Object)"min");
        builder.put((Object)"bitmap_union", (Object)"bitmap_union");
        builder.put((Object)"bitmap_union", (Object)"bitmap_union_count");
        builder.put((Object)"hll_union", (Object)"hll_union_agg");
        builder.put((Object)"hll_union", (Object)"hll_union");
        builder.put((Object)"hll_union", (Object)"hll_raw_agg");
        builder.put((Object)"to_bitmap", (Object)"to_bitmap");
        builder.put((Object)"hll_hash", (Object)"hll_hash");
        columnAggTypeMatchFnName = builder.build();
    }
}

