/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite.mvrewrite;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CreateMaterializedViewStmt;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class CountFieldToSum
implements ExprRewriteRule {
    public static final ExprRewriteRule INSTANCE = new CountFieldToSum();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        if (!(expr instanceof FunctionCallExpr)) {
            return expr;
        }
        FunctionCallExpr fnExpr = (FunctionCallExpr)expr;
        if (!fnExpr.getFnName().getFunction().equalsIgnoreCase("count")) {
            return expr;
        }
        if (fnExpr.getChildren().size() != 1 || !(fnExpr.getChild(0) instanceof SlotRef)) {
            return expr;
        }
        if (fnExpr.getParams().isDistinct()) {
            return expr;
        }
        SlotRef fnChild0 = (SlotRef)fnExpr.getChild(0);
        Column column = fnChild0.getColumn();
        Table table = fnChild0.getTable();
        if (column == null || table == null || !(table instanceof OlapTable)) {
            return expr;
        }
        OlapTable olapTable = (OlapTable)table;
        String queryColumnName = column.getName();
        String mvColumnName = CreateMaterializedViewStmt.mvColumnBuilder("count", queryColumnName);
        Column mvColumn = olapTable.getVisibleColumn(mvColumnName);
        if (mvColumn == null) {
            return expr;
        }
        return this.rewriteExpr(mvColumn, analyzer);
    }

    private Expr rewriteExpr(Column mvColumn, Analyzer analyzer) {
        Preconditions.checkNotNull((Object)mvColumn);
        SlotRef mvSlotRef = new SlotRef(null, mvColumn.getName());
        ArrayList newFnParams = Lists.newArrayList();
        newFnParams.add(mvSlotRef);
        FunctionCallExpr result = new FunctionCallExpr("sum", (List<Expr>)newFnParams);
        result.analyzeNoThrow(analyzer);
        return result;
    }
}

