/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite.mvrewrite;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionParams;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class CountDistinctToBitmapOrHLLRule
implements ExprRewriteRule {
    public static final ExprRewriteRule INSTANCE = new CountDistinctToBitmapOrHLLRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        if (ConnectContext.get() == null || !ConnectContext.get().getSessionVariable().isRewriteCountDistinct()) {
            return expr;
        }
        if (!(expr instanceof FunctionCallExpr)) {
            return expr;
        }
        FunctionCallExpr fnExpr = (FunctionCallExpr)expr;
        if (!fnExpr.isCountDistinctBitmapOrHLL()) {
            return expr;
        }
        FunctionParams newParams = new FunctionParams(false, fnExpr.getParams().exprs());
        if (((Expr)fnExpr.getChild(0)).getType().isBitmapType()) {
            FunctionCallExpr bitmapExpr = new FunctionCallExpr("bitmap_union_count", newParams);
            bitmapExpr.analyzeNoThrow(analyzer);
            return bitmapExpr;
        }
        FunctionCallExpr hllExpr = new FunctionCallExpr("hll_union_agg", newParams);
        hllExpr.analyzeNoThrow(analyzer);
        return hllExpr;
    }
}

