/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.function.Function;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionParams;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class RewriteFromUnixTimeRule
implements ExprRewriteRule {
    public static RewriteFromUnixTimeRule INSTANCE = new RewriteFromUnixTimeRule();
    private final ImmutableMap<String, String> beSupportFormatMap = ImmutableMap.builder().put((Object)"%Y%m%d", (Object)"yyyyMMdd").put((Object)"%Y-%m-%d", (Object)"yyyy-MM-dd").put((Object)"%Y-%m-%d %H:%i:%s", (Object)"yyyy-MM-dd HH:mm:ss").build();
    private final ImmutableMap<String, Function<String, Long>> parseMillisFunctionMap = ImmutableMap.builder().put((Object)"yyyyMMdd", str -> LocalDate.parse(str, DateTimeFormatter.ofPattern("yyyyMMdd")).atStartOfDay().toEpochSecond(OffsetDateTime.now().getOffset())).put((Object)"yyyy-MM-dd", str -> LocalDate.parse(str, DateTimeFormatter.ofPattern("yyyy-MM-dd")).atStartOfDay().toEpochSecond(OffsetDateTime.now().getOffset())).put((Object)"yyyy-MM-dd HH:mm:ss", str -> LocalDateTime.parse(str, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toEpochSecond(OffsetDateTime.now().getOffset())).build();

    Function<String, Long> getParseSecondsFunction(String formatStr) {
        String patternStr;
        if (this.beSupportFormatMap.containsValue((Object)formatStr)) {
            patternStr = formatStr;
        } else if (this.beSupportFormatMap.containsKey((Object)formatStr)) {
            patternStr = (String)this.beSupportFormatMap.get((Object)formatStr);
        } else {
            return null;
        }
        return (Function)this.parseMillisFunctionMap.get((Object)patternStr);
    }

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        String formatStr;
        if (!(expr instanceof BinaryPredicate)) {
            return expr;
        }
        BinaryPredicate bp = (BinaryPredicate)expr;
        Expr left = (Expr)bp.getChild(0);
        if (!(left instanceof FunctionCallExpr)) {
            return expr;
        }
        FunctionCallExpr fce = (FunctionCallExpr)left;
        if (!fce.getFnName().getFunction().equalsIgnoreCase("from_unixtime")) {
            return expr;
        }
        FunctionParams params = fce.getParams();
        if (params == null) {
            return expr;
        }
        if (params.exprs().size() != 1 && params.exprs().size() != 2) {
            return expr;
        }
        Expr paramSlot = params.exprs().get(0);
        if (!(paramSlot instanceof SlotRef)) {
            return expr;
        }
        SlotRef sr = (SlotRef)paramSlot;
        if (!sr.getColumn().getType().isIntegerType()) {
            return new BoolLiteral(false);
        }
        Expr right = (Expr)bp.getChild(1);
        if (!(right instanceof LiteralExpr)) {
            return expr;
        }
        LiteralExpr le = (LiteralExpr)right;
        if (params.exprs().size() == 1) {
            formatStr = "yyyy-MM-dd HH:mm:ss";
        } else {
            LiteralExpr fm = (LiteralExpr)params.exprs().get(1);
            formatStr = fm.getStringValue();
        }
        Function<String, Long> parseSecondsFunction = this.getParseSecondsFunction(formatStr);
        if (null == parseSecondsFunction) {
            return expr;
        }
        try {
            LiteralExpr literalExpr = LiteralExpr.create(String.valueOf(parseSecondsFunction.apply(le.getStringValue())), Type.BIGINT);
            if (bp.getOp() == BinaryPredicate.Operator.LT || bp.getOp() == BinaryPredicate.Operator.LE) {
                BinaryPredicate r = new BinaryPredicate(bp.getOp(), sr, literalExpr);
                BinaryPredicate l = new BinaryPredicate(BinaryPredicate.Operator.GE, sr, LiteralExpr.create("0", Type.BIGINT));
                return new CompoundPredicate(CompoundPredicate.Operator.AND, r, l);
            }
            if (bp.getOp() == BinaryPredicate.Operator.GT || bp.getOp() == BinaryPredicate.Operator.GE) {
                BinaryPredicate l = new BinaryPredicate(bp.getOp(), sr, literalExpr);
                BinaryPredicate r = new BinaryPredicate(BinaryPredicate.Operator.LE, sr, LiteralExpr.create("253402271999", Type.BIGINT));
                return new CompoundPredicate(CompoundPredicate.Operator.AND, r, l);
            }
            return new BinaryPredicate(bp.getOp(), sr, literalExpr);
        }
        catch (DateTimeParseException e) {
            return expr;
        }
    }
}

