/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.rewrite;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.EncryptKeyRef;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.EncryptKey;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriteRule;
import org.apache.doris.rewrite.ExprRewriter;

public class RewriteEncryptKeyRule
implements ExprRewriteRule {
    public static ExprRewriteRule INSTANCE = new RewriteEncryptKeyRule();

    @Override
    public Expr apply(Expr expr, Analyzer analyzer, ExprRewriter.ClauseType clauseType) throws AnalysisException {
        if (expr instanceof EncryptKeyRef) {
            EncryptKey encryptKey = ((EncryptKeyRef)expr).getEncryptKey();
            LiteralExpr literalExpr = LiteralExpr.create(encryptKey.getKeyString(), Type.VARCHAR);
            return literalExpr;
        }
        return expr;
    }
}

